/*----------------------------------------------------------------------------
 Author:         Markus Kotschenreuther

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der
 GNU General Public License, wie von der Free Software Foundation verffentlicht,
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder
 (nach Ihrer Option) jeder spteren Version.

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung,
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE,
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License.

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem
 Programm erhalten haben.
 Falls nicht, schreiben Sie an die Free Software Foundation,
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
*/

#include <avr/pgmspace.h>
#include <avr/io.h>
#include "stdio.h"
#include "config.h"
#include "networkcard/enc28j60.h"
#include "stack.h"
#include "timer.h"
#include "uart.h"
#include "httpd.h"
#include "froeling_com.h"

//----------------------------------------------------------------------------
//Main Program

int main(void)
{
	// local variables
    unsigned long a;

    // init UART
    uart_init();

	// init ethernet
	stack_init();
	httpd_init();

	// init froeling statemachine
	FroeCom_Init();

	//Ethernetcard Interrupt enable
	ETH_INT_ENABLE;

	// wait some time
	for(a=0;a<1000000;a++){asm("nop");};

	//Globale Interrupts einschalten
	sei();

#if(DEBUG_LEVEL >= 1)

#endif

	// MAINLOOP
	//************************************************
	while(1)
	{
		eth_get_data();

		// froeling communication statemachine
		FroeComSTM();

    }//while (1)

return(0);
}

