/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:
 known Problems: none
 Version:        24.10.2007
 Description:    Timer Routinen

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/
#include "timer.h"

volatile unsigned long time;
volatile unsigned long time_watchdog = 0;
volatile unsigned long sub_ticks = 0;

//----------------------------------------------------------------------------
//Diese Routine startet und inizialisiert den Timer
void timer_init (void)
{
	// Quarz: 16000000 Hz / Prescaler 1024 = 15625
	// Compare register = 0...124 => interrupt handler is called 15625 / 125 times = 125 times/s
	TCCR0= (1<<WGM01) | (1<<CS00 | 0<<CS01 | 1<<CS02);		// set counter prescaler to
	TCNT0=0x00;				// set counter start value to 0
	OCR0=0x7C;				// set compare register to 125 - interrupt when reg = 125
	TIMSK= (1 << OCIE0);    // set compare interrupt enable
return;
};

//----------------------------------------------------------------------------
//Timer Interrupt
ISR(TIMER0_COMP_vect) //125Hz
{
	sub_ticks++;

	if(sub_ticks>=125)
	{
		sub_ticks=0;
		time++;

		// reset second counter on midnight
		if(time == 86400){
			time = 0;
		}

		if((stack_watchdog++) > WTT)  //emergency reset of the stack
		{
			RESET();
		}
		eth.timer = 1;
	}
}
