#ifndef _UART_H_
#define _UART_H_

#include <avr/io.h>

extern void uart_init(void);
extern int uart_putc (const uint8_t);
extern uint8_t uart_getc_wait(void);
extern int     uart_getc_nowait(void);
extern void uart_puts(const char *s);
extern void uart_direct_puts(const char *s);
extern void uart_fifo_flush (void);

static inline void uart_flush(void)
{
	while (UCSRB & (1 << UDRIE));
}

static inline int uart_direct_putc (char c)
{
	if (c == '\n')
		uart_direct_putc('\r');
	
    // Warten, bis UDR bereit ist fr einen neuen Wert 
    while (!(UCSRA & (1 << UDRE)))
        ;

    // UDR Schreiben startet die bertragung 
    UDR = c;

    return 1;
}

#endif /* _UART_H_ */
