/***********************************\
* 				   	*
*  	*
*									*
* Datei: mmc.c						*
*									*
\***********************************/

#include "main.h"
#include <stdio.h>
#include "mmc.h"



/***********************************\
* MMC_Write_Byte				   	*
* Byte an Speicherkarte senden		*
*									*
* Parameter: Byte					*
* Rckgabe: void					*
\***********************************/
void MMC_Write_Byte (unsigned char Byte)
{
	SSCTB = Byte; 	 //Byte in Sendepuffer
	while (!SSCRIR); //Wartet bis Byte gesendet wurde (SSCRIR = 1)
	SSCRIR = 0;		 //bertragungsflag lschen
}

/***********************************\
* MMC_Read_Byte					   	*
* Byte von Speicherkarte lesen		*
*									*
* Parameter: void					*
* Rckgabe: Byte					*
\***********************************/
unsigned char MMC_Read_Byte (void)
{
	SSCTB = 0xFF;   //Sendet Dummy-Byte um Byte zu empfangen
	while(!SSCRIR);	//Wartet bis Byte gesendet wurde (SSCRIR = 1)
	SSCRIR = 0;	 	//bertragungsflag lschen
	return (SSCRB);
}

/***********************************\
* MMC_Write_Command				   	*
* Byte an Speicherkarte senden		*
*									*
* Parameter: 6 Byte Befehl			*
* Rckgabe: Antwort der Karte		*
\***********************************/
unsigned char MMC_Write_Command (unsigned char *send)
{
	unsigned char tmp = 0xFF;
	unsigned int Timeout = 0;
	unsigned int a;

	#if (DEBUG > 1)
	printf("Write_Command:");
	#endif

	LED_MMC = ~LED_MMC; //LED blinken

	MMC_Disable(); 

	//sendet 8 Clock Impulse
	MMC_Write_Byte(0xFF);

	//set MMC_Chip_Select to low (MMC/SD-Karte Aktiv)
	MMC_Enable();

	for (a=0; a<6; a++) //sendet 6 Byte Commando zur MMC/SD-Karte
		{
		#if (DEBUG > 0) 
		printf("%c",*send);	
		if (a == 5) printf("\n");
		#endif
		MMC_Write_Byte(*send++);
		}

	//Wartet auf ein gltige Antwort von der MMC/SD-Karte
	while (tmp == 0xFF)	//Karte muss mit etwas anderem als FF antworten
		{
		tmp = MMC_Read_Byte();
		#if (DEBUG > 0)			 
		printf("Read_Byte:%c\n",tmp);
		#endif
		if (Timeout++ > 200)
			{
			LED_ERR = ~LED_ERR;
			break; //Abbruch da die MMC/SD-Karte nicht Antwortet
			}			  
		} 
		return(tmp);
}

/***********************************\
* MMC_Init						   	*
* Karte und Schnittstelle init.		*
*									*
* Parameter: void					*
* Rckgabe: 0: erfolgreich			*
*			1: Prob. bei CMD0		*
*			2: Prob. bei CMD1		*
\***********************************/
unsigned char MMC_Init (void)
{
	unsigned char Timeout = 0;
    unsigned char a;
	unsigned char CMD[] = {0x40,0x00,0x00,0x00,0x00,0x95};

	SSCEN = 0;

	//SSC - Anschlsse programmieren
	dSPI_CLK = 1;            //SCLK ist Ausgang
	SPI_CLK = 1;             //Leitung High
	dSPI_MTSR = 1;           //MTSR ist Ausgang
	SPI_MTSR = 1;            //Leitung High
	dSPI_MRST = 0;           //MRST ist Eingang 
	dMMC_Chip_Select = 1;	 //Chip Select ist Ausgang
//	dMMC_Card_Insert = 0;    //Eingang
// 	MMC_Card_Insert = 0;	 //wird noch nicht berprft


	MMC_Disable(); 

	#if (DEBUG > 0)
	printf(">>>MMC Init Start\n");
	#endif

	 SSCBR = 49;           // 49 = 400 kBaud
	 //Freigabe Master - keine Fehlerprfung - MSB 8 Bit
	 SSCCON = 0x0c057;     // 1 1 - 00000 - 1 0 1 0111       

	SSCTIR = 1;

	for(a=0; a<200; a++)
		_nop();		//Wartet eine kurze Zeit


	//Initialisiere MMC/SD-Karte in SPI-Modus
	for (a=0; a<0x0F; a++) //Sendet min 74+ Clocks an die MMC/SD-Karte
		MMC_Write_Byte(0xFF);

	
	//Sendet CMD0 an MMC/SD-Karte
	#if (DEBUG > 1)
	printf("Schreibe CMD0\n");
	#endif

   	while(MMC_Write_Command (CMD) !=0x01)
	{
		if (Timeout++ > 200)
			{
			#if (DEBUG > 1)
			printf("***Abbruch bei CMD0\n");
			#endif
	   		return(1); //Abbruch bei CMD0 (Return Code1)
			}
	} 

	#if (DEBUG > 1)
	printf("Schreibe CMD1\n");
	#endif

	//Sendet CMD1 an MMC/SD-Karte 
	//CMD1 bei MMC Karten und "dicken" SD-Karten, bei "dnnen" SD-Karten nur ACMD41
	Timeout = 0;
	CMD[0] = 0x41;
	CMD[5] = 0xFF;
  	while(MMC_Write_Command (CMD) !=0)
	{
		if (Timeout++ > 100)
			{
			#if (DEBUG > 1)
			printf("***Abbruch bei CMD1\n");
			#endif
	   		return(2); //Abbruch bei CMD1 (Return Code2)
			}
	} 

		////SPI Bus auf max Geschwindigkeit
		//SSCBR = 9;           // 3 = 5 MBaud	 //vorher SSCEN = 0; 
			
	MMC_Disable();

	#if (DEBUG > 0)
	printf("<<<MMC Init Ende\n");
	#endif

	return(0);
} 

/***********************************\
* MMC_Read_Block				   	*
* Block lesen von Karte				*
*									*
* Parameter: Kommando mit Startsec.	*
*			 Puffer					*
*			 Anzahl Bytes			* 
* Rckgabe: void					*
\***********************************/
void MMC_Read_Block (unsigned char *CMD, unsigned char *Buffer, unsigned int Bytes)
{	
	unsigned int a;
	unsigned int tmp;


	tmp = MMC_Write_Command (CMD);
	if (tmp != 0x00)
				{
			#if (DEBUG > 1)
			printf("Read Block return\n");
			#endif
			
			return;
			}
			
	//Wartet auf Start Byte von der MMC/SD-Karte (FEh/Start Byte)
	while (MMC_Read_Byte() != 0xFE){};	 


	//Lesen des Blocks (normal 512Bytes) von MMC/SD-Karte
	for (a=0; a<Bytes; a++)
		{
		*Buffer = MMC_Read_Byte();  //*Buffer++ = ....

		#if (DEBUG > 1)
	   	printf("%c",*Buffer);
		#endif

		*Buffer++;		//erst hier wegen debug ausgabe

		}

	//CRC-Byte auslesen
	MMC_Read_Byte(); //CRC - Byte wird nicht ausgewertet
	MMC_Read_Byte(); //CRC - Byte wird nicht ausgewertet
	
	MMC_Disable();
	
	return;	
}

/***********************************\
* MMC_Read_Sector				   	*
* Sektor lesen von Karte			*
*									*
* Parameter: Startsector			*
*			 Puffer					*
* Rckgabe: void					*
\***********************************/
void MMC_Read_Sector (unsigned long Sector, unsigned char *Buffer)
{	
	unsigned char CMD[] = {0x51,0x00,0x00,0x00,0x00,0xFF}; 
	/*Die Adressierung der MMC/SD-Karte wird in Bytes angegeben,
	  addr wird von Blocks zu Bytes umgerechnet danach werden 
	  diese in das Commando eingefgt*/
	
	#if (DEBUG > 1)
	printf(">>>Read_Sector:%ld\n",Sector);
	#endif
		  
	Sector <<= 9; //Sector = Sector * 512

	CMD[1] = ((Sector & 0xFF000000) >>24 );
	CMD[2] = ((Sector & 0x00FF0000) >>16 );
	CMD[3] = ((Sector & 0x0000FF00) >>8 );


	MMC_Read_Block(CMD,Buffer,512);
}

/***********************************\
* MMC_Write_Sector				   	*
* Sektor schreiben auf Karte 		*
*									*
* Parameter: Startsector			*
*			 Puffer					*
* Rckgabe: 0: ok					*
			sonst: Meldung der Karte*
\***********************************/
unsigned char MMC_Write_Sector (unsigned long Sector, unsigned char *Buffer)
{			
 	unsigned char tmp;
	unsigned int a;
	unsigned char CMD[] = {0x58,0x00,0x00,0x00,0x00,0xFF}; 

	#if (DEBUG > 1)
	printf(">>>Write_Sector:%ld\n",Sector);
	#endif
	  
	Sector <<= 9; //Sector = Sector * 512
	
	CMD[1] = ((Sector & 0xFF000000) >>24 );
	CMD[2] = ((Sector & 0x00FF0000) >>16 );
	CMD[3] = ((Sector & 0x0000FF00) >>8 );

	//Sendet Commando CMD24 an MMC/SD-Karte (Write 1 Block/512 Bytes)
	tmp = MMC_Write_Command (CMD);
	if (tmp != 0x00)
				{
			#if (DEBUG > 1)
			printf("Write_Sector return\n");
			#endif
			LED_ERR = ~LED_ERR;			
			return(tmp);
			}
			
	//sendet Clocks an die MMC/SD-Karte
	for (a=0; a<100; a++)	
	{						
	MMC_Write_Byte(0xFF);  
	}

	//Sendet Start Byte an MMC/SD-Karte
	MMC_Write_Byte(0xFE);	

	//Schreiben des Blocks (512Bytes) auf MMC/SD-Karte
	for (a=0; a<512; a++)
		{
		MMC_Write_Byte(*Buffer); //MMC_Write_Byte(*Buffer++);

		#if (DEBUG > 1)
	   	printf("%c",*Buffer);
		#endif

		*Buffer++;		//erst hier wegen debug ausgabe

		}
			
	//CRC-Byte schreiben
	MMC_Write_Byte(0xFF); //Schreibt Dummy CRC
	MMC_Write_Byte(0xFF); //CRC Code wird nicht benutzt
	
	//Wartet solange MMC/SD-Karte Busy
	while (MMC_Read_Byte() != 0xFF){}; 
		
	MMC_Disable();

	
return(0);
}

/***********************************\
* MMC_Read_CID					   	*
* CID-Register lesen				*
*									*
* Parameter: Puffer					*
* Rckgabe: void					*
\***********************************/
void MMC_Read_CID (unsigned char *Buffer)
{
	//Kommando zum Lesen des CID Registers
	unsigned char CMD[] = {0x4A,0x00,0x00,0x00,0x00,0xFF}; 
	#if (DEBUG > 1)
	unsigned char a;
	#endif
		
	MMC_Read_Block(CMD,Buffer,16);

	#if (DEBUG > 1)
	printf("CID-Register:");	
	for (a = 0;a<16;a++)
		printf("%c",Buffer[a]);
	printf("\n");
	#endif
}

/***********************************\
* MMC_Read_CSD					   	*
* CSD-Register lesen				*
*									*
* Parameter: Puffer					*
* Rckgabe: void					*
\***********************************/
void MMC_Read_CSD (unsigned char *Buffer) 
{	
	//Kommando zum Lesen des CSD Registers
	unsigned char CMD[] = {0x49,0x00,0x00,0x00,0x00,0xFF};
	#if (DEBUG > 1)
	unsigned char a;
	unsigned int c_size, c_size_mult, read_bl_len;
	unsigned long drive_size;
	unsigned long maxsect;
	#endif

	MMC_Read_Block(CMD,Buffer,16);

	#if (DEBUG > 1)
	printf("CSD-Register:");	
	for (a = 0;a<16;a++)
		printf("%c",Buffer[a]);
	printf("\n");

	c_size = (unsigned int)(Buffer[6] & 0x03)<<10 | (unsigned int)Buffer[7]<<2 | (unsigned int)Buffer[8]>>6;
	read_bl_len = 1;				 //rechnet gleich 2^read_bl_len aus
	read_bl_len <<= Buffer[5] & 0x0F;
	c_size_mult = 1;				//rechnet gleich 2^(c_size_mult+2) aus
	c_size_mult <<= ((unsigned int)(Buffer[9] & 0x03)<<1 | (unsigned int)Buffer[10]>>7)+2;
	drive_size = (unsigned long)(c_size+1) * (unsigned long)c_size_mult * (unsigned long)read_bl_len;
	maxsect = drive_size / 512;

	printf("c_size:%d\n",c_size);
	printf("c_size_mult:%d\n",c_size_mult);
	printf("read_bl_len:%d\n",read_bl_len);
	printf("drive_size:%ld\n",drive_size);
	printf("maxsect:%ld\n",maxsect);
	#endif
}