/***********************************\
* 			   	*
*  	*
*									*
* Datei: mmc.h						*
*									*
\***********************************/

/*     _________________
      /  1 2 3 4 5 6 78 |    Kontakte einer MMC/SD-Karte
     / 9                |    (8 und 9 sind nur bei SD-Karten vorhanden)
     |    MMC/SD Karte  |
     |                  |
     /\/\/\/\/\/\/\/\/\/\
     1 - CS   				- Chip Select (P3.7)
     2 - DIN  (Karte<-Host)	- mit MTSR Pin (P3.9) verbinden
     3 - VSS                - GND
     4 - VDD  				- 3,3V Versorgungsspannung
     5 - SCLK            	- an SSC CLK (P3.13) anschlieen
     6 - VSS                - GND
     7 - DOUT (Karte->Host)	- mit MRST Pin (P3.8) verbinden
*/

//MMC_Chip_Select high (MMC/SD-Karte Inaktiv):
#define MMC_Disable() MMC_Chip_Select = 1;
//MMC_Chip_Select low (MMC/SD-Karte Aktiv):
#define MMC_Enable()  MMC_Chip_Select = 0;

_sfrbit  dSPI_CLK 			_atbit(DP3,13);  //SCLK Richtung 
_sfrbit  SPI_CLK  			_atbit(P3,13);   //SCLK 
_sfrbit  dSPI_MTSR 			_atbit(DP3,9);   //MTSR Richtung 
_sfrbit  SPI_MTSR  			_atbit(P3,9);    //MTSR 
_sfrbit  dSPI_MRST 			_atbit(DP3,8);   //MRST Richtung 
_sfrbit  dMMC_Chip_Select  	_atbit(DP3,7);	 //Chip Select Richtung
_sfrbit  MMC_Chip_Select   	_atbit(P3,7);	 //Chip Select

/* noch nicht implementiert:
_sfrbit  dMMC_Card_Insert  	_atbit(DP8,7);	 //(Card Insert) Richtung
_sfrbit  MMC_Card_Insert   	_atbit(P8,7);	 //(Card Insert)
*/


void MMC_Write_Byte (unsigned char Byte);
unsigned char MMC_Read_Byte (void);
unsigned char MMC_Write_Command (unsigned char *send);
unsigned char MMC_Init (void);
void MMC_Read_Sector (unsigned long Sector, unsigned char *Buffer);
unsigned char MMC_Write_Sector (unsigned long Sector, unsigned char *Buffer);
void MMC_Read_CID (unsigned char *Buffer);
void MMC_Read_CSD (unsigned char *Buffer);