{   obcc, a small oberoncompiler for the C16x-family
      based on Oberon-0 by N. Wirth

    Copyright Guido B. (user "guido-b" at http://www.mikrocontroller.net)
    
    obcc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    obcc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with obcc.  If not, see <http://www.gnu.org/licenses/>.                }


program obcc; { starts the oberon compiler for C167 }
uses C167CR, obcd, obcp;

var s, op: string;
    n,i, cod: INTEGER;
    arg: LONGINT;
    f: Text;
    defregs: Boolean;
    
	Procedure Defaultsfr;
	Var i: Integer; lst: Psfr; 
	Begin
	  For i := 0 To last_sfr_index Do Begin
	    New(lst); lst^.next := listsfr; listsfr := lst;
	    lst^.name := C167sfr[i].Name; lst^.adr := C167sfr[i].adr;
	  End;
	End;
	
	Procedure LoadInts(VAR t: Text);
	Var i, nr: Integer; s1, s2: String; adr:Longint;
	Begin
	  For i := 0 To maxvector Do Begin
	    Vektoren[i].name := '';
	    Vektoren[i].used := False; End;
	  While Not Eof(t) do Begin
	    Readln(t, s1);
	    i := Pos(',', s1); s2 := copy(s1, 1, i - 1);
	    Delete(s1, 1, i + 1); 
	    val(s2, nr, i);
	    i := Pos(',', s1); s2 := copy(s1, 1, i - 1);
	    Delete(s1, 1, i + 1); 
	    Vektoren[nr].name := s2;
	    //i := pos('h', s1); delete(s1, i, 1); s1 := '$' + s1;
	    val(s1, adr, i);
	    Vektoren[nr].adr := adr;
	  End;
	End;
	
	Procedure Loadsfr(fn:String);
	Var i: Integer; t: Text; lst: Psfr; s, name: String; 
	    l: Longint; ok: Boolean;
	Begin {$i-}
	  assign(t, fn); reset(t);
	  {$i+} i := IOresult;
	  IF i = 0 THEN Begin
	    Writeln('   Include: ', fn); ok := False;
	    While (Not Eof(t)) And (Not ok) Do Begin
	      New(lst); lst^.next := listsfr; listsfr := lst;
	      Readln(t, s);
	      If pos('Vectors:', s) = 0 Then Begin
		i := Pos(',', s); name := copy(s, 1, i - 1);
		Delete(s, 1, i + 1); lst^.name := name;
		val(s, l, i);
		If i = 0 Then lst^.adr := l
		Else Writeln(s, ' wie umwandeln?');
	      End
	      Else ok := True;
	    End; 
	    defregs := False; 
	    If ok Then LoadInts(t);
	    Close(t);
	  End
	  Else 
	    Writeln('File not found: ', fn, ' using defaults');
	End;
	
	Procedure help;
	BEGIN
	  writeln('Oberon compiler for C16x version ',verstr, ', usage:'); writeln;
	  writeln(' obcc [ option ] filename'); writeln;
	  writeln('Possible options:'); writeln;
	  Writeln('    -ir"filename": Include definitions. Without this Option the');
	  Writeln('                   C167CR-definitions are used (no file required).');
	  writeln('    -ps"n": Programstartaddress, even n, less than 64 k (default: 0)');writeln;
	  writeln('    -ws"n": Number of waitstates, n = 0 ...15 (default: 2)');writeln;
	  writeln('    -rs"n": Ramstartaddress (default $E000, start of XRAM)'); writeln;
	  writeln('    -re"n": Last ramaddress (default $E7FE, end of XRAM)'); writeln;
	  writeln('    -sp"n": Startvalue for Stackpointer (default $FCE0)'); writeln;
	  //writeln('    -ss"n": Stacksize in Bytes (default 1024)'); writeln;
	  writeln('    -cp"n": Startvalue for Contextpointer (default $F600)'); writeln;
	  writeln('    -op"n": Optimization level, n = 0..2 (default: 0)'); writeln;
	  writeln('    -wd"n": Watchdog, n=1: enabled, n=0: disabled (default: 0)'); writeln;
	  writeln('    -im"n": n = 1: compile as importable module (default: 0)'); writeln;
	  writeln('    -db"n": DebugLevel (default: 0, no debugging)'); writeln; 
	  writeln('    -as"n": Use ASCn for read/write (default: 0)'); writeln;
	  writeln('    -uu"n": n = 1: Convert all input to upper case (default: 0)');  writeln; 
	  writeln('    -uw"n": Use Write or Writeln, n = 1: enabled (default: 1)');  writeln;  writeln; 
	  writeln(' Hint: If n is hex escape the dollar-sign (e.g.: \$)'); writeln;
	END;


BEGIN verstr := '0.50'; defregs := True;
  n:= ParamCount;
  IF n = 0 THEN help
  ELSE BEGIN i := 1;
    WHILE i < n DO BEGIN
      s := Paramstr(i);
      IF s[1] = '-' THEN BEGIN
        delete(s,1,1); 
        IF s = 'h' THEN BEGIN help; exit; END
        ELSE BEGIN 
          op := copy(s,1,2); 
          If op <> 'ir' Then Begin delete(s,1,2); val(s, arg, cod); end
          Else Begin delete(s,1,2); Loadsfr(s); End;
        END;
        //writeln(op, ', ', arg);
        IF cod <> 0 THEN BEGIN writeln('Value? ', s); exit; END; 
        IF op = 'ps' THEN progstart := arg
        ELSE IF op = 'ws' THEN waitstates := arg
        ELSE IF op = 'rs' THEN BEGIN
	  ramstart := arg; rammapped := TRUE; END
        ELSE IF op = 're' THEN BEGIN 
	  ramstop := arg; rammapped := TRUE; END
	ELSE IF op = 'sp' THEN stackp := arg
	//ELSE IF op = 'ss' THEN stacksize := arg
	ELSE IF op = 'cp' THEN contextp := arg
        ELSE IF op = 'op' THEN oplevel := arg
        ELSE IF op = 'wd' THEN BEGIN
          IF arg = 1 THEN watchdog := TRUE; END
        ELSE IF op = 'im' THEN BEGIN
	  IF DebugLevel > 0 THEN BEGIN
	    WriteLn('-im1 and -db1 can not be combined!'); Exit; END
	  ELSE BEGIN
	    IF arg = 1 THEN impmod := TRUE; END;
	END
	ELSE IF op = 'uu' Then Begin
	  writeln('using upper');
	  If arg = 1 Then UseUpper := TRUE; End
	ELSE IF op = 'uw' THEN BEGIN
	  IF arg <> 1 THEN UseWrite := FALSE; END
	ELSE IF op = 'db' THEN BEGIN
	  IF impmod THEN BEGIN
	    WriteLn('-im1 and -db1 can not be combined!'); Exit; END
	  ELSE BEGIN
	    DebugLevel := arg; END;
	END
	ELSE IF op = 'as' THEN AscPort := arg
        ELSE If op <> 'ir' Then BEGIN writeln('Unknown option: ',op); exit; END;
      END
      ELSE BEGIN 
        writeln('Unknown option: ', s); exit; END;
      i := i + 1;
    END;
    s := Paramstr(n); 
    n:=  pos('.mod', s);
    IF n <> 0 THEN delete(s,n,4);
    IF progstart = 0 THEN BEGIN
      {$I-}
      assign(f, 'Startup.asm'); reset(f);
      {$I+} i := IOresult;
      IF i = 0 THEN BEGIN 
        ConfFile := 'Startup.asm';
        Close(f);
      END;
    END;
    IF rammapped THEN BEGIN
      IF (ramstop - ramstart) > $FFFE THEN BEGIN
        Writeln(' defined RAM too large!'); exit; end;
      IF (ramstop - ramstart) < 2046 THEN BEGIN
	Writeln(' defined RAM too small!'); exit; END;
    END;
    op := s + '.mod'; {$i-}
    assign(f, op); reset(f);
    {$i+} i := IOresult;
    IF i <> 0 THEN BEGIN
      writeln(op, ' does not exist!'); exit; END;
    close(f);     
    If defregs Then Defaultsfr;
    compile(s); 
  END;
END.