{   obcc, a small oberoncompiler for the C16x-family
      based on Oberon-0 by N. Wirth

    Copyright Guido B. (user "guido-b" at http://www.mikrocontroller.net)

    obcd.pas, common declarations, is part of obcc.
    
    obcc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    obcc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with obcc.  If not, see <http://www.gnu.org/licenses/>.                       }

unit obcd; { Gemeinsame Deklarationen }

interface
     
CONST //maxCode = 10000; maxRel = 200; NofCom = 16;
      IdLen = 64;
    (* class / mode *) g_Head = 0;
      g_Var = 1; g_Par = 2; g_Const = 3; g_Fld = 4; g_Typ = 5; g_Proc = 6; 
      g_ProcR = 7; g_SProc = 8;
      g_Int = 9; g_Reg = 10; g_Cond = 11; g_SFR = 12; g_String = 13;
      g_mod = 14; //g_adr = 15; 
      g_ptr = 16; g_table = 17;
    (* form *) 
      g_Boolean = 0; g_Integer = 1; g_Word = 2; g_Array = 3; g_Record = 4; g_SFRF = 5; g_stringf = 6;
      g_Pointer = 7; g_Tablef = 8;

	maxvarcnt = 16; { in Bytes }
	maxvector = 127;
	maxstringref = 64;
	
	FSP = 0; FP = 1; g_PC = 16;  (*reserved registers*)

TYPE g_Object = ^ObjDesc; 
    g_Type = ^TypeDesc;
    Psfr = ^Tsfr;
    stringp = ^stringt;
    tabp = ^tabt;
    labp = ^labt;
    
    Ident = String[IdLen]; { aus dem Scanner uebernommen }

    g_Item = RECORD
      mode, lev: INTEGER;
      i_type: g_Type;
      a, b, c, r: LONGINT;
      tok: String;
    END ;

    ObjDesc= RECORD
      class, lev: INTEGER;
      next, dsc: g_Object;
      o_type: g_Type;
      name: Ident;
      val: LONGINT;
      IsPara, exported: BOOLEAN;
      rtype: g_Type; { Typ funktionaler Proceduren, sonst Nil}
      adr: Word;
    END ;

    TypeDesc = RECORD
      form, ref: INTEGER;
      fields: g_Object;
      base: g_Type;
      size, len: INTEGER
    END ;
    
    Tsfr = Record
      name: String;
      adr: Longint;
      next: Psfr;
    End;
    
    Vekt = RECORD
      name: STRING;
      adr: LONGINT;
      used: BOOLEAN;
    END;
    
    stringt = RECORD
      nr, lev: INTEGER;
      inh: string[idlen];
      refs: Array[0 .. maxstringref] Of Word;
      next: stringp;
    END;
    
    tabt = RECORD
      nr, lev: INTEGER;
      inh: ARRAY[1.. 512] OF Word;
      len: INTEGER; { in Words }
      refs: Array[0 .. maxstringref] Of Word;
      next: tabp;
    End;
    
    labt = Record
      nr: Longint;
      start, ziel: Word;
      refs: Array[0 .. maxstringref] Of Word;
      next: labp;
    End;

    Tsfrreg = Record
      reg: Integer;
      adr: LongInt;
    End;
       
VAR
    vektoren: ARRAY[0..maxvector] OF Vekt;
    
    i: Integer; { fuer die Initialisierung }
    nextstring: INTEGER;
    nexttab: Word;
    tnextreg, tlastreg: INTEGER;
    stringl: stringp;
    tabl: tabp;
    labl: labp; 
{ SFR-Liste usw.: }    
    Listsfr: Psfr;
    CPreg: Integer; CPadr:Word; 
    
    curlev, pc: INTEGER;    
    Nextreg, Lastreg, Lastop, ParCount, maxreg: INTEGER;
    nextlab: Longint;
    oplevel: INTEGER;
    isproc: BOOLEAN; { Procedure-Declaration }
    smallproc, minreg: BOOLEAN;
    forloop : BOOLEAN;
    vnr: INTEGER; vstr: STRING;
    IsInt: BOOLEAN; { procedure is an interrupt }
    Regs: Array[1..15] OF Longint;
    RegUsed: ARRAY[1..15] OF INTEGER;
    ConfFile: String;
    DPP: ARRAY[0..3] OF INTEGER;
    ModName, MainName: Ident;
    CPinR2: Boolean; { zur Optimierung der Parameterübergabe kurz auf kurz }
    
    
    rammapped, impmod, write_used: BOOLEAN;
{ Compileroptionen: }
    UseUpper: BOOLEAN; { im Scanner! }
    UseWrite: BOOLEAN;
    watchdog: BOOLEAN;
    waitstates: INTEGER;
    DebugLevel, AscPort: Integer;
    verstr: STRING;
{ Code- und RAM-Verwaltung: }
    ramoffset: INTEGER;
    ramstart, ramstop, ramtop, progstart, stackp, stacksize, contextp, HeapTop: LONGINT;
    //cl: LongInt; {Codelaenge }    
    vartop: LONGINT;
{ aufzuloesende Referenzen, ev. noch Segment dazu: }
    setheaptop, mainstart: Word;
    //resetref: Word; { sollte $0200 sein }
{ odeerzeugung: }
    code: Array [0..$FFFF] Of Byte;
    cap, aseg: Word; {CodeArrayPointer, aktuelles Segment }
    
{ Globale Linkliste, die vom Compiler aufgeloest werden muss. }
    Link: RECORD
      { Indizes in code, die aufgeloest werden muessen: }
      Heapstart, Mainstart: WORD;
      { Zieladressen, die eingesetzt werden koennen: }
      Writesign, Writestr, WriteLN, Writeval, Writehex, Writechar: Word;
    END;
    
FUNCTION hexword(i:LONGINT):STRING;
FUNCTION hexbyte(i:Byte):STRING;
Function Fsfr(name: String): Tsfrreg;

Procedure addi(iw: Word);
Procedure addv(v: Word);
Procedure reslink(index, adr: Word);
Function rbj(ziel: Word): Byte;
Procedure rfj(start: Word; cond: Byte);
//Procedure inslab(lab: Longint);
implementation

	FUNCTION hexword(i:LONGINT):STRING;
	  var temp: INTEGER; 
	BEGIN hexword := '0';
	  IF i > $FFFF THEN BEGIN
	    temp := i div $10000; temp := temp div 16;
	    if temp < 10 then hexword := hexword + chr(temp + 48)
	    else hexword := hexword + chr(temp + 55);
	    temp := i div $10000; temp := temp mod 16;
	    if temp < 10 then hexword := hexword + chr(temp + 48)
	    else hexword := hexword + chr(temp + 55);
	    i := i MOD $10000;
	  END;
	  temp := i div (256); temp := temp div 16;
	  if temp < 10 then hexword := hexword + chr(temp + 48)
	  else hexword := hexword + chr(temp + 55);
	  temp := i div 256; temp := temp mod 16;
	  if temp < 10 then hexword := hexword + chr(temp + 48)
	  else hexword := hexword + chr(temp + 55);
	  temp := i mod 256; temp := temp div 16;
	  if temp < 10 then hexword := hexword + chr(temp + 48)
	  else hexword := hexword + chr(temp + 55);
	  temp := i mod 256; temp := temp mod 16;
	  if temp < 10 then hexword := hexword + chr(temp + 48)
	  else hexword := hexword + chr(temp + 55);
	  hexword := hexword + 'h';
	END;
	
	FUNCTION hexbyte(i:Byte):STRING;
	Var temp: Byte;
	Begin hexbyte := '0';
	  temp := i Div 16;
	  If temp < 10 Then hexbyte := hexbyte + chr(temp + 48)
	  Else hexbyte := hexbyte + chr(temp + 55);
	  temp := i Mod 16;
	  If temp < 10 Then hexbyte := hexbyte + chr(temp + 48)
	  Else hexbyte := hexbyte + chr(temp + 55);
	  hexbyte := hexbyte + 'h';
	End;
	
	Function Fsfr(name: String): Tsfrreg;
	Var f: Psfr; adr: Longint;
	Begin f := Listsfr;
	  While (f^.next <> Nil) And (f^.name <> name) Do
	    f := f^.next;
	  If f^.name = Name Then Begin
	    adr := f^.adr; Fsfr.adr := adr;
	    IF (adr < $FFFF) And (adr >= $FE00) Then
	      Fsfr.reg := (adr - $FE00) Div 2
	    Else If (adr < $F1FF) And (adr >= $F000) Then
	      Fsfr.reg := (adr - $F000) Div 2
	    Else Fsfr.reg := $100;
	  End
	  Else Begin
	    Fsfr.adr := -1; Fsfr.reg := -1;
	  End;
	End;
	
	{Instruction in code[cap] schreiben }
	Procedure addi(iw: Word);
	Begin code[cap] := iw Div 256; cap := cap + 1;
	  code[cap] := iw Mod 256; cap := cap + 1; 
	End;
	
	{ Wert geswappt in code[cap] schreiben }
	Procedure addv(v: Word);
	Begin code[cap] := v Mod 256; cap := cap + 1;
	  code[cap] := v Div 256; cap := cap + 1; 
	End;
	
	{ adr geswappt in code[index] schreiben }
	Procedure reslink(index, adr: Word);
	Begin code[index] := adr Mod 256;
	  code[index + 1] := adr Div 256; 
	End;
	
	{ Sprungdistanz fuer rel. Ruecksprung berechnen: }
	Function rbj(ziel: Word):Byte;
	Begin ziel := (cap - ziel + 2) Div 2;
	If ziel < 129 Then rbj := 256 - ziel
	Else Begin Writeln('Sprungdistanz zu groß!');
	  rbj := 0; End;
	End;
	
	{ Rel. Vorwaertssprung bei start einsetzen: }
	Procedure rfj(start: Word; cond: Byte);
	Var w: Word;
	Begin w := (cap - 2 - start) Div 2;
	  If w < 128 Then Begin
	    w := (cond * 256 * 16) + $0D00 + w;
	    code[start] := w Div 256; 
	    code[start + 1] := w Mod 256;
	  End
	  Else Writeln('Sprungdistanz zu groß!');
	End;
	
	{ Labelstart merken }
	Procedure inslab(lab: Longint);
	Var tl: labp;
	Begin tl := labl;
	  While (tl^.next <> Nil) And (tl^.nr <> -1) Do
	    tl := tl^.next;
	  If tl = Nil Then Begin
	    New(tl); tl^.next := labl; labl := tl; End;
	  tl^.nr := lab; tl^.start := cap; tl^.ziel := 0;
	End;
	
 
initialization

Nextstring := 0; nexttab := 0;
New(stringl); stringl^.inh := ''; stringl^.next := Nil;
stringl^.nr := nextstring;
For i := 0 To maxstringref Do stringl^.refs[i] := 0;

New(tabl); tabl^.next := Nil; tabl^.nr := nexttab; tabl^.len := 0;
For i := 0 To maxstringref Do tabl^.refs[i] := 0;

New(labl); labl^.next := Nil; labl^.nr := -1;
labl^.start := 0; labl^.ziel := 0;
//resetref := $0200;
UseWrite := TRUE;
cap := 0; aseg := 0;
While cap < $7FFF Do addi($CC00);
cap := 0;
end.