{   obcc, a small oberoncompiler for the C16x-family
      based on Oberon-0 by N. Wirth

    Copyright Guido B. (user "guido-b" at http://www.mikrocontroller.net)

    obcp.pas, the parser, is part of obcc.
    
    obcc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    obcc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with obcc.  If not, see <http://www.gnu.org/licenses/>.                }




unit obcp; { Der Parser }

interface
    
PROCEDURE Compile(fname: String);

implementation
uses obcd, obcs, obcg;

CONST WordSize = 2;
TYPE
  Pptr = ^Tptr;
  Tptr = Record
      name, base: String;
      next: Pptr;
  End;
  
VAR sym: INTEGER; 
    topScope, universe, imported: g_Object; (* linked lists, end with guard *)
    guard: g_Object; 
    ProcPar: BOOLEAN;
    lastlinenr: Integer;
    retdone: Boolean; { RETURN für Funktionsprozeduren in StatSequence gefunden }
    Listptr: Pptr;
    
	PROCEDURE NewObj(VAR obj: g_Object; class: INTEGER);
	  VAR pnew, x: g_Object; lst: Psfr;
	BEGIN 
	  lst := listsfr;
	  While (lst <> Nil) And (lst^.Name <> ID) Do
	    lst := lst^.next;
	  If lst <> Nil Then Mark('SFR-identifier!');
	  x := topScope; guard^.name := id;
	  WHILE x^.next^.name <> id DO x := x^.next;
	  IF x^.next = guard THEN BEGIN
	    NEW(pnew); pnew^.name := id; pnew^.class := class; 
	    pnew^.IsPara := FALSE; pnew^.next := guard;
	    pnew^.exported := FALSE; pnew^.dsc := guard;
	    x^.next := pnew; obj := pnew; END
	  ELSE BEGIN obj := x^.next; Mark('mult def'); 
	  END;
	END {NewObj};
	
	Function findsfr(x: g_object): Boolean;
	Var lst: Psfr;
	Begin findsfr := False; lst := listsfr;
	  While (lst <> Nil) And (x^.name <> lst^.Name) Do
	    lst := lst^.next;
	  If lst <> Nil Then Begin
	    x^.class := g_SFR; x^.lev := 0;
	    x^.val := lst^.adr; x^.o_type := wordType;
	    x^.exported := False; findsfr := True;
	  End;
	End {findsfr};
	
	PROCEDURE find(VAR obj: g_Object);
	  VAR s, x: g_Object; ok: BOOLEAN; pl: Pptr;
	BEGIN s := topScope; guard^.name := id; ok := FALSE;
	  REPEAT x := s^.next;
	    WHILE x^.name <> id DO x := x^.next;
	    IF x <> guard THEN BEGIN obj := x; ok := TRUE; End 
	    Else If findsfr(x) Then Begin
	      obj := x; ok := True; End
	    ELSE IF s = universe THEN BEGIN 
	      obj := x; Mark('undef: ' + Id); ok := TRUE; END 
	    Else s := s^.dsc;
	  until ok;
	  If ok Then
	    If (obj^.o_type = ptrType) And (obj^.name <> 'NIL') Then Begin
	      //If obj^.dsc <> Nil Then writeln(obj^.name, ' -> ', obj^.dsc^.name);
	      If obj^.dsc = NIL Then Begin
		pl := Listptr;
		While (pl <> Nil) And (pl^.name <> obj^.name) Do
		  pl := pl^.next;
		  If pl <> Nil Then Begin
		    id := pl^.base; sym := ident_; find(x);
		    obj^.dsc := x;
		    //Writeln(obj^.name, ' zeigt auf ', obj^.dsc^.name);
		  End
		  Else Mark('pointer-type not found');
		End;
	      End;
	END {find};
	
	PROCEDURE FindField(VAR obj: g_Object; list: g_Object);	
	BEGIN 
	  guard^.name := id;
	  WHILE list^.name <> id DO list := list^.next;
	  obj := list;
	  If list = guard Then begin 
	  Mark('unknown: '+id); CloseFiles; Halt; end;
	END {FindField};
	
	Function IsParam(obj: g_Object): BOOLEAN;
	BEGIN 
	  IF (obj^.class = g_Par) OR ((obj^.class = g_Var) AND (obj^.IsPara)) then
	    IsParam := TRUE
	  ELSE IsParam := FALSE;
	END {IsParam};

	PROCEDURE OpenScope;
	  VAR s: g_Object;
	BEGIN NEW(s); s^.class := g_Head; s^.dsc := topScope; s^.next := guard; topScope := s;
	END {OpenScope};
	
	PROCEDURE CloseScope;
	BEGIN topScope := topScope^.dsc;
	END {CloseScope};
	
	PROCEDURE CheckBool(VAR x: g_Item);
	BEGIN
	  IF x.i_type^.form <> g_Boolean THEN Mark('not boolean');
	END;
	
	
	FUNCTION zwhoch(x: INTEGER): LongInt;
	VAR i: INTEGER; t: LongInt;
	BEGIN t := 1;
	  IF x < 16 THEN 
	    FOR i := 1 TO x DO
	      t := t * 2
	  ELSE Mark('too large!');
	  zwhoch := t;
	END;
  (* -------------------- Parser ---------------------*)	
  
  	PROCEDURE expression(VAR x: g_Item); FORWARD;
  	
  	PROCEDURE parameter(VAR fp: g_Object; sc: BOOLEAN);
	  VAR x: g_Item;
	BEGIN ProcPar := TRUE; expression(x); ProcPar := FALSE;
	  IF IsParam(fp) THEN BEGIN 
	    If ParCount = 0 Then CPinR2 := False;
	    g_Parameter(x, fp^.o_type, fp^.class, sc); fp := fp^.next; 
	    ParCount := ParCount + 1; end
	  ELSE Mark('too many parameters');
	END {parameter};
	
	PROCEDURE selector(VAR x: G_Item);
  	  VAR y: G_Item; obj: G_Object;
	BEGIN
	  { Array ohne Index, }
	  If (x.i_type <> nil) And (Not ProcPar) Then
	    If (x.i_type^.form = g_ARRAY) And (sym <> lbrak_) Then Begin
	      //Mark('arrayindex?');
	      SelStruct(x);
	      //Writeln('size: ', x.i_type^.size, ', len: ', x.i_type^.len);
	    End;  
	    { Record  ohne Feld, }
	    If (x.i_type <> nil) And (Not ProcPar) Then
	      If (x.i_type^.form = g_Record) And (sym <> period_) Then Begin
		//Mark('recordfield?'); CloseFiles; Halt; 
		SelStruct(x);
	      End;
	  WHILE (sym = lbrak_) OR (sym = period_) DO BEGIN
	    IF sym = lbrak_ THEN BEGIN 
	      Get(sym); expression(y); 
	      IF x.i_type^.form = g_Array THEN Index(x, y) 
	      ELSE If x.i_type^.form = g_tablef Then tabindex(x,y)
	      Else Mark('not an array/table');
	      IF sym = rbrak_ THEN Get(sym) ELSE Mark(']?');END
	    ELSE BEGIN { period_ }
	      Get(sym);
	      IF sym = ident_ THEN 
	        IF x.i_type^.form = g_Record THEN BEGIN
	          FindField(obj, x.i_type^.fields); Get(sym);
	          IF obj <> guard THEN BEGIN 
	            Field(x, obj); x.i_type := obj^.o_type; 
	            { Array ohne Index, }
	            If (x.i_type <> nil) And (Not ProcPar) Then
		      If (obj^.o_type^.form = g_ARRAY) And (sym <> lbrak_) Then Begin
			//Mark('arrayindex?');
			SelStruct(x);
		      End;
	          END
	          ELSE Mark('undef'); end
	        Else If x.i_type^.form = g_pointer Then Begin
		  //writeln(x.i_type^.fields^.o_type^.fields^.name);
		  FindField(obj, x.i_type^.fields^.o_type^.fields); Get(sym);
		  IF obj <> guard THEN BEGIN 
		    //writeln(obj^.name);
	            PtrField(x, obj, procpar); x.i_type := obj^.o_type; 
	            //writeln(obj^.o_type^.form);
	            If ((x.i_type^.form = g_ARRAY) And (sym <> lbrak_)) Or
		      ((x.i_type^.form = g_Record) And (sym <> period_)) Then 
		      SelStruct(x);
	            //If obj^.o_type = ptrType Then writeln(obj^.name, ' ist Pointer');
	            If (sym = period_) And (obj^.o_type^.form = g_Pointer) Then
		      LoadRel(x);
	          End
	          Else Mark('undef');
	        End
	        ELSE BEGIN Mark('not a record'); END
	      ELSE Mark('ident?');
	    END;
	  END;
	END {selector};
  	
  	PROCEDURE callproc(obj: g_object; x: g_item);
  	Var smallcall, ok: Boolean; par: g_object; 
  	Begin
	  IF Isint THEN 
	    Mark('No procedure-call in interrupt!')
	  ELSE BEGIN
	     smallcall := smallproc;
	     IF x.mode = g_ProcR THEN smallproc := TRUE
	     ELSE smallproc := FALSE;
	     par := obj^.dsc;
	     g_OpenProc(obj^.val, smallproc);
	     ParCount := 0;
	     IF sym = lparen_ THEN BEGIN
	       Get(sym);
	       IF sym = rparen_ THEN Get(sym)
	         ELSE BEGIN
	           ok := FALSE;
	           REPEAT
	             parameter(par, smallcall); 
	             IF sym = comma_ THEN Get(sym)
	             ELSE IF sym = rparen_ THEN BEGIN 
	               Get(sym); ok := TRUE; end
	             ELSE IF sym >= semicolon_ THEN ok := TRUE
	             ELSE Mark(') or , ?')
	           UNTIL ok;
                 END;
               END;
                IF obj^.val < 0 THEN Mark('forward call')
                ELSE IF NOT IsParam(par) THEN Call(obj)
                  ELSE Mark('too few parameters');
                smallproc := smallcall;
           END;
  	End; {callproc}
  	
  	PROCEDURE param(VAR x: g_Item);
	  BEGIN
	    IF sym = lparen_ THEN Get(sym) ELSE Mark('(?');
	      ProcPar := TRUE;
	      expression(x); ProcPar := FALSE;
	      IF sym = rparen_ THEN Get(sym) ELSE Mark(')?');
	  END {param};
  	
  	PROCEDURE CallSFproc(obj: g_object; VAR x: g_item);
  	VAR arg, y: g_item; result, tobj: g_object; fval, argform: Integer;
  	Begin fval := obj^.val;
	  sym := ident_; ID := '_FRESULT'; find(result); 
	  Get(sym);
	  If fval <> 24 Then Begin 
	    expression(arg);
	    If arg.i_type^.form = g_Array Then
	      argform := arg.i_type^.base^.form
	    Else argform := arg.i_type^.form;
	  End
	  Else Begin { fuer LEN: }
	    Find(tobj); get(sym); 
	  End;
	  If sym = rparen_ Then Begin
	    Get(sym);
	    Case fval Of
	      15: {TRUNC}
		If argform = g_Word Then Begin
		  result^.o_type := WordType;
		  MakeItem(y, result);
		  DoFunction(arg, 15);
		  Store(y, arg);
		  result^.o_type := IntType;
		End
		Else Mark('parametertype1?');
	      16: {ABS}
		If argform = g_Integer Then Begin
		  result^.o_type := IntType;
		  MakeItem(y, result);
		  DoFunction(arg, 16);
		  Store(y, arg);
		  result^.o_type := WordType;
		End
		Else Mark('parametertype2?');
	      17: {ODD}
		IF argform In [g_Word, g_Integer] then Begin
		  If argform  = g_word Then
		    result^.o_type := WordType
		  Else If argform = g_Integer Then
		    result^.o_type := IntType;
		  MakeItem(y, result);
		  DoFunction(arg, 17);
		  Store(y, arg);
		  result^.o_type := BoolType;
		End
		Else Mark('parametertype3?');
	      24: {LEN}
		If tobj^.class = g_Table Then Begin
		  result^.o_type := WordType;
		  MakeItem(y, result);
		  arg.mode := g_const; arg.i_type := wordType;
		  arg.lev := curlev; arg.r := g_PC;
		  arg.a := tobj^.o_type^.len;
		  Store(y, arg);
		End
		Else Mark('parametertype3?');
		
	    End;
	    x := y; x.i_type := result^.o_type;
	  End
	  Else Mark(')?');
  	End {CallSFproc};
  	
  	PROCEDURE callSproc(obj: g_object; VAR x: g_item);
  	Var y, z:g_item; result: g_object; tval: Integer;
  	
	  PROCEDURE wparams(VAR x: g_Item); { Parameter von Write und Writeln }
	  VAR ok : BOOLEAN;
	  BEGIN ok := FALSE; Get(sym);
	    REPEAT
	      ProcPar := TRUE; 
	      expression(x); 
	      IF (x.i_type^.form IN [g_Array, g_Record, g_Pointer, g_tablef])  THEN
	        Mark('bad writeparameter!')  ;
	      IF sym = colon_ THEN BEGIN { Formatanweisung }
	        Get(sym);
	        IF (sym = ident_) AND ((id = 'h') Or (id = 'H')) THEN BEGIN
	          PutWrite(x, 1); { Hexadezimal }
	          Get(sym); END
	        Else IF (sym = ident_) AND ((id = 'c') Or (id = 'C')) THEN BEGIN
	          PutWrite(x, 2); { Character }
	          Get(sym); END
	        ELSE mark('format?');
	      END
	      ELSE BEGIN
	        PutWrite(x,0);
	      END;
	      IF sym = comma_ THEN Get(sym)
	      ELSE IF sym = rparen_ THEN BEGIN 
		  Get(sym); ok := TRUE; end
		ELSE IF sym >= semicolon_ THEN ok := TRUE
		ELSE Mark(') or , ?');
	      ProcPar := False;
	    UNTIL ok;
	  END; {wparams}
  	
  	Begin
	  Case obj^.val Of
	    2,4: If Usewrite Then Begin { WRITE / WRITELN}
		IF sym = lparen_ THEN BEGIN
		  OpenWrite; 
		  wparams(y); 
		  IF obj^.val = 4 THEN CloseWrite(TRUE)
		  ELSE CloseWrite(FALSE);
		END
		ELSE IF obj^.val = 2 THEN mark(' (?!')
		ELSE IOCall(x,y); { Writeln ohne Parameter }
	      END
	      Else Mark('write/writeln disabled by compiler-option!');
	    1:   BEGIN { READ }
		   param(y); IOCall(x, y); END;
	    5: { SLEEP }
		   IOCall(x, y);
	    6, 7: BEGIN { INC / DEC }
		   val := obj^.val; { fuer den Operator }
		   IF sym = lparen_ THEN BEGIN
		    Get(sym);
		    IF sym = ident_ THEN BEGIN
		      find(obj); MakeItem(x, obj); Get(sym); selector(x); 
		      z := x; //Get(sym);
		      IF sym = comma_ THEN BEGIN
			Get(sym); expression(y); 
		      END
		      ELSE
			MakeConstItem(y, wordtype, 1); 
		      IF sym = rparen_ THEN BEGIN
			load(x);
			IF x.i_type^.form = g_Array THEN
			  CopyAddr(z,x);
			  IF val = 6 THEN op2(plus_, x, y)
			  ELSE op2(minus_, x, y);
			  Store(z,x);
			  IF x.i_type^.form = g_Array THEN
			    Retreg(z);
			    Get(sym);
			  END
			  ELSE BEGIN Mark(') ?'); end;
			END
			ELSE Mark('ident?');
		    END
		    ELSE Mark('( ?');
	    END;
	    8: BEGIN { SWAP }
		IF sym = lparen_ THEN BEGIN
		  Get(sym);
		  IF sym = ident_ THEN BEGIN
		    find(obj); MakeItem(x, obj); Get(sym); selector(x); 
		    z := x; 
		    IF sym = rparen_ THEN BEGIN  
		      load(x);
		      IF x.i_type^.form = g_Array THEN Begin
			CopyAddr(z,x); x.mode := g_Reg; End;
		      SwapBytes(x); store(z,x); Get(sym);
		    END
		    ELSE Mark(')?')
		  END
		  ELSE Mark('ident?')
		END
		ELSE Mark('(?');
	    END; 
	    9, 19: BEGIN { GET/GETB }
		tval := obj^.val; 
		IF sym = lparen_ THEN BEGIN
		  Get(sym); Expression(x);
		  {IF sym = ident_ THEN BEGIN
		    find(obj); MakeItem(x, obj); Get(sym); selector(x); }
		    IF sym = comma_ THEN BEGIN
		      Get(sym); expression(y); 
		      IF sym = rparen_ THEN BEGIN
			sym := ident_; ID := '_FRESULT'; find(result); result^.o_type := WordType;
			MakeItem(z, result);
			load(x);
			IF x.i_type^.form = g_Array THEN
			  CopyVal(z,x);
			If tval = 9 Then DoPeek(x,y,z, false)
			Else DoPeek(x,y,z,true);
			IF x.i_type^.form = g_Array THEN
			  Retreg(z);
			Get(sym); x := z;
		      END
		      ELSE Mark(')?');
		    END
		    ELSE Mark('too few parameters!');
		  {END
		  ELSE Mark('ident?');}
		END
		ELSE Mark('(?');
	    END;
	    10, 20: BEGIN { PUT/PUTB }
		tval := obj^.val;
		IF sym = lparen_ THEN BEGIN
		  Get(sym); expression(x);
		  IF sym = comma_ THEN BEGIN
		    Get(sym); expression(y); 
		    IF sym = comma_ THEN BEGIN
		      Get(sym); expression(z); 
		      IF sym = rparen_ THEN BEGIN
			If tval = 10 Then DoPoke(x, y,z, false)
			Else DoPoke(x, y,z, true);
			Get(sym);
		      END
		      ELSE Mark(')?');
		    END
		    ELSE Mark('too few parameters');
		  END
		  ELSE Mark('too few parameters');
		END
		ELSE Mark('(?');
	    END;
	    11, 12: { INTSEN und INTSDIS }
		IF obj^.val = 11 Then SetIEN(True) ELSE SetIEN(False);
	    13: { HALT } Set_Breakpoint;
	    14: { ADR }
		IF sym = lparen_ THEN BEGIN
		  Get(sym);
		  IF sym = ident_ THEN BEGIN
		    find(obj); MakeItem(x, obj); 
		    sym := ident_; ID := '_FRESULT'; find(result); result^.o_type := WordType;
		    MakeItem(y, result); Get(sym); 
		    If x.lev = 0 Then Begin
		      IF (x.i_type^.form = g_array) AND (x.i_type^.base^.form = g_word) Then Begin
			if sym = lbrak_ Then Begin 
			  selector(x); x.a := 0; 
			  store(y,x); x := y; End
			Else Mark('[?');
		      End
		      Else Mark(' no array of word!');
		    End
		    Else If x.lev = curlev Then begin
		      If (obj^.o_type = StringType) And (x.mode = g_Par) Then Begin
			y.i_type := StringType;
			store(y, x); x := y; x.i_type := WordType;
		      End
		      Else Mark('no variable stringparameter');
		    End
		    Else Mark('Level ?'); 
		  End
		  Else mark('ident?');  
		  IF sym <> rparen_ THEN Mark(')?')
		  Else Get(sym);
		END
		ELSE Mark('(?');
	    15..17, 24: If sym = lparen_ Then CallSFproc(obj, x)
		    Else Mark('(?');
	    18: { NEW }
	      If sym = lparen_ Then  Begin
		Get(sym);
		If sym = ident_ Then Begin
		  find(obj);
		  If obj^.o_type = ptrType Then Begin
		    MakeItem(x, obj); Get(sym);
		    //Writeln('Länge: ', obj^.dsc^.o_type^.size, ', Name: ', obj^.dsc^.name);
		    DoNew(x, obj^.dsc^.o_type^.size);
		    IF sym <> rparen_ THEN Mark(')n?')
		    Else Get(sym);
		  End
		  Else Mark('no pointer');
		End
		Else Mark('ident?');
	      END
	      Else Mark('(');
	    21..23, 26, 27: { EINIT, SRST, DUMMIJMP, NOP, JMP0 }
	      DoSpecials(obj^.val);
	    ELSE Mark('?');
	  End;
  	End; {callSproc }
  
	
	PROCEDURE factor(VAR x: g_Item);
	  VAR obj, res: g_Object; lsym: Integer; lid: String; cond: Boolean;	  
	      lastrtype: g_type;
	BEGIN If x.mode = g_cond Then cond := True Else cond := False; (*sync*)
	  IF (sym < lparen_) And (sym <> minus_) THEN BEGIN
	    Mark('ident?');
	    REPEAT Get(sym) UNTIL sym >= lparen_; END ;
	  case sym of
	    ident_:  BEGIN
	      find(obj); Get(sym); MakeItem(x, obj); 
	      If obj^.class In [g_Proc, g_ProcR, g_SProc] Then Begin
		If obj^.class = g_SProc Then Begin 
		  CallSproc(obj, x); x.mode := g_Var; x.lev := 0; 
		End
		Else Begin CallProc(obj, x);
		  lid := id; id := '_FRESULT'; lsym := sym; sym := g_Var;
		  find(res); lastrtype := res^.o_type; res^.o_type := obj^.rtype;
		  MakeItem(x, res);
		  res^.o_type := lastrtype;
		  id := lid; sym := lsym;
		  If cond Then If x.i_type^.form = g_Boolean Then TestTrue(x);
		End;
	      End
	      Else selector(x); END;
	    number_:  BEGIN
		MakeConstItem(x, wordType, val); Get(sym); End;
	    str_: BEGIN
	      MakeStringItem(x, StringType, id); 
	      Get(sym); 
	      END;
	    lparen_: BEGIN
	      Get(sym); expression(x); //If cond Then x.mode := g_Cond;
	      IF sym = rparen_ THEN Get(sym) ELSE Mark(')?'); END;
	    not_ : BEGIN
	      Get(sym); factor(x); Op1(not_, x); end;
	    minus_: Begin
	      Get(sym); factor(x); x.i_type := IntType; Op1(minus_, x); end;
	    ELSE BEGIN Mark('factor?'); MakeItem(x, guard); end;
	  END;
	END {Factor};
	
	
	PROCEDURE term(VAR x: g_Item);
	  VAR y: g_Item; op: INTEGER; cond: Boolean;
	BEGIN If x.mode = g_cond Then cond := True Else cond := False;
	  factor(x);
	  WHILE (sym >= times_) AND (sym <= and_) DO BEGIN
	    op := sym; Get(sym);
	    IF op = and_ THEN
	      If cond Then Begin
		If x.i_type^.form = g_Boolean Then TestTrue(x);
		Op1(op, x);
		//IF sym <> lparen_ THEN Mark('( ?'); 
	      END;
	    factor(y); 
	    If (cond) And (x.i_type^.form = g_Boolean) Then TestTrue(y); 
	    Op2(op, x, y);
	  END;
	END {term};
	
	PROCEDURE SimpleExpression(VAR x: g_Item);
	  VAR y: g_Item; op: INTEGER; cond:Boolean;
	BEGIN If x.mode = g_cond Then cond := True Else cond := False;
	  IF sym = plus_ THEN BEGIN  Get(sym); term(x); end
	  ELSE IF sym = minus_ THEN BEGIN 
	    Get(sym); term(x); 
	    If x.mode = g_Const Then x.i_Type := intType;
	    Op1(minus_, x);
	  end
	  ELSE term(x);
	  { Das ist nicht optimal, da keine boolschen Verknüpfungen für
	    Prozedurparameter damit moeglich sind: TODO 
	    
	    Mit "cond" wird das besser!
	    }
	  {IF (x.i_type^.form = g_Boolean) AND ((x.mode = g_Var) OR (x.mode = g_Reg)) 
	      AND (sym IN [then_, do_, semicolon_, rparen_]) AND (NOT ProcPar) And(cond)}
	  If (cond) And (x.i_type^.form = g_Boolean) THEN TestTrue(x);
	  WHILE (sym >= plus_) AND (sym <= or_) DO BEGIN
	    op := sym; Get(sym);
	    IF op = or_ THEN 
	      If cond Then Begin
		If x.i_type^.form = g_Boolean Then TestTrue(x);
		Op1(op, x);
		//IF sym <> lparen_ THEN Mark ('( ?'); 
	      END;      
	    term(y); 
	    If (cond) And (x.i_type^.form = g_Boolean) Then TestTrue(y); 
	    Op2(op, x, y);
	  END;
	END {SimpleExpression};
  
  	PROCEDURE expression(VAR x: g_Item);
  	  VAR y: g_Item; op: INTEGER; i, s, e: INTEGER; v: LongInt;
	BEGIN SimpleExpression(x);
	  IF (sym >= eql_) AND (sym <= gtr_) THEN BEGIN
	    op := sym; Get(sym); SimpleExpression(y);
	     Relation(op, x, y); END
	  ELSE IF sym = in_ THEN BEGIN
	    Get(sym);
	    IF sym = lbrace_ THEN BEGIN
	      Get(sym); v := 0;
	      REPEAT
		IF sym = comma_ THEN Get(sym);
		IF sym = number_ THEN BEGIN
		  IF val > 15 THEN Mark('out of range!');
		  s := val Mod 16; Get(sym);
		  IF sym = upto_ THEN BEGIN
		    Get(sym);
		    IF sym = number_ THEN BEGIN
		      IF val > 15 THEN Mark('out of range!');
		      e := val Mod 16;
		      FOR i := s TO e DO
			v := v or zwhoch(i);
		      Get(sym);
		    END
		    ELSE Mark('number?');
		  END
		  ELSE v := v or zwhoch(s);
		END
		ELSE Mark('number?');
	      UNTIL sym <> comma_;
	      IF sym = rbrace_ THEN BEGIN
		CheckIN(x, v); Get(sym)
	      END
	      ELSE Mark('}?');
	    END
	    ELSE Mark('{?');	  
	  END;
  	END {expression};
	
	PROCEDURE StatSequence;
	  VAR obj: g_Object; x, y, z: g_Item; done, lastforl: BOOLEAN;
	      label1, label2: LONGINT; smallcall: BOOLEAN; val: Integer;
	      lsym, itype: Integer; lid: String;
	      
	BEGIN (* StatSequence *)
	done := FALSE;
	REPEAT (*sync*) obj := guard;
    	  IF sym < ident_ THEN BEGIN //writeln(sym);
    	    Mark('statement(sync)? /' + id); 
    	    REPEAT Get(sym) UNTIL sym >= ident_; end;
    	    IF DebugLevel > 0 THEN 
	      IF lastlinenr < Tpos THEN BEGIN
		lastlinenr := Tpos;
		writeln(Taus, ';@ ', lastlinenr);  
	  END;
    	  CASE sym of
	    ident_: BEGIN
	      find(obj); MakeItem(x, obj); Get(sym); selector(x); 
	      Case sym of
	        becomes_: BEGIN
	          Get(sym); expression(y); 
	          If x.i_type^.form = g_Array Then 
		    itype := x.i_type^.base^.form
		  Else itype := x.i_type^.form;
		  If (itype = g_Integer) And (y.mode = g_Const) Then
		    If y.a < 32768 Then y.i_type := intType
		    Else Mark('too large const');
	          Store(x, y); 
	        END;
	        eql_:  BEGIN
	          Mark(':= ?'); Get(sym); expression(y); END;
	        ELSE Begin
	          IF (x.mode = g_Proc) OR (x.mode = g_ProcR) THEN BEGIN
		    If obj^.rtype = Nil then callproc(obj, x)
		    Else Mark('functional procedure!');
                  END
                  ELSE IF x.mode = g_SProc THEN BEGIN
		    callSproc(obj, x);
                  END { Inlineprozedur }
                  ELSE IF obj^.class = g_Typ THEN Mark('illegal assignment?')
                  ELSE Mark('statement?!'); 
                END;
              END;
            END;
            for_: BEGIN Get(sym);
              label1 := GetLabel; label2 := GetLabel; 
              lastforl := forloop; forloop := TRUE;
                IF sym = ident_ THEN BEGIN 
                  find(obj); MakeItem(x, obj); selector(x); Get(sym);
                  If x.i_type^.form = g_Array Then 
		    itype := x.i_type^.base^.form
		  Else itype := x.i_type^.form;
                  IF sym = becomes_ THEN BEGIN
                    Get(sym); expression(y); 
                    If (itype = g_Integer) And (y.mode = g_Const) Then
		      If y.a < 32768 Then y.i_type := intType
		      Else Mark('too large const');
                    store(x,y); 
                    IF sym = to_ THEN BEGIN
                      Get(sym); expression(y); 
                      If (itype = g_Integer) And (y.mode = g_Const) Then
			If y.a < 32768 Then y.i_type := intType
			Else Mark('too large const');
                      load(x);
                      IF (y.mode <> g_Const)  THEN load(y);                     
                      NewLabel(label1,'start for');                                            
                      relation(leq_, x, y); 
		      If itype = g_Integer Then CJump(label2, True)
                      Else CJump(label2, False); 
                      load(x);                       
                      IF sym = do_ THEN BEGIN
                        Get(sym); StatSequence; g_Inc(x);
                        BJump(label1); NewLabel(label2, 'end for');
                        IF sym = end_ then Get(sym) ELSE Mark('END?');
                        IF y.mode <> g_Const THEN retreg(y);
                        StoreLv(x); forloop := lastforl;
                      END
                      ELSE Mark('DO?');
                    END
                    ELSE Mark('TO?');
                  END
                  ELSE Mark(' assignement?')
                END
                ELSE Mark(' FOR IDENT?');
            
            END;
            if_: BEGIN
             label1 := GetLabel; label2 := GetLabel;
              Get(sym); 
              x.mode := g_Cond;
              expression(x); 
              If x.i_type^.form = g_Array Then 
		itype := x.i_type^.base^.form
	      Else itype := x.i_type^.form;
	      If itype = g_Integer Then CJump(label1, True)
              Else CJump(label1, False); 
              IF sym = then_ THEN Get(sym) ELSE Mark('THEN?');
              StatSequence; 
              IF (sym = elsif_) or (sym = else_) then 
                FJump(label2);
              NewLabel(label1, ''); 
              WHILE sym = elsif_ DO BEGIN
		Get(sym); Label1 := GetLabel;
		x.mode := g_Cond;
                expression(x);
                If x.i_type^.form = g_Array Then 
		  itype := x.i_type^.base^.form
		Else itype := x.i_type^.form;
		If itype = g_Integer Then CJump(label1, True)
                Else CJump(label1, False); 
                IF sym = then_ THEN Get(sym) ELSE Mark('THEN?');
                StatSequence; FJump(label2); NewLabel(label1, '');
              END;
              IF sym = else_ THEN BEGIN
                Get(sym); ; StatSequence; END;
              IF sym = end_ THEN Get(sym) ELSE Mark('END?');
              NewLabel(label2, '');
            END;
            repeat_: BEGIN Get(sym);
              label1 := GetLabel; NewLabel(label1,'');
              StatSequence;
              IF sym = until_ THEN BEGIN 
              	Get(sym); x.mode := g_Cond; expression(x); 
		If x.i_type^.form = g_Array Then 
		  itype := x.i_type^.base^.form
		Else itype := x.i_type^.form;
		If itype = g_Integer Then CJump(label1, True)
                Else CJump(label1, False); 
              	Get(sym); END
              ELSE Mark('until?');
            END;            
            while_: BEGIN
              Get(sym); 
              label1 := getlabel; { Returnlink to start }
              NewLabel(label1, '');
              label2 := getlabel; { end of while-loop }
              x.mode := g_Cond; expression(x); 
              If x.i_type^.form = g_Array Then 
		itype := x.i_type^.base^.form
	      Else itype := x.i_type^.form;
	      If itype = g_Integer Then CJump(label2, True)
              Else CJump(label2, False); 
              IF sym = do_ THEN Get(sym) ELSE Mark('DO?');
              StatSequence; BJump(label1); NewLabel(label2, '');
              IF sym = end_ THEN Get(sym) ELSE Mark('END?');
            END;
            return_: Begin
	      retdone := True;
	      Get(sym); expression(y);
	      lsym := sym; sym := g_var; lid := id; id := '_FRESULT';
	      find(obj); MakeItem(x, obj); store(x, y); 
	      sym := lsym; id := lid;
            End;
            semicolon_: Get(sym);
            (semicolon_ +1) .. (if_ -1) : done := TRUE;
           ELSE IF (sym >= array_) THEN done := TRUE
           	ELSE  Mark('; ?');
          end; 	
	until done;
	END {StatSequence};
	
	PROCEDURE IdentList(class: INTEGER; VAR first: g_Object);
	  VAR obj: g_Object;
	BEGIN
	  IF sym = ident_ THEN BEGIN
	    NewObj(first, class); Get(sym);
	    IF sym = times_ THEN BEGIN
		  first^.exported := TRUE; Get(sym); END;
	    WHILE sym = comma_ DO BEGIN
	      Get(sym);
	      IF sym = ident_ THEN BEGIN
	        NewObj(obj, class); Get(sym); 
	        IF sym = times_ THEN BEGIN
		  obj^.exported := TRUE; Get(sym); END;
	        END
	      ELSE Mark('ident?');
	    END;
	  END;
	  IF sym = colon_ THEN Get(sym) ELSE Mark(':?');
	END {IdentList};
	
	PROCEDURE TType(VAR typet: g_Type);
	  VAR obj, first: g_Object; x: g_Item; tp: g_Type; ok:BOOLEAN;
	
	BEGIN typet := wordType; (*sync*)
	  IF (sym <> ident_) AND (sym < array_) THEN BEGIN
	    Mark('type?');
	    REPEAT Get(sym) UNTIL (sym = ident_) OR (sym >= array_);
	  end;
	  CASE sym OF
	    ident_: BEGIN find(obj); Get(sym);
	             IF obj^.class = g_Typ THEN Begin 
		      typet := obj^.o_type;
		      If typet = ptrType Then typet^.fields := obj^.dsc; End
	             ELSE Mark('type?'); 
	             End;
	    array_: BEGIN IF (smallproc) OR (IsInt) THEN Mark('no array here!') ELSE BEGIN
	    	      Get(sym); expression(x);
	    	      IF (x.mode <> g_Const) OR (x.a < 0) THEN Mark('bad index');
	    	      IF sym = of_ THEN Get(sym) ELSE Mark('OF?');
	    	      TType(tp); NEW(typet); typet^.form := g_Array; typet^.base := tp;
	    	      typet^.len := (x.a MOD maxint); typet^.size := typet^.len * tp^.size; 
	    	      typet^.ref := -1; end;
	    	    END;
	    record_: BEGIN
	    	       Get(sym); NEW(typet); typet^.form := g_Record; typet^.size := 0; OpenScope;
	    	       typet^.ref := -1; ok := FALSE;
	    	       REPEAT
	    	         IF sym = ident_ THEN BEGIN
	    	           IdentList(g_Fld, first); TType(tp); obj := first;
	    	           WHILE obj <> guard DO BEGIN
	    	             obj^.o_type := tp; obj^.val := typet^.size; 
	    	             typet^.size := typet^.size + obj^.o_type^.size;;
	    	             //obj^.o_type^.size := obj^.o_type^.size + 2; 
	    	             obj := obj^.next;
	    	           END
	    	         END ;
	    	         IF sym = semicolon_ THEN Get(sym)
	    	         ELSE IF sym = ident_ THEN Mark('; ?')
	    	           ELSE OK := TRUE;
	    	       Until ok;
	    	       typet^.fields := topScope^.next; CloseScope;
	    	       IF sym = end_ THEN Get(sym) ELSE Mark('END?'); END  
	    ELSE Mark('ident?');
	  end;
	END {TType};

	PROCEDURE ReadTable(tab: g_Object);
	VAR cnt, i: Integer; lst: tabp; x: g_Item; typ: g_Type;
	Begin New(typ); typ^.form := g_tablef; tab^.o_type := typ;
	  tab^.class := g_table; 
	  tab^.val := nexttab; tab^.lev := curlev;
	  cnt := 0; Get(sym);
	  If sym = of_ Then Begin
	    Get(sym);
	    If sym = ident_ Then Begin
	      If Id = 'INTEGER' Then tab^.o_type^.base := intType
	      Else If Id = 'WORD' Then tab^.o_type^.base := wordType
	      Else Mark('illegal tabletype');
	      Get(sym);
	      If sym = eql_ Then Begin
		lst := tabl;
		While (lst^.len <> 0) And (lst^.next <> NIL) Do
		  lst := lst^.next; 
		If lst^.len <> 0 Then Begin
		  New(lst); lst^.next := tabl; tabl := lst; End;
		lst^.nr := nexttab; nexttab := nexttab + 1; lst^.lev := curlev;
		For i := 0 To maxstringref Do lst^.refs[i] := 0;
		Repeat
		  Get(sym); expression(x); 
		  If x.mode = g_const Then Begin
		    If tab^.o_type^.base = intType Then Begin
		      If (x.a >= -32768) And (x.a < 32768) Then Begin
			cnt := cnt + 1; 
			If x.a < 0 Then lst^.inh[cnt] := $FFFF + x.a + 1
			Else lst^.inh[cnt] := x.a; End
		      Else Mark('no integer');
		    End
		    Else If tab^.o_type^.base = wordType Then Begin
		      If (x.a >= 0) And (x.a <= $FFFF) Then Begin
			cnt := cnt + 1; lst^.inh[cnt] := x.a; End
		      Else Mark('no word');
		    End;
		  End
		  Else Mark('no number');
		Until (sym <> comma_) Or (cnt > 512);
		If cnt > 512 Then Mark('table too long!');
		lst^.len := cnt; tab^.o_type^.len := cnt; 
	      End
	      Else Mark ('=');
	    End
	    Else Mark('type?');
	  End
	  Else Mark('of?');
	End {ReadTable};

	PROCEDURE declarations(VAR varsize: LONGINT);
	  VAR obj, first: g_Object; ok: BOOLEAN;
	    x: g_Item; tp: g_Type;
	    pl: Pptr;
	    
 	BEGIN(*sync*)
 	  WHILE sym = semicolon_ DO Get(sym);
	  IF (sym < sfr_) AND (sym <> end_) THEN BEGIN
	    Mark('declaration?');
	    REPEAT Get(sym) UNTIL ((sym >= sfr_) OR (sym = end_));
	  END;
	  ok := FALSE;
	  Repeat
	    WHILE sym = semicolon_ do Get(sym);
	    IF sym = sfr_ THEN Mark('unknown');
	    IF sym = const_ THEN BEGIN
	      Get(sym);
	      WHILE sym = ident_ DO BEGIN
	        NewObj(obj, g_Const); Get(sym);
	        IF sym = times_ THEN BEGIN
		  obj^.exported := TRUE; Get(sym); 
		  //writeln(obj^.name, ' ist exported');
		  END;
	        IF sym = eql_ THEN Get(sym) ELSE Mark('=?');
	        If (sym = ident_) And (Id = 'TABLE') Then ReadTable(obj)
	        Else Begin
		  expression(x);
		  IF x.mode = g_Const THEN BEGIN
		    obj^.val := x.a; obj^.o_type := x.i_type; obj^.lev := curlev; END
		  ELSE Mark('expression not constant');
		End;  
		IF sym = semicolon_ THEN Get(sym) ELSE Mark(';?');
                WHILE sym = semicolon_ do Get(sym);
              END;
            END;
            IF sym = type_ THEN 
              IF (smallproc) Or (IsInt) THEN Mark('??')
              ELSE BEGIN
                Get(sym);
                WHILE sym = ident_ DO BEGIN
                  NewObj(obj, g_Typ); Get(sym);
                  IF sym = times_ THEN BEGIN
		    obj^.exported := TRUE; Get(sym); END;
                  IF sym = eql_ THEN Get(sym) ELSE Mark('=?'); 
                  If sym = pointer_ Then Begin
		    Get(sym);
		    If sym = to_ Then Begin
		      Get(sym);
		      If sym = ident_ Then Begin
			Get(sym);
			New(pl); pl^.next := Listptr; Listptr := pl;
			pl^.name := obj^.name;  pl^.base := ID;
			obj^.o_Type := ptrType; obj^.dsc := NIL;
		      End
		      Else Mark('ref-ident?');
		    End
		    Else Mark('TO?');
                  End
                  Else TType(obj^.o_type);
                  IF sym = semicolon_ THEN Get(sym) ELSE Mark(';?');
                  WHILE sym = semicolon_ do Get(sym);
                END;
              END;
            IF sym = var_ THEN BEGIN
              Get(sym);
              WHILE sym = ident_ DO BEGIN
                IdentList(g_Var, first); TType(tp); obj := first;
                IF (smallproc) AND (tp^.form IN [g_Array, g_Record])
		  THEN Mark('no struct. vars in *-procs!')
		ELSE
                WHILE obj <> guard DO BEGIN
                  obj^.o_type := tp; obj^.lev := curlev; 
                  If obj^.o_Type = ptrType Then Begin 
		    obj^.dsc := tp^.fields;
		  End;
                  varsize := varsize + obj^.o_type^.size; obj^.val := varsize; obj := obj^.next;
                END;
                IF sym = semicolon_ THEN Get(sym) ELSE Mark('; ?');
                WHILE sym = semicolon_ do Get(sym);
              END;
            END ;
            IF (sym >= const_) AND (sym <= var_) THEN 
	      Mark('declaration?') ELSE ok := TRUE
	  Until ok;
	END {declarations};
	
	PROCEDURE ProcedureDecl(small: BOOLEAN);
	VAR proc, obj: g_Object;
	    procid: Ident;
	    locblksize : LONGINT;
	    Snextreg, Slastreg, nr: INTEGER;
	    ssmallproc:Boolean;
	    { Fuer Funktionsprozeduren: }
	    fret: g_Object;
	
		PROCEDURE FPSection;
		  VAR obj, first: g_Object; tp: g_Type; //parsize: LONGINT;
		BEGIN
		  IF sym = var_ THEN BEGIN
		    Get(sym); IdentList(g_Par, first); end
		  ELSE IdentList(g_Var, first);
		  IF sym = ident_ THEN BEGIN
		    find(obj); Get(sym); 
		    IF obj^.class = g_Typ THEN Begin 
		      tp := obj^.o_type;
		      If tp = ptrType Then tp^.fields := obj^.dsc;
		    End
		    ELSE BEGIN
		      Mark('type?'); tp := wordType; END;
		  end
		  ELSE BEGIN
		    Mark('ident?'); tp := wordType;
		  END;
		  obj := first;
		  WHILE obj <> guard DO BEGIN
		    IF (tp^.form In [g_Array .. g_stringf]) AND (obj^.class <> g_Par) THEN 
		      Mark('no structered valueparameters');
		    obj^.o_type := tp; //parblksize := parblksize + parsize;
		    If tp = ptrType Then obj^.dsc := tp^.fields;
		    obj := obj^.next;
		  END;
		END {FPSection};
		
	BEGIN (* ProcedureDecl *) Get(sym);
	  IF sym = ident_ THEN BEGIN
	    snextreg := nextreg; slastreg := lastreg;
	    ssmallproc := smallproc;
	    IsProc := TRUE;
	    IF small THEN 
	      smallproc := TRUE
	    ELSE smallproc := FALSE;
	    Get(sym);
	    IF (id = 'ISR') THEN BEGIN
	      retdone := True;
	      IF curlev = 0 THEN BEGIN
	        IsInt := TRUE; smallproc := TRUE;
	        nextreg := 0; lastreg := 15;
	        IF sym = times_ THEN BEGIN
		   Mark('must not be exported'); Get(sym); END;
	        IF sym = lbrak_ THEN BEGIN
	          Get(sym);
	          If sym = ident_ Then Begin
		    nr := 0;
		    While (nr <= maxvector) And (Vektoren[nr].name <> ID) Do
		      nr := nr + 1;
		    If nr > maxvector Then Mark('vectorname unknown')
		    Else Begin 
		      sym := number_; val := nr;
		    End;
	          end;
	          IF sym = number_ THEN BEGIN
	            If Vektoren[val].used Then Mark('Trap already served!');
	            procid := Vektoren[val].name;
	            id := procid;
	            Vektoren[val].used := TRUE; Vektoren[val].adr := cap;
	            NewObj(proc, g_Int); //parblksize := marksize;
	            IncLevel(2); OpenScope; proc^.val := -1;
	            Get(sym);	            
	            If sym = rbrak_ THEN Get(sym) ELSE Mark(']?');
	          END
	          ELSE Mark('interrupt-vector?');
	        END
	        ELSE Mark('[?');
	      END
	      ELSE Mark('interrupt-level?')
	    END
	    ELSE BEGIN
	      nextreg := 1; lastreg := 15;
	      procid := id; 
	      IF smallproc THEN NewObj(proc, g_ProcR)
	      ELSE NewObj(proc, g_Proc); //Get(sym); 
	      proc^.rtype := Nil;
	      IF sym = times_ THEN BEGIN 
		proc^.exported := TRUE; Get(sym); END;
	      IncLevel(2); OpenScope; proc^.val := -1;
	      IF sym = lparen_ THEN BEGIN
	        Get(sym);
	        IF sym = rparen_ THEN Get(sym)
	        ELSE BEGIN
	          FPSection;
	          WHILE sym = semicolon_ DO BEGIN
	            Get(sym); 
	            IF sym <> rparen_ THEN FPSection
	            ELSE Mark('???');
	          END ;
	          IF sym = rparen_ THEN Get(sym) ELSE Mark(')?');
	        END;
	      END;
	      If sym = colon_ Then Begin { Funktionale Prozedur }
		Get(sym);
		If sym = ident_ Then Begin
		  find(obj);
		  If obj^.o_type^.form < g_Array Then Begin
		    proc^.rtype  := obj^.o_type;
		  End
		  Else 
		    Mark('no structered result!');
		End
		Else Mark('type?');
		Get(sym);
	      End
	      Else  retdone := True;
	    END;{ Funktionale Prozedur }
	    obj := topScope^.next; 
	    locblksize := 0;
	    WHILE obj <> guard DO BEGIN
	      obj^.lev := curlev;
	      IF obj^.o_type^.form IN [g_array, g_record] THEN
	        locblksize := locblksize + WordSize
	      ELSE
	        locblksize := locblksize + obj^.o_type^.size;
	      obj^.val := locblksize; obj^.IsPara := TRUE;
	      obj := obj^.next;
	    END;
	    proc^.dsc := topScope^.next;
	    IF sym = semicolon_ THEN Get(sym) ELSE Mark(';???');
	    declarations(locblksize);
	    WHILE (sym = procedure_) OR (sym = procedureR_) DO BEGIN
	      IF sym = procedureR_ THEN ProcedureDecl(TRUE)
	      ELSE ProcedureDecl(FALSE);
	      IF sym = semicolon_ THEN Get(sym) ELSE Mark(';?');
	    END;
	    SetProcLabel(procid, IsInt);
	    proc^.val := locblksize; 
	    IF NOT IsInt THEN BEGIN
	      IF smallproc THEN BEGIN
	        IF locblksize <= maxvarcnt THEN
	          lastreg := 15 - (locblksize DIV 2)
	        ELSE Mark('too many variables for procedure'); END
	      ELSE nextreg := 1; {fuer longproc, R1 wird eigentlich nicht benoetigt }
	    END
	    ELSE BEGIN { Interrupt }
	      IF locblksize <= maxvarcnt THEN
	        lastreg := 15 - (locblksize DIV 2)
	      ELSE Mark('too many variables for interrupt');
	    END;
	    IF sym = begin_ THEN BEGIN
	      proc^.adr := cap;
	      If proc^.rtype <> Nil Then Begin { Funktionsprozedur}
		sym := ident_; Id := '_FRESULT'; find(fret);
		  fret^.o_type := proc^.rtype; retdone := False;
	      End;	      
	      Get(sym); StatSequence; 
	      If Not retdone Then Mark('missing RETURN');
	    END;
	    IF sym = end_ THEN Get(sym) ELSE Mark('END?');
	    IF sym = ident_ THEN BEGIN
	      IF IsInt THEN BEGIN
	        IF id <>'ISR' THEN Mark('no match');
	      END
	      ELSE IF procid <> id THEN Mark('no match');
	      Get(sym);
	    END ;
	    nextreg := snextreg; lastreg := slastreg; smallproc := ssmallproc;
	    Return(proc^.name, IsInt); CloseScope; IncLevel(-2);
	    IsInt := FALSE; IsProc := FALSE;
	  END;
	END {ProcedureDecl};
	
	PROCEDURE ReadMod(VAR imod: g_Object);
	VAR no, np: g_Object; c: CHAR; i: INTEGER; l: LONGINT; s:Ident;
	    f: Text; nt, nb: g_Type;
	    
	    PROCEDURE Readfields;
	    
	    BEGIN
	    
	    END;
	    
	    
	BEGIN s :=  imod^.name + '.sym';
	  {$i-}
	  assign(f, s); reset(f);
	  {$i+} i := IOresult;
	  IF i <> 0 THEN BEGIN
	      Mark(s + ' does not exist!'); Exit; END
	  ELSE BEGIN
	    InclMod(imod^.name); readln(f, s); 
	    IF s <> imod^.name THEN Mark('wrong module?');
	    readln(f, l);
	    IF l <> ramstart THEN BEGIN 
	      Mark('ramstart different!'); Exit; END;
	  END;
	  Readln(f, l); ramoffset := ramoffset + l;
	  Readln(f, i);
	  IF i = 1 THEN write_used := TRUE;
	  WHILE NOT EOLN(f) DO BEGIN
	    read(f, i); vektoren[i].used := TRUE; END;
	  Readln(f);
	  WHILE NOT EOF(f) DO 
	    IF EOLN(f) THEN READLN(f) ELSE BEGIN
	      np := imod; NEW(no);
	      WHILE np^.next <> NIL do np := np^.next;
	      np^.next := no; no^.next := NIL; no^.lev := 0;
	      no^.exported := FALSE; no^.dsc := NIL;
	      no^.IsPara := FALSE;
	      Read(f, no^.class, c); c := 'a'; s := '';
	      WHILE NOT EOLN(f) AND (c <> ' ')  DO BEGIN
		Read(f,c); s:= s + c; END;
	      no^.name := s;
	      CASE no^.class OF
		g_Const: BEGIN readln(f,no^.val); 
		END;
		g_Typ: BEGIN NEW(nt); no^.o_type := nt; 
		  read(f, nt^.ref, nt^.form, nt^.size);
		  IF nt^.form = g_Array THEN BEGIN
		    read(f, nt^.len, i);
		    WHILE i = g_Array DO BEGIN
		      NEW(nb); nt^.base := nb; nt := nb; 
		      read(f, nt^.size, nt^.len, i);
		    END;
		    IF i = g_Record THEN Readfields
		    ELSE IF i < g_Array THEN BEGIN
		      IF i = g_Integer THEN nt^.base := intType
		      Else If i = g_word Then nt^.base := wordType
			ELSE nt^.base := boolType;
		      readln(f);
		    END
		    ELSE Mark('corrupt Type in sym-file');
		  END
		  ELSE IF nt^.form = g_Record THEN BEGIN
		  
		  END
		  ELSE Mark('corrupt Type in sym-File');
		
		END;
		g_Var: BEGIN
		
		END;
		g_Proc: BEGIN
		
		END;
		ELSE Mark('corrupt sym-file');
	      END;
	    END;
	    
	  close(f);
	END {ReadMod};
	

	PROCEDURE Module;
	  VAR  modid: Ident; varsize: LONGINT; im, sm: g_Object; 
		typ:g_type;
	BEGIN Write('   compiling ');
	  if sym = module_ then begin
	    Get(sym); Open; OpenScope; varsize := 0;
	    IF sym = ident_ THEN BEGIN
	      modid := id; modname := modid; mainname:= modid;
	      writeln(modname);
	      Get(sym); end
	    ELSE Mark('ident?');
	    IF sym = semicolon_ THEN Get(sym) ELSE Mark(';?');
	    { _FRESULT vom typ Integer anlegen: }
	      New(sm); 
	      id := '_FRESULT'; NewObj(sm, g_var);
	      sm^.o_type := WordType; sm^.exported := False; sm^.lev := curlev;
	      varsize := varsize + sm^.o_type^.size; sm ^.val := varsize;
	    { fertig mit _FRESULT }
	    { _HeapTop anlegen: }
	      New(sm); 
	      id := '_HEAPTOP'; NewObj(sm, g_var);
	      sm^.o_type := wordType; sm^.exported := False; sm^.lev := curlev;
	      varsize := varsize + sm^.o_type^.size; sm ^.val := varsize;
	      Heaptop := ramstart + varsize - 2;
	    { fertig mit _Heaptop }
	    IF sym = import_ THEN BEGIN
	      New(im); imported := im; Get(sym);	      
	      IF sym = ident_ THEN BEGIN
		im^.class := g_mod; im^.name := Id; modname := Id;
		im^.next := NIL; im^.dsc := NIL;
		CallMain; ReadMod(im); Get(sym);
	      END
	      ELSE Mark('import what?');
	      WHILE sym = comma_ DO BEGIN
		NEW(im); sm := imported;
		Get(sym); im^.class := g_mod; im^.name := Id; modname := ID;
		im^.next := NIL; im^.dsc := NIL;
		WHILE sm^.dsc <> NIL DO sm := sm^.dsc;
		sm^.dsc := im; CallMain; ReadMod(im); Get(sym);
	      END;
	      IF sym = semicolon_ THEN Get(sym)
	      ELSE Mark(';?');
	      varsize := ramoffset; ramoffset := 0;
	      modname := mainname;
	    END;
	    CallMain;
	    declarations(varsize);
	    WHILE (sym = procedure_) OR (sym = procedureR_) DO BEGIN
	    	IF sym = procedureR_ THEN ProcedureDecl(TRUE)
	    	ELSE ProcedureDecl(FALSE);
	    	IF sym = semicolon_ THEN Get(sym) ELSE Mark(';?'); 
	    	WHILE sym = semicolon_ DO Get(sym);
	    END;
	    Init_Sproc(varsize);
	    IF sym = begin_ THEN BEGIN 
	      mainstart := cap;
	      reslink(link.Mainstart, mainstart);
	      SetProcLabel('', FALSE);
	      Get(sym); StatSequence; END ;	    
	    IF sym = end_ THEN Get(sym) ELSE Mark('END?'); 
	    IF sym = ident_ THEN BEGIN
	      IF modid <> id THEN Mark('no match');
	      Get(sym); 
	    END
	    ELSE Mark('ident?');
	    IF sym <> period_ THEN Mark('. ?');
	    IF NOT impmod THEN BEGIN CloseScope;
	      IF not error THEN 
		Writeln('code generated');
	     { ELSE writeln('error(s)');}
	    END;
	  end
	  else Mark('MODULE?');
	END {Module};
	
	PROCEDURE WriteSym(name: String);
	VAR Tsym: TEXT; i, Tref: INTEGER; start, pars, help: g_Object; ptyp: g_Type;
	    wf: BOOLEAN;
	    
	    PROCEDURE WriteFields(VAR so: g_Object);
	    VAR tob: g_Object;	    
	    BEGIN  ptyp:= so^.o_type;
	      IF ptyp^.form < g_Array THEN write(Tsym, ' ', ptyp^.form); 
	      WHILE ptyp^.form > g_word DO BEGIN
		WHILE ptyp^.form = g_Array DO BEGIN
		  write(Tsym, ' ', g_Array, ' ', ptyp^.size, ' ', ptyp^.len);
		  ptyp := ptyp^.base; 
		  IF ptyp^.form < g_Array THEN write(Tsym, ' ', ptyp^.form); 
		END;
		IF ptyp^.form = g_Record THEN BEGIN
		  write(Tsym, ' ', g_record, ' ', ptyp^.size);
		  tob := ptyp^.fields;
		  
		  WHILE tob <> guard DO BEGIN
		    //write(Tsym, ' ', tob^.name, ' ', g_Record, ' ', ptyp^.size); 
		    write(Tsym, ' ', tob^.name);
		    WriteFields(tob);
		    write(Tsym, ',');
		    tob := tob^.next;
		  END;
		END;
	      END;	      
	    END;
	    
	BEGIN assign(Tsym, modname + '.sym'); rewrite(Tsym);
	  Tref := 128; { weit �ber den Klassennummern }
	  writeln(Tsym, modname); writeln(Tsym, ramstart);
	  writeln(Tsym, ramtop - ramstart);
	  IF write_used THEN writeln(Tsym, '1') ELSE
	    writeln(Tsym, '0');	  
	  write(Tsym, 0);
	  FOR i := 1 TO 71 DO
	    IF vektoren[i].used THEN
	      write(Tsym, ' ', i);
	  writeln(Tsym);
	  start := topscope;
	  WHILE start <> guard DO BEGIN
	    IF start^.exported THEN BEGIN
	      write(Tsym, start^.class);
	      CASE start^.class OF
		g_Const: writeln(Tsym, ' ', start^.name, ' ', start^.val);
		g_Typ: 	Begin ptyp := start^.o_type; ptyp^.ref := Tref; Tref := Tref + 1;		
		  write(Tsym, ' ', start^.name, ' ', ptyp^.ref);
		  WHILE ptyp^.form > g_word DO BEGIN
		    IF ptyp^.form = g_Array THEN BEGIN
		      write(Tsym, ' ', g_Array, ' ', ptyp^.size, ' ', ptyp^.len);
		      ptyp := ptyp^.base; IF ptyp^.form < g_Array THEN write(Tsym, ' ', ptyp^.form);
		    END
		    ELSE BEGIN // Record 
		      write(Tsym, ' ', g_Record, ' ', ptyp^.size); pars := ptyp^.fields;
		      WHILE pars <> guard DO BEGIN
			write(Tsym, ' ', pars^.name);
			WriteFields(pars);
			write(Tsym, ',');
			pars := pars^.next;
		      END;
		    END;
		  END;
		  writeln(Tsym);
		END;
		g_Var: BEGIN
		  write(Tsym, ' ', start^.name, ' ', start^.val);
		  ptyp := start^.o_type;
		  IF ptyp^.form < g_Array THEN writeln(Tsym, ' ', ptyp^.form)
		  ELSE IF ptyp^.ref <> -1 Then writeln(Tsym, ' ', ptyp^.ref)
		  ELSE BEGIN ptyp := start^.o_type;		  
		    WHILE ptyp^.form > g_word DO BEGIN
		      IF ptyp^.form = g_Array THEN BEGIN
			write(Tsym, ' ', g_Array, ' ', ptyp^.size, ' ', ptyp^.len);
			ptyp := ptyp^.base; wf := TRUE;
		      END
		      ELSE BEGIN { Record }
			  write(Tsym, ' ', g_Record, ' ', ptyp^.size); pars := ptyp^.fields;
			WHILE pars <> guard DO BEGIN
			  write(Tsym, ' ', pars^.name, ' ', pars^.o_type^.form);
			  pars := pars^.next;
			END;
			ptyp := ptyp^.fields^.o_type; wf := FALSE;
		      END;
		    END;
		    IF wf THEN writeln(Tsym, ' ', ptyp^.form) 
		    ELSE writeln(Tsym);
		  END;
		END;
		g_Proc, g_ProcR: BEGIN
		  write(Tsym, ' ', start^.name);
		  IF start^.dsc <> guard THEN BEGIN (* es gibt Parameter?*)
		    pars := start^.dsc;
		    WHILE pars <> guard do BEGIN
		      IF pars^.IsPara THEN BEGIN
			write(Tsym, ' ', pars^.class, ' ');
			IF pars^.o_type^.form <= g_word THEN
			  write(Tsym, pars^.o_type^.form)
			ELSE write(Tsym, pars^.o_type^.ref);
		      END;
		      pars := pars^.next;
		    END;
		  END;
		  writeln(Tsym);
		END;
		ELSE Mark('export what?');
	      END;
	    END;
	    start := start^.next;
	  END;
	  //Writeln(Tsym); 
	  close(Tsym); CloseScope;
	  Writeln('Files created');
	END {WriteSym};


	PROCEDURE Compile(fname: String);
	BEGIN 
	  writeln('Oberon compiler for C16x, version ', verstr);
          Init(fname,0); 
          If NOT impmod THEN Open_Gen;
          Get(sym); Module;
          IF impmod THEN WriteSym(fname) ELSE End_Mod;
	  closefiles; 
	  writeln;
	END {Compile};



	PROCEDURE enter(cl: INTEGER; n: LONGINT; name: Ident; p_type: g_Type);
	  VAR obj: g_Object;
	BEGIN NEW(obj);
	  obj^.class := cl; obj^.val := n; obj^.name := name; obj^.o_type := p_type; obj^.dsc := NIL;
	  obj^.next := topScope^.next; topScope^.next := obj;
	END {enter}; 

initialization

  NEW(guard); guard^.class := g_Var; guard^.o_type := wordType; guard^.val := 0;
  topScope := NIL; OpenScope;
  enter(g_Typ, 1, 'BOOLEAN', boolType);
  enter(g_Typ, 2, 'INTEGER', intType);
  enter(g_Typ, 2, 'WORD', wordType);
  enter(g_Typ, 1, 'STRING', stringType);
  enter(g_Const, 1, 'TRUE', boolType);
  enter(g_Const, 0, 'FALSE', boolType);
  enter(g_const, 1, 'NIL', ptrType);
  enter(g_SProc, 1, 'READ', NIL);
  enter(g_SProc, 2, 'WRITE', NIL);
  enter(g_SProc, 4, 'WRITELN', NIL);
  enter(g_SProc, 5, 'SLEEP', NIL);
  enter(g_SProc, 6, 'INC', NIL);
  enter(g_SProc, 7, 'DEC', NIL);
  enter(g_SProc, 8, 'SWAP', NIL);
  enter(g_SProc, 9, 'GET', WordType);
  enter(g_SProc, 10, 'PUT', NIL);
  enter(g_SProc, 11, 'INTSEN', NIL);
  enter(g_SProc, 12, 'INTSDIS', NIL);
  enter(g_SProc, 13, 'HALT', NIL);
  enter(g_SProc, 14, 'ADR', WordType);
  enter(g_SProc, 15, 'TRUNC', intType);
  enter(g_SProc, 16, 'ABS', wordType);
  enter(g_SProc, 17, 'ODD', intType);
  enter(g_SProc, 18, 'NEW', Nil);
  enter(g_SProc, 19, 'GETB', WordType);
  enter(g_SProc, 20, 'PUTB', NIL);
  enter(g_SProc, 21, 'EINIT', NIL);
  enter(g_SProc, 22, 'SRST', NIL);
  enter(g_SProc, 23, 'DUMMIJMP', NIL);
  enter(g_SProc, 24, 'LEN', WordType);
  enter(g_SProc, 26, 'NOP', NIL);
  enter(g_SProc, 27, 'JMP0', NIL);
  universe := topScope;
  ProcPar := FALSE;

  lastlinenr := 0;
  Listptr := NIL;
  UseUpper := False;
end.