{   obcc, a small oberoncompiler for the C16x-family
      based on Oberon-0 by N. Wirth

    Copyright Guido B. (user "guido-b" at http://www.mikrocontroller.net)

    Sprocs.pas, systemprocedures, is part of obcc.
    
    obcc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    obcc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with obcc.  If not, see <http://www.gnu.org/licenses/>.                }

UNIT Sprocs;

interface

PROCEDURE extp31;
PROCEDURE extr1(a: Word);
PROCEDURE extpr31(a: Word);
PROCEDURE start_Sproc;
PROCEDURE end_Sprocs;
PROCEDURE Addstringref(nr: Integer);
PROCEDURE AddTableRef(nr: Integer);
PROCEDURE Write_string(nr: INTEGER);
PROCEDURE Put_writeln;

PROCEDURE Put_Strings;
PROCEDURE Put_Tables;
PROCEDURE Put_Write;

implementation
uses obcd, obcs;

	{ Zugriff auf SFR als mem sicherstellen }
	PROCEDURE extp31;
	Begin
	  IF DPP[3] <> 3 THEN Begin
	    writeln(Taus, chr(9), 'extp', chr(9), '#3, #1');
	    addi($D740); addv(0003);
	  End;
	End;
	
	{ Zugriff auf extended SFR sicherstellen: }
	PROCEDURE extr1(a: Word);
	Begin
	  If (a > $EFFF) And (a < $F200) Then Begin
	    writeln(Taus, chr(9), 'extr', chr(9), '#1');
	    addi($D180);
	  End;
	End;
	
	{ Zugriff auf extended SFR sicherstellen: }
	PROCEDURE extpr31(a: Word);
	Begin
	  If (a > $EFFF) And (a < $F200) Then
	    If DPP[3] <> 3 Then Begin
	      writeln(Taus, chr(9), 'extpr', chr(9), '#3, #1');
	      addi($D4C0); addv(0003);
	    End
	    Else Begin
	      writeln(Taus, chr(9), 'extr', chr(9), '#1');
	      addi($D180);
	    End;
	End;

	PROCEDURE start_Sproc;
	Var p: Tsfrreg;
	BEGIN p := Fsfr('PSW');
	  writeln(Taus, chr(9), 'push', chr(9), HexWord(p.adr));
	  addi($EC00 + p.reg);
	  writeln(Taus, chr(9), 'push', chr(9), 'R0');
	  addi($EC00 + $F0);
	  writeln(Taus, chr(9), 'bclr', chr(9), HexWord(p.adr), '.11');
	  addi($BE00 + p.reg);
	  writeln(Taus, chr(9), 'add', chr(9), HexWord(CPadr),', #32');
	  addi($0600 + CPreg); addv(32);
	  writeln(Taus, chr(9), 'nop'); addi($CC00);
	  writeln(Taus, chr(9), 'pop', chr(9), 'R0');
	  addi($FCF0);
	END;

	PROCEDURE end_Sprocs;
	Var p: Tsfrreg;
	BEGIN p := Fsfr('PSW');
	  writeln(Taus, chr(9), 'sub', chr(9), HexWord(CPadr), ', #32');
	  addi($2600 + CPreg); addv(32);
	  writeln(Taus, chr(9), 'pop', chr(9), HexWord(p.adr));
	  addi($FC00 + p.reg);
	END;
	
	PROCEDURE Addstringref(nr: Integer);
	VAR i: Integer; lst: stringp;
	Begin lst := stringl;
	  While (lst <> Nil) And (lst^.nr <> nr) Do
	    lst := lst^.next;
	  If (lst <> NIL) And (lst^.lev = curlev) Then Begin
	    i := 0;
	    While (lst^.refs[i] <> 0) And (i < maxstringref) Do
	      i := i + 1;
	    If lst^.refs[i] = 0 Then
	      lst^.refs[i] := cap
	    Else Writeln(' Zu viele Referenzen fuer String ', nr);
	  End
	  Else Writeln('String Nr ', nr, ' nicht gefunden!');
	End;
	
	PROCEDURE AddTableRef(nr: Integer);
	VAR i: Integer; lst: tabp;
	Begin lst := tabl;
	  While (lst <> Nil) And (lst^.nr <> nr) Do
	    lst := lst^.next;
	  If (lst <> Nil) And ((lst^.lev = curlev) Or (lst^.lev = 0)) Then Begin
	    i := 0;
	    While (lst^.refs[i] <> 0) And (i < maxstringref) Do
	      i := i + 1;
	    If lst^.refs[i] = 0 Then
	      lst^.refs[i] := cap
	    Else Writeln(' Zu viele Referenzen fuer Table ', nr);
	  End
	  Else Writeln('Table Nr ', nr, ' nicht gefunden!');
	End;
	
	PROCEDURE Write_string(nr: INTEGER);
	  VAR s: string; lst: stringp; i: Integer;
	BEGIN str(nr,s);
	  lst := stringl;
	  While (lst <> Nil) And (lst^.nr <> nr) Do
	    lst := lst^.next;
	  If (lst^.nr = nr) And (lst^.lev = curlev) Then Begin
	    i := 0;
	    While (lst^.refs[i] <> 0) And (i < maxstringref) Do
	      i := i + 1;
	    If lst^.refs[i] = 0 Then Begin
	      addi($E600 + $F1); lst^.refs[i] := cap; addv(0);
	    End
	    Else Writeln(' Zu viele Referenzen fuer String ', nr);
	  End
	  Else Writeln('String Nr ', nr, ' nicht gefunden!');
	  writeln(Taus, chr(9), 'mov', chr(9), 'R1, #String', modname, s);
	  writeln(Taus, chr(9), 'calla', chr(9), 'writestr');
	  addi($CA00); addv(link.Writestr);
	END;
	
	PROCEDURE Put_writeln;
	Var p: Tsfrreg;
	BEGIN p := Fsfr('PSW');
	  writeln(Taus, chr(9), 'push', chr(9), HexWord(p.adr));
	  addi($EC00 + p.reg);
	  writeln(Taus, chr(9), 'bclr', chr(9), HexWord(p.adr), '.11');
	  addi($BE00 + p.reg);
	  writeln(Taus, chr(9), 'calla', chr(9), 'writeln');
	  addi($CA00); addv(link.Writeln);
	  writeln(Taus, chr(9), 'pop', chr(9), HexWord(p.adr));
	  addi($FC00 + p.reg);
	END;
	
	PROCEDURE Put_Strings;
	  VAR j: INTEGER; s: string; pstr: stringp;
	BEGIN 
	  pstr := stringl;
	  WHILE pstr <> Nil DO BEGIN
	    If (pstr^.lev = curlev) And (pstr^.inh <> '') Then Begin
	      { Referenzen aufloesen: }
		j := 0;
		While (pstr^.refs[j] <> 0) And (j < maxstringref) Do Begin
		  code[pstr^.refs[j]] := cap Mod 256;
		  code[pstr^.refs[j] + 1] := cap Div 256;
		  pstr^.refs[j] := 0; j := j + 1;
		End;
	      str(pstr^.nr, s); 
	      writeln(Taus, 'String', modname, s, ':');
	      s := pstr^.inh; j := 1;
	      write(Taus, chr(9), 'DB', chr(9), '"');
	      WHILE s[j] <> chr(0) DO BEGIN
		write(Taus, s[j]); 
		code[cap] := ord(s[j]); cap := cap + 1;
		j := j + 1; 
	      END;
	      write(Taus, '"');
	      WHILE j <= length(s) DO BEGIN
		write(Taus, ', 0'); 
		code[cap] := 0; cap := cap + 1;
		j := j + 1;
	      END;
	      Writeln(Taus); 
	      pstr^.inh := '';
	    End;
	    pstr := pstr^.next;
	  END;
	END;
	
	PROCEDURE Put_Tables;
	Var i, j: Integer; tab: tabp; s: String; tabadr: Word;
	Begin tab := tabl;
	  While tab <> NIL Do Begin //writeln(tab^.len, ', ', tab^.lev, ', ', curlev);
	    If (tab^.len <> 0) And (tab^.lev = curlev) Then Begin
	      tabadr := cap; { Fuer die Referenzen }
	      str(tab^.nr, s); s := 'Table' + ModName + s + ':';
	      writeln(Taus, s); write(Taus, chr(9), 'DW '); j := 0;
	      For i := 1 To tab^.len Do Begin
		write(taus, tab^.inh[i]); j := j + 1;
		addv(tab^.inh[i]);
		If j = 8 Then Begin
		  writeln(Taus); j := 0;
		  If i < tab^.len Then write(Taus, chr(9), 'DW ');
		End
		Else 
		  If i <> tab^.len Then write(Taus, ', ');
	      End;
	      If j <> 0 Then writeln(Taus);
	      tab^.len := 0;
	      { Referenzen aufloesen: }
	      i := 0;
	      While (tab^.refs[i] <> 0) And (i <= maxstringref) Do Begin
		reslink(tab^.refs[i], tabadr); tab^.refs[i] := 0; i := i + 1;
	      End;
	    End;
	    tab := tab^.next;
	  End;
	End;
	
	PROCEDURE Put_Write;
	VAR AscFlag, AscReg: String; p: Tsfrreg; 
	    AscAdrv, w, s: Word; AscRegv, AscFlagv: Byte;
	BEGIN Str(AscPort, AscReg); 
	  AscReg := 'S' + AscReg + 'TBUF';
	  p := Fsfr(Ascreg); AscReg := HexWord(p.adr);
	  AscRegv := p.reg; AscAdrv := p.adr;
	  Str(AscPort, AscFlag);
	  AscFlag := 'S' + AscFlag + 'TIC';
	  p := Fsfr(AscFlag); AscFlag := HexWord(p.adr) + '.7';
	  AscFlagv := p.reg; 
	  {writesign, Minuszeichen }
	  writeln(Taus, 'writesign:'); link.Writesign := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), AscReg, ', #45');
	  addi($E600 + AscRegv); addv(45);
	  writeln(Taus, 'writesign_1:'); w:= cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writesign_1');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(w));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  writeln(Taus, chr(9), 'ret', chr(9), chr(9), chr(9), '; writesign');
	  addi($CB00);
	  { WriteStr }
	  writeln(Taus, 'writestr:'); link.Writestr := cap;
	  { TODO: Der String liegt im Codesegment, ich nehme einfach Segment 0 an.
		  Dies muss noch auf das aktuelle Codesegment angepasst werden! }
	  writeln(Taus, chr(9), 'exts', chr(9), '#0, #1');
	  addi($D700); addv($0000);
	  writeln(Taus, chr(9), 'movb', chr(9), 'RL2, [R1+]');
	  addi($9941);
	  writeln(Taus, chr(9), 'jmp', chr(9), 'Z, writestr_e');
	  s := cap; addi(0);
	  extp31;
	  writeln(Taus, chr(9), 'movbz', chr(9), AscReg, ', RL2');
	    addi($C5F4); addv(AscAdrv);
	  writeln(Taus, 'writestr_1:'); w := cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writestr_1');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(w));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  writeln(Taus, chr(9), 'jmp', chr(9), 'writestr');
	  addi($0D00 + rbj(link.Writestr));
	  writeln(Taus, 'writestr_e:');
	  rfj(s, 2);  
	  writeln(Taus, chr(9), 'ret', chr(9), chr(9), chr(9), '; writestr');
	  addi($CB00);
	  { WriteLN }
	  writeln(Taus, 'writeln:'); link.Writeln := cap;
	  writeln(Taus, chr(9), 'mov', chr(9),  AscReg, ', #13');
	  addi($E600 + AscRegv); addv(13);
	  writeln(Taus, 'writeln_1:'); w := cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writeln_1');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(w));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  writeln(Taus, chr(9), 'mov', chr(9), AscReg, ', #10');
	  addi($E600 + AscRegv); addv(10);
	  writeln(Taus, 'writeln_2:'); w := cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writeln_2');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(w));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  writeln(Taus, chr(9), 'ret', chr(9), chr(9), chr(9), '; writeln');
	  addi($CB00);
	  { writeval }
	  writeln(Taus, 'writeval:'); link.Writeval := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), 'R2, #', hexword(vartop MOD $10000));
	  addi($E6F2); addv(vartop Mod $10000);
	  writeln(Taus, chr(9), 'add', chr(9), 'R2, #10');
	  addi($06F2); addv(10);
	  writeln(Taus, chr(9), 'mov', chr(9), 'R3, R2');
	  addi($F032);
	  extp31;
	  p := Fsfr('MDL');  
	  writeln(Taus, chr(9), 'mov', chr(9), HexWord(p.adr), ', R1');
	  addi($F6F1); addv(p.adr);
	  writeln(Taus, 'writev_1:'); w := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), 'R4, #10');
	  addi($E0A4);
	  writeln(Taus, chr(9), 'divu', chr(9), 'R4');
	  addi($5B44);
	  writeln(Taus, chr(9), 'jmp', chr(9), 'Z, writev_2');
	  s := cap; addi(0);
	  extp31;
	  p := Fsfr('MDH');
	  writeln(taus, chr(9), 'mov', chr(9), 'R5, ', HexWord(p.adr));
	  addi($F2F5); addv(p.adr);
	  writeln(Taus, chr(9), 'add', chr(9), 'R5, #48');
	  addi($06F5); addv(48);
	  writeln(Taus, chr(9), 'mov', chr(9), '[-R2], R5');
	  addi($8852);
	  writeln(Taus, chr(9), 'jmp', chr(9), 'writev_1');
	  addi($0D00 + rbj(w));
	  writeln(Taus, 'writev_2:');
	  rfj(s, 2);
	  extp31;
	  p := Fsfr('MDH');
	  writeln(taus, chr(9), 'mov', chr(9), 'R5, ', HexWord(p.adr));
	  addi($F2F5); addv(p.adr);
	  writeln(Taus, chr(9), 'add', chr(9), 'R5, #48');
	  addi($06F5); addv(48);
	  writeln(Taus, chr(9), 'mov', chr(9), '[-R2], R5');
	  addi($8852);
	  writeln(Taus, 'writev_3:'); w := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), 'R5, [R2+]');
	  addi($9852);
	  extp31;
	  writeln(Taus, chr(9), 'mov', chr(9), AscReg, ', R5');
	  addi($F6F5); addv(AscAdrv);
	  writeln(Taus, 'writev_4:'); s := cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writev_4');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(s));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  writeln(Taus, chr(9), 'cmp', chr(9), 'R2, R3');
	  addi($4023);
	  writeln(Taus, chr(9), 'jmp', chr(9), 'EQ, writev_e');
	  s := cap; addi(0);
	  writeln(Taus, chr(9), 'jmp', chr(9), 'writev_3');
	  addi($0D00 + rbj(w));
	  writeln(Taus, 'writev_e:');
	  rfj(s, 2);
	  writeln(Taus, chr(9), 'ret', chr(9), chr(9), chr(9), '; writeval');
	  addi($Cb00);
	  { writehex } 
	  writeln(Taus, 'writehex:'); link.Writehex := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), 'R2, #', hexword(vartop MOD $10000));
	  addi($E6F2); addv(vartop Mod $10000);
	  writeln(Taus, chr(9), 'add', chr(9), 'R2, #8');
	  addi($06F2); addv(8);
	  writeln(Taus, chr(9), 'mov', chr(9), 'R3, #4');
	  addi($E043);
	  writeln(Taus, 'writeh_1:'); w := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), 'R4, R1');
	  addi($F041);
	  writeln(Taus, chr(9), 'and', chr(9), 'R4, #15');
	  addi($66F4); addv(15);
	  writeln(Taus, chr(9), 'add', chr(9), 'R4, #48');
	  addi($06F4); addv(48);
	  writeln(Taus, chr(9), 'cmp', chr(9), 'R4, #57');
	  addi($46F4); addv(57); 
	  writeln(Taus, chr(9), 'jmp', chr(9), 'ULE, writeh_2');
	  s := cap; addi(0);
	  writeln(Taus, chr(9), 'add', chr(9), 'R4, #7');
	  addi($0847);
	  writeln(Taus, 'writeh_2:');
	  rfj(s, 15);
	  writeln(Taus, chr(9), 'mov', chr(9), '[-R2], R4');
	  addi($8842);
	  writeln(Taus, chr(9), 'shr', chr(9), 'R1, #4');
	  addi($7C00 + 64 + 1);
	  writeln(Taus, chr(9), 'sub', chr(9), 'R3, #1');
	  addi($2800 + 48 + 1); 
	  writeln(Taus, chr(9), 'jmp', chr(9), 'NZ, writeh_1');
	  addi($3D00 + rbj(w));
	  writeln(Taus, chr(9), 'mov', chr(9), 'R3, #4');
	  addi($E043);
	  writeln(Taus, 'writeh_3:'); w := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), 'R4, [R2+]');
	  addi($9842);
	  extp31;
	  writeln(Taus, chr(9), 'mov', chr(9), AscReg, ', R4');
	  addi($F6F4); addv(AscAdrv);
	  writeln(Taus, 'writeh_4:'); s := cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writeh_4');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(s));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  writeln(Taus, chr(9), 'sub', chr(9), 'R3, #1');
	  addi($2831);
	  writeln(Taus, chr(9), 'jmp', chr(9), 'NZ, writeh_3');
	  addi($3D00 + rbj(w));
	  writeln(Taus, chr(9), 'ret', chr(9), chr(9), chr(9), '; writehex');
	  addi($CB00);
	  { writechar }
	  writeln(Taus, 'writechar:'); link.Writechar := cap;
	  writeln(Taus, chr(9), 'mov', chr(9), 'R2, R1');
	  addi($F021);
	  writeln(Taus, chr(9), 'shr', chr(9), 'R2, #8');
	  addi($7C00 + $80 + 2);
	  extp31;
	  writeln(Taus, chr(9), 'mov', chr(9), AscReg, ', R2');
	  addi($F6F2); addv(AscAdrv);
	  writeln(Taus, 'writechar_1:'); w := cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writechar_1');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(w));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  extp31;
	  writeln(Taus, chr(9), 'mov', chr(9), AscReg, ', R1');
	  addi($F6F1); addv(AscAdrv);
	  writeln(Taus, 'writechar_2:'); w := cap;
	  Writeln(Taus, chr(9), 'jnb', chr(9), AscFlag, ', writechar_2');
	  addi($9A00 + AscFlagv); addv($7000 + rbj(w));
	  writeln(Taus, chr(9), 'bclr', chr(9), AscFlag);
	  addi($7E00 + AscFlagv);
	  writeln(Taus, chr(9), 'ret', chr(9), chr(9), chr(9), '; writechar');
	  addi($CB00);
	END;

end.