`include "rom.v"
`include "ram.v"

module vga_text(
 input  clock,			
 output hsync,
 output vsync,
 output reg[3:0] red,
 output reg [3:0] green,
 output reg [3:0] blue
);

wire clk;
wire [7:0] char;
wire [7:0] dat;
wire [9:0] charLin;

wire h_enable;
wire v_enable;
wire vid_enable;

reg [16:0] qc;
reg [32:0] cnt;
reg  Pixel;
reg [9:0]  CounterX; // 10 Bit, range 0..799
reg [9:0]  CounterY; //  10 Bit, range 0..524
reg [11:0] Basis;    // Adr. Zeilenanfang
reg [6:0]  Offs;	   // Pos. in Zeile 
reg [11:0] ZPos;	   // effektive Zeichenpos. in BWS	
reg [11:0] write_address;	  
reg [7:0] dat_w;
reg we;

rom myRom (.addr_a(charLin), .clk(clk), .q_a(dat));   // Zeichensatz
ram myRam (.q(char), .read_address(ZPos), .clk(clk),.write_address(write_address), .d(dat_w),.we(we)); // Bildspeicher

wire CounterXmaxed = (CounterX==800);
wire CounterYmaxed = (CounterY==525);

always @(posedge clock)
begin
  if (cnt <= 10000)
	  cnt = cnt + 1;
  else
  begin
    cnt =0; 
    we=1;
    
    write_address=write_address+1;    
    dat_w=dat_w+1;
    
    if (write_address==2399)
      write_address=0;
    if (dat_w==255)
      dat_w=0;    
  end  
end
 
always @(posedge clock)
begin
	qc <= qc + 1;
end
// 50Mhz  2^1 = 25MHz
assign clk = qc[0];

always @(posedge clk) begin 
// Zählen in horizontaler Richtung
  if(CounterXmaxed)
    CounterX <= 0;
  else begin 
    CounterX <= CounterX + 1;
    if (dat & (1 << CounterX[2:0])) 
      Pixel <= 1;
    else 
      Pixel <= 0;
  end

// Zählen in vertikaler Richtung
  if(CounterXmaxed) begin 
    if (CounterYmaxed) CounterY <= 0;
  else CounterY <= CounterY + 1;
  end

  if (CounterX[2:0] == 0) begin
    if (CounterX == 0 && CounterY == 0) Basis <= 0;
    else if (CounterX == 0 && CounterY[3:0]==0) Basis <= Basis + 80;
  end
  
  Offs <= CounterX[9:3];
  ZPos <= Basis + Offs;
end

always @(posedge clk)
begin
	if (vid_enable==1 && Pixel == 0)
    begin
      red = 4'b1111;
      blue = 4'b1111;
      green = 4'b1111;
    end 
    else
    begin
      red = 4'b0000;
      blue = 4'b0000;
      green = 4'b0000;
    end 
end

assign hsync = (CounterX < 655) || (CounterX > 751);
assign vsync = (CounterY < 489) || (CounterY > 491);	

assign charLin = {char,CounterY[3:1]};  // Zeiger fuer Zeichensatz

// Filter für video enable ableiten
assign h_enable = (CounterX > 3 && CounterX < 640);
assign v_enable = (CounterY < 480);
assign vid_enable = h_enable && v_enable;

endmodule 
