/*****************************************************************************
 
 i2crtc.c - RTC over I2C library 
		Designed for Atmels AVR MCUs
 
 Copyright (C) 2014 Patrick Eydt

 Supported by Falk Brunner
 
*****************************************************************************/

/*
	Version 1.00
*/

#include <avr/pgmspace.h>
#include <stdbool.h>
#include <stdint.h> 
#include <util/delay.h>
#include "i2crtc.h"
#include "i2cmaster.h"




/*------------------ Settings ------------------*/
/*- To set Funktions of the RTC                -*/
/*- Look data sheet at                         -*/
/*- DCF77 register, per .int. config register, -*/
/*- alarm config register, per. interrupt      -*/
/*----------------------------------------------*/

void rtc_settings ( uint8_t dcfled , uint8_t dcfie , uint8_t dcfe , uint8_t piled , uint8_t pie , uint8_t ailed , uint8_t aie, uint8_t pim )

//CHECKED & OK!!! by Patrick Eydt

{	
	if ( pim > 9 )
	{
		pim = 0;
	}



//Set DCF77 config register	

	
	if ( ( dcfled == 0 ) & ( dcfie == 0 ) & ( dcfe == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( 0x00 ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}
	
	if ( ( dcfled == 1 ) & ( dcfie == 0 ) & ( dcfe == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( DCFLED ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( (dcfled == 0 ) & ( dcfie == 1 ) & ( dcfe == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( DCFIE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( (dcfled == 0 ) & ( dcfie == 0 ) & ( dcfe == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( DCFE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( dcfled == 1 ) & ( dcfie == 1 ) & ( dcfe == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( DCFLED | DCFIE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( dcfled == 0 ) & ( dcfie == 1 ) & ( dcfe == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( DCFIE | DCFE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( dcfled == 1 ) & ( dcfie == 0 ) & ( dcfe == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( DCFLED | DCFE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( dcfled == 1 ) & ( dcfie == 1 ) & ( dcfe == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_DCF77_config ) ;
		i2c_write ( DCFLED | DCFIE | DCFE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

//Set periodic interrupt config register
	
	if ( ( piled == 0 ) & ( pie == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE+I2C_WRITE ) ;
		i2c_write ( RTC_per_int_conig ) ;
		i2c_write ( 0x00 );
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}
	
	if ( ( piled == 1 ) & ( pie == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE+I2C_WRITE ) ;
		i2c_write ( RTC_per_int_conig ) ;
		i2c_write ( PILED );
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( piled == 0 ) & (pie == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE+I2C_WRITE ) ;
		i2c_write ( RTC_per_int_conig ) ;
		i2c_write ( PIE );
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( piled == 1 ) & (pie == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE+I2C_WRITE ) ;
		i2c_write ( RTC_per_int_conig ) ;
		i2c_write ( PILED | PIE );
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}


//Set alarm config register

	if ( ( ailed == 0 ) & ( aie == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_ALARM_config ) ;
		i2c_write ( 0X00 ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}
	
	if ( ( ailed == 1 ) & ( aie == 0 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_ALARM_config ) ;
		i2c_write ( AILED ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( ailed == 0 ) & ( aie == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_ALARM_config ) ;
		i2c_write ( AIE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

	if ( ( ailed == 1 ) & ( aie == 1 ) )
	{
		i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
		i2c_write ( RTC_ALARM_config ) ;
		i2c_write ( AILED | AIE ) ;
		i2c_stop ( ) ;
		_delay_ms ( 5 ) ;
	}

//Set periodic interrupt register
	
	if ( pie == 1 )
	{
		switch ( pim )
		{
			case 0:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( RTC_periodic_int ) ;
					i2c_write ( PIM0 ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break ;
				}
			case 1:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( RTC_periodic_int ) ;
					i2c_write ( PIM1 ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break ;
				}
			case 2:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( RTC_periodic_int ) ;
					i2c_write ( PIM2 ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break ;
				}
			case 3:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( RTC_periodic_int ) ;
					i2c_write ( PIM3 ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break ;
				}
			case 4:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( RTC_periodic_int ) ;
					i2c_write ( PIM4 ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break ;
				}
			case 5:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( RTC_periodic_int ) ;
					i2c_write ( PIM5 ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break ;
				}
			case 6:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( RTC_periodic_int ) ;
					i2c_write ( 0x00 ) ;
					i2c_stop ( ) ;
					_delay_ms ( 6 ) ;
					break ;
				}
			default:
				{
				break ;
				}
		}
	}
}


/*--------- Write time of day on RTC, if DCF77 disabled ---------*/

void rtc_write_time ( uint8_t hour , uint8_t minutes , uint8_t seconds )	//CHECKED & OK!!! by Patrick Eydt
{

uint8_t hourbin , minutesbin , secondsbin , one , ten; 

	one = hour % 10 ;
	ten = ( hour - one ) / 10 ;
	hourbin = ( ten << 4 ) + one ;

	one = minutes % 10 ;
	ten = ( minutes - one ) / 10 ;
	minutesbin = ( ten << 4 ) + one ;

	one = seconds % 10 ;
	ten = ( seconds - one ) / 10 ;
	secondsbin = ( ten << 4 ) + one;

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x00 ) ;
	i2c_write ( secondsbin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 ) ;

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x01 ) ;
	i2c_write ( minutesbin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x02 ) ;
	i2c_write ( hourbin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );
}

/*--------- Write date and weekday on RTC, if DCF77 disabled ---------*/

void rtc_write_date ( uint8_t day , uint8_t month , uint8_t year, uint8_t weekday ) //ALL CHECKED & OK!!! by Patrick Eydt
{
	uint8_t daybin , monthbin , yearbin , one , ten; 

	weekday &= 6 ;
	
	one = day % 10 ;
	ten = ( day - one ) / 10 ;
	daybin = ( ten << 4 ) + one ;

	one = month % 10 ;
	ten = ( month - one ) / 10 ;
	monthbin = ( ten << 4 ) + one ;

	if ( year > 99 )
	{
	year = year - 100 ;
	}
	one = year % 10 ;
	ten = ( year - one ) / 10 ;
	yearbin = ( ten << 4 ) + one;

	switch ( weekday )
	{
			case 0:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x03 ) ;
					i2c_write ( Mo ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}

			case 1:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x03 ) ;
					i2c_write ( Tu ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
			
			case 2:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x03 ) ;
					i2c_write ( We ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}

			case 3:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x03 ) ;
					i2c_write ( Th ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
			
			case 4:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x03 ) ;
					i2c_write ( Fr ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}

			case 5:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x03 ) ;
					i2c_write ( Sa ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
			
			case 6:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x03 ) ;
					i2c_write ( Su ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
	}

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x04 ) ;
	i2c_write ( daybin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x05 ) ;
	i2c_write ( monthbin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x06 ) ;
	i2c_write ( yearbin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );
}

/*--------- Write alarm time  ---------*/

void rtc_write_alarmtime ( uint8_t hour , uint8_t minutes )
{
	uint8_t hourbin , minutesbin ,  one , ten; 

	one = hour % 10 ;
	ten = ( hour - one ) / 10 ;
	hourbin = ( ten << 4 ) + one ;

	one = minutes % 10 ;
	ten = ( minutes - one ) / 10 ;
	minutesbin = ( ten << 4 ) + one ;

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x07 ) ;
	i2c_write ( minutesbin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 ) ;

	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x08 ) ;
	i2c_write ( hourbin ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );
}


/*--------- Write alarm weekday on RTC ---------*/

void rtc_write_alarmweekday( uint8_t weekday )
{
	if ( weekday > 6 )
	{
		weekday = 0 ;
	}
	
	switch ( weekday )
	{
			case 0:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x09 ) ;
					i2c_write ( AWMO ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}

			case 1:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x09 ) ;
					i2c_write ( AWTU ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
			
			case 2:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x09 ) ;
					i2c_write ( AWWE ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break; 
				}

			case 3:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x09 ) ;
					i2c_write ( AWTH ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
			
			case 4:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x09 ) ;
					i2c_write ( AWFR ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}

			case 5:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x09 ) ;
					i2c_write ( AWSA ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
			
			case 6:
				{
					i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
					i2c_write ( 0x09 ) ;
					i2c_write ( AWSU ) ;
					i2c_stop ( ) ;
					_delay_ms ( 5 ) ;
					break;
				}
	}
}


/*--------- Quit alarms ---------*/

void rtc_quit_peri_interrupt ( void )	//CHECKED & OK!!! by Patrick Eydt
{	
	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x0E ) ;
	i2c_write ( PIF ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );
} //testet! OK!

void rtc_quit_alarm ( void )
{
	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x0E ) ;
	i2c_write ( AIF ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );
}

void rtc_quit_DCF77_int ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	i2c_start ( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( 0x0E ) ;
	i2c_write ( DCFIF ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );
}




/*---------	Read Data from RTC ---------*/

unsigned char rtc_time_seconds ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	unsigned char secondsbin, seconds ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_second ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	secondsbin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	seconds = ( ( ( ( secondsbin & 0x70 ) >> 4 ) * 10 ) + ( secondsbin & 0xf ) ) ;

	return seconds;
}

uint8_t rtc_time_minutes ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t minutesbin, minutes ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_minute ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	minutesbin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	minutes = ( ( ( ( minutesbin & 0x70 ) >> 4 ) * 10 ) + ( minutesbin & 0xf ) ) ;

	return minutes;
}

uint8_t rtc_time_hour ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t hourbin, hour ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_hour ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	hourbin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	hour = ( ( ( ( hourbin & 0x30 ) >> 4 ) * 10 ) + ( hourbin & 0xf ) ) ;

	return hour;
}

uint8_t rtc_date_weekday ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t weekdaybin, weekday ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_week_day ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	weekdaybin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	weekday = ( weekdaybin & 0x7 ) ;
	
	return weekday;
}

uint8_t rtc_date_day ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t daybin, day ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_day ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	daybin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	day = ( ( ( ( daybin & 0x30 ) >> 4 ) * 10 ) + ( daybin & 0xf ) ) ;

	return day;
}

uint8_t rtc_date_month ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t monthbin, month ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_month ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	monthbin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	month = ( ( ( ( monthbin & 0x10 ) >> 4 ) * 10 ) + ( monthbin & 0xf ) ) ;

	return month;
}

uint8_t rtc_date_year ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t yearbin, year ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_year ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	yearbin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	year = ( ( ( yearbin >> 4 ) * 10 ) + ( yearbin & 0xf ) ) ;

	return year;
}

uint8_t rtc_read_alarmtime_minute ( void ) 
{
	uint8_t minutebin, minute ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_ARLAM_minute ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	minutebin = i2c_readNak();
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	minute = ( ( ( ( minutebin & 0x70 ) >> 4 ) * 10 ) + ( minutebin & 0xf ) ) ;

	return minute;
}

uint8_t rtc_read_alarmtime_hour ( void ) 
{
	uint8_t hourbin, hour ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_ALARM_hour ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	hourbin = i2c_readNak ( ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	hour = ( ( ( ( hourbin & 0x30 ) >> 4 ) * 10 ) + ( hourbin & 0xf ) ) ;

	return hour;
}

uint8_t rtc_read_alarmweekday ( void ) 
{
	uint8_t weekdaybin, weekday ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_ALARM_week_day ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	weekdaybin = i2c_readNak ( ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	weekday = ( weekdaybin & 0x7F ) ;

	return weekday;
}

uint8_t rtc_read_periodic_interrupt ( void ) 
{
	uint8_t interruptbin, interrupt ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_periodic_int ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	interruptbin = i2c_readNak ( ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	interrupt = ( interruptbin & 0x07 ) ;

	return interrupt;
}

uint8_t rtc_read_alarm_config ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t alarmbin, alarm ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_ALARM_config ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	alarmbin = i2c_readNak ( ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	alarm = ( alarmbin & 0x06 ) ;

	return alarm;
}

uint8_t rtc_read_periodic_interrupt_config ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t interruptbin, interrupt ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_per_int_conig ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	interruptbin = i2c_readNak ( ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	interrupt = ( interruptbin & 0x06 ) ;

	return interrupt;
}

uint8_t rtc_read_DCF77_config ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t DCF77bin, DCF77 ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_DCF77_config ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	DCF77bin = i2c_readNak ( ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	DCF77 = ( DCF77bin & 0x07 ) ;

	return DCF77;
}

uint8_t rtc_read_status_register ( void )	//CHECKED & OK!!! by Patrick Eydt
{
	uint8_t statusbin, status ;

	i2c_start( RTC_I2C_DEVICE + I2C_WRITE ) ;
	i2c_write ( RTC_Status ) ;
	i2c_rep_start ( RTC_I2C_DEVICE + I2C_READ ) ;
	statusbin = i2c_readNak ( ) ;
	i2c_stop ( ) ;
	_delay_ms ( 5 );

	status = ( statusbin & 0x07 ) ;

	return status;
}



