/************************************************************************************/
/*																					*/ 
/* i2crtc.h - ELV RTC with DCF77 receiver ( Ordernumber 130 541 ) over I2C library	*/
/*		Designed for Atmels AVR MCUs												*/
/*																					*/
/* Copyright (C) 2014 Patrick Eydt													*/
/*																					*/
/************************************************************************************/

/*
	Version 1.00
*/


#ifndef _I2CRTC_H			
#define _I2CRTC_H			

//------------- RTC-I2C-Adress --------------*

#define RTC_I2C_DEVICE		0xCE    /** <- Change this to the address of your expander */
									/* !!! ATTENTION !!! The Deviceaddress must be multiplied by two */

/*------------- RTC-Register-Addresses -------------*/

//Status+Generalconfig-Register
 
	#define RTC_Status			0x0E	// RTC-Status-Register 
	#define RTC_DCF77_config	0x0D	// DCF77-Config- Register
	
//Time-Register
	#define RTC_second			0x00	//Second of Time
	#define RTC_minute			0x01	//Minute of Time
	#define RTC_hour			0x02	//Hour of Time
	#define RTC_week_day		0x03	//What day of the week
	#define RTC_day				0x04	//Day of month
	#define RTC_month			0x05	//Month of the year
	#define RTC_year			0x06	//What year

// Alarm-Register 
	#define RTC_ARLAM_minute			0x07	//Alarm minute
	#define RTC_ALARM_hour				0x08	//Alarm hour
	#define RTC_ALARM_week_day			0x09	//Alarm weekday
	#define RTC_ALARM_config			0x0B	//Alarm-Config-Register
 

// Interrupt-Register
 
	#define RTC_periodic_int			0x0A	//periodic-interrupt
	#define RTC_per_int_conig			0x0C	//periodic-interrupt-config-register


/*------------- Bits of registers -------------*/

//Week day

	#define Mo							0x01	//Monday
	#define Tu							0x02	//Tuesday
	#define We							0x03	//Wednesday
	#define Th							0x04	//Thursday
	#define Fr							0x05	//Friday
	#define Sa							0x06	//Saturday
	#define Su							0x07	//Sunday

//Alarm-weekday

	#define AWMO						0x01	//Monday
	#define AWTU						0x02	//Tuesday
	#define AWWE						0x04	//Wednesday
	#define AWTH						0x08	//Thursday
	#define AWFR						0x16	//Friday
	#define AWSA						0x32	//Saturday
	#define AWSU						0x64	//Sunday

//Periodic-Interrupt-Register

	#define PIM0						0x00	//1 Hz
	#define PIM1						0x01	//2 Hz
	#define PIM2						0x02	//every second
	#define PIM3						0x03	//every minute
	#define PIM4						0x04	//every hour
	#define PIM5						0x05	//every day, at 0 OClock
	#define PIM6						0x06	//every month, on the 1.st at 0 OClock 

//Alarm-Config-Register

	#define AILED						0x04	// LED on, when Alarm Interrupts 
	#define AIE							0x02	// Alarm Interrupt enable

//Periodic-Interrupt-Config-Register

	#define PILED						0x04	//LED on, when Interrupt
	#define PIE							0x02	//periodic Interrupt enabel

//DCF77-Config-Register

	#define DCFLED						0x04	//LED on, when DCF77 signal
	#define DCFIE						0x02	//Interrupt enable when DFC77 signal
	#define DCFE						0x01	//DCF-receiver enable

//Status-Register

	#define AIF							0x04	//Alarm Interrupt Flag
	#define PIF							0x02	//Periodic Interrupt Flag
	#define DCFIF						0x01	//DCF-revive Interrupt Flag


/*------------- I2C - Functions -------------*/

//Write to RTC 

void rtc_settings ( uint8_t dcfled , uint8_t dcfie , uint8_t dcfe , uint8_t piled , uint8_t pie , uint8_t ailed , uint8_t aie, uint8_t pim ) ;

void rtc_write_time ( uint8_t hour , uint8_t minutes , uint8_t seconds ) ;

void rtc_write_date ( uint8_t day , uint8_t month , uint8_t year, uint8_t weekday ) ;

void rtc_write_alarmtime ( uint8_t hour , uint8_t minutes ) ;

void rtc_write_alarmweekday( uint8_t weekday ) ;

void rtc_quit_peri_interrupt ( void ) ;

void rtc_quit_alarm ( void ) ;

void rtc_quit_DCF77_int ( void ) ;


//Read from RTC

uint8_t rtc_time_seconds ( void ) ;

uint8_t rtc_time_minutes ( void ) ;

uint8_t rtc_time_hour ( void ) ;

uint8_t rtc_date_weekday ( void ) ;

uint8_t rtc_date_day ( void ) ;

uint8_t rtc_date_month ( void ) ;

uint8_t rtc_date_year ( void ) ;

uint8_t rtc_read_alarmtime_minute ( void ) ; 

uint8_t rtc_read_alarmtime_hour ( void ) ;

uint8_t rtc_read_alarmweekday ( void ) ;
 
uint8_t rtc_read_periodic_interrupt ( void ) ;

uint8_t rtc_read_alarm_config ( void ) ;

uint8_t rtc_read_periodic_interrupt_config ( void ) ;

uint8_t rtc_read_DCF77_config ( void ) ;

uint8_t rtc_read_status_register ( void ) ;


#endif
