/*--------------------------------------------------------------------------*/
/*																			*/
/* Testprogramm fr die i2crtc.c und i2crtc.h								*/
/* Erstellt durch:				Patrick Eydt		patricke21@arcor.de		*/
/* untersttzt durch: 			Falk Brunner								*/
/*																			*/
/* Version 1.0										22:28 Uhr	10.10.2014	*/
/*																			*/
/*--------------------------------------------------------------------------*/
/*																			*/
/* Verwendete Hardware:														*/
/*																			*/
/* - ATMega32																*/
/* - ELV RTC mit DCF77 Empfnger ( Bestell- Nr. : 130 541 )					*/
/* - Pollin LCD/I2C - Modul ( Bestell- Nr. : 810 145 )						*/
/*																			*/
/*--------------------------------------------------------------------------*/
/*																			*/
/* Dieses Programm wurde zu Testzwecken erstellt und diente dazu die 		*/
/* Programmcodes i2crtc.h und i2crtc.c zu testen.							*/
/* 																			*/
/* Hier werden alle Lese- und Schreibbefehle auf die Register der RTC ge-	*/
/* testet. Die gelesenen Daten werden dann auf einem, am I2C-Bus 			*/
/* angeschlossenem, Display dargestellt.									*/
/*																			*/
/* Smtlicher Programmcode der Dateien, main_RTC.C, i2crtc.c und i2crtc.h	*/
/* wurde getestet und funktioniert auf meiner Hardware.						*/
/*																			*/
/* 																			*/
/* Da ich Programmieranfnger bin und Fehler nicht ausschlieen kann,		*/
/* weise ich daraufhin, dass die Verwendung dieser Codes AUSSCHLIELICH !	*/
/* auf eigene Gefahr geschieht!												*/
/*																			*/
/*--------------------------------------------------------------------------*/



#include <avr/io.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdint.h> 
#include <avr/pgmspace.h>
#include <stdlib.h>
#include "main.h"
#include <util/delay.h>
#include "i2crtc.h"
#include "i2clcd.h"
#include "i2cmaster.h"

//#define F_CPU 16000000UL

/*---- Set RTC Funktions */

#define dcfled	1	// 1 = LED turn on when a DCF77 signal is received
#define dcfie	1	// 1 = Interrupt is set when a DCF77 signal is received
#define dcfe	1	// 1 = Enabled the DCF77 receiver
#define piled	1	// 1 = LED turn on when a periodical Interrupt is set
#define pie		1	// 1 = Enabled the periodical Interrupt
#define ailed	0	// 1 = LED turn on when a alarm interrupt is set
#define aie		0	// 1 = Enabeld the alarm interrupt
#define pim 	3	//	Set the periodical Interrupt:
/* 						0 = 1 Hz ;
						1 = 2 Hz ;
						2 = every second ;
						3 = every minute ;
						4 = every hour ;
						5 = every Day @ 0 Clock
						6 = every 1st of the month by 0 Clock */ 


/*---- Set Time if DCF77 modul is disable ----*/

#define SEKUNDE		0
#define MINUTE		0
#define STUNDE		0


/*---- Set Date if DCF77 modul is disable ----*/

#define TAG			1
#define MONAT		1
#define JAHR		12


/*---- Set Week day ----*/

#define WOCHENTAG	0	// 0 = Monday
						// 1 = Tuesday
						// 2 = Wednesday
						// 3 = Thursday
						// 4 = Friday
						// 5 = Saturday
						// 6 = Sunday


/*---- Set time of alarm ----*/

#define ALARM_MINUTE 0
#define ALARM_STUNDE 0
#define ALARM_TAG 0	// 0 = Monday
					// 1 = Tuesday
					// 2 = Wednesday
					// 3 = Thursday
					// 4 = Friday
					// 5 = Saturday
					// 6 = Sunday

				
/*--------------------------------------------------------------------------------------*/

int main(void)
{
	_delay_ms ( 5000 ) ; // Wartezeit bis RTC sich nach Spannungsausfall erhohlt hat!!!!

	DDRB |= _BV ( PB0 ) | _BV ( PB1 ) | _BV ( PB2 ) ;

	uint8_t status_RTC = 0 , DCF77_status = 0 , per_int_config_reg = 0 , alarm_config_reg = 0;
	uint8_t sekunde = 0, minute = 0, stunde = 0 , tag = 0 , monat = 0 , jahr = 0 ;
	uint8_t wochentag = 0 , Uhrlaeuft = 0 ; 
	char string [ 10 ] , doppelpunkt [ ] = ":" , punkt[] = "." , zeileloeschen [ ] = "                " ;

	i2c_init ( ) ;
	_delay_ms ( 5 ) ;
	lcd_init ( ) ;
	_delay_ms ( 5 ) ;
	

	rtc_settings ( dcfled , dcfie , dcfe , piled , pie , ailed , aie, pim ) ;
	lcd_light ( false ) ;

// Uhrzeit einstellen

	if ( dcfe == 0)
	{
		rtc_write_time ( STUNDE , MINUTE , SEKUNDE ) ;
		rtc_write_date ( TAG , MONAT , JAHR , WOCHENTAG ) ;
		Uhrlaeuft = 1 ;
	}

//Alarmzeit einstellen

	if ( AIE != 0 )
	{
		rtc_write_alarmtime ( ALARM_STUNDE , ALARM_MINUTE ) ;
		rtc_write_alarmweekday( ALARM_TAG ) ;
	}

	while(1)
	{

// Abfrage und Ausgabe des Statusregisters		
		
//		
		
		if ( ( ( status_RTC & 0x1 ) == 1 ) || ( Uhrlaeuft  != 0 ) )
		{

			if ( Uhrlaeuft != 0 ) ;
			{
				lcd_gotolc ( 1 , 1 ) ;
				lcd_print ( zeileloeschen ) ;
				lcd_gotolc ( 2 , 1 ) ;
				lcd_print ( zeileloeschen ) ;
			}

// Abfrage und Ausgabe der Uhrzeit
			stunde = rtc_time_hour ( ) ;
			sprintf ( string , "%02d" , stunde ) ;	// ( stunde , string , 10 ) ;	//Umwandeln der Zahl in einen String
			lcd_gotolc ( 1 , 1 ) ;			// Ausgabe auf dem Display Zeile / Spalte
			lcd_print ( string ) ;			// Textausgabe

			lcd_gotolc ( 1 , 3 ) ;
			lcd_print ( doppelpunkt ) ;

			minute = rtc_time_minutes ( ) ;
			sprintf ( string , "%02d" , minute ) ;	//itoa ( minute , string , 10 ) ;
			lcd_gotolc ( 1 , 4 ) ;
			lcd_print ( string );

			lcd_gotolc ( 1 , 6 ) ;
			lcd_print ( doppelpunkt ) ;

			sekunde = rtc_time_seconds ( ) ;
			sprintf ( string , "%02d" , sekunde ) ;	//itoa ( sekunde , string , 10 ) ;
			lcd_gotolc ( 1 , 7 ) ;
			lcd_print ( string ) ;
		
		
// Abfrage und Ausgabe des Datums

			tag = rtc_date_day ( ) ;
			sprintf (string , "%02d" , tag ) ;	//itoa ( tag , string , 10 ) ; //Umwandeln der Zahl in einen String
			lcd_gotolc ( 2 , 1 ) ;
			lcd_print ( string ) ;

			lcd_gotolc ( 2 , 3 ) ;
			lcd_print ( punkt ) ;

			monat = rtc_date_month ( ) ;
			sprintf ( string , "%02d" , monat ) ;	//itoa ( monat , string , 10 ) ; //Umwandeln der Zahl in einen String
			lcd_gotolc ( 2 , 4 ) ;
			lcd_print ( string ) ;

			lcd_gotolc ( 2 , 6 ) ;
			lcd_print ( punkt ) ;
		
			jahr = rtc_date_year ( ) ;
			sprintf ( string , "%02d" , jahr ) ;	//itoa ( jahr , string , 10 ) ; //Umwandeln der Zahl in einen String
			lcd_gotolc ( 2 , 7 ) ;
			lcd_print ( string ) ;


	//Abfrage und Ausgabe des Wochentages

			wochentag = rtc_date_weekday ( ) ;

			switch ( wochentag ) 
			{
				case 0:
				{
					break ;
				}
			
				case 1:
				{
					lcd_gotolc ( 2 , 15 ) ;
					lcd_print_P ( PSTR ( "Mo" ) ) ;
					break ;
				}

				case 2:
				{
					lcd_gotolc ( 2 , 15 ) ;
					lcd_print_P ( PSTR ( "Tu" ) ) ;
					break ;
				}

				case 3:
				{
					lcd_gotolc ( 2 , 15 ) ;
					lcd_print_P ( PSTR ( "We" ) ) ;
					break ;
				}
			
				case 4:
				{
					lcd_gotolc ( 2 , 15 ) ;
					lcd_print_P ( PSTR ( "Th" ) ) ;
					break ;
				}

				case 5:
				{
					lcd_gotolc ( 2 , 15 ) ;
					lcd_print_P ( PSTR ( "Fr" ) ) ;
					break ;
				}

				case 6:
				{
					lcd_gotolc ( 2 , 15 ) ;
					lcd_print_P ( PSTR ( "Sa" ) ) ;
					break ;
				}

				case 7:
				{
					lcd_gotolc ( 2 , 15 ) ;
					lcd_print_P ( PSTR ( "Su" ) ) ;
					break ;
				}
			
				default:
				{
				break ;
				}
			}

			_delay_ms ( 250 ) ;

			alarm_config_reg = rtc_read_alarm_config ( ) ;
			itoa ( alarm_config_reg , string , 10 ) ;
			lcd_gotolc ( 1 , 10) ;
			lcd_print ( string ) ;
		
			per_int_config_reg = rtc_read_periodic_interrupt_config ( ) ;
			itoa ( per_int_config_reg , string , 10 ) ;
			lcd_gotolc ( 1 , 12) ;
			lcd_print ( string ) ;
		
			DCF77_status = rtc_read_DCF77_config ( ) ;
			itoa ( DCF77_status , string , 10 ) ;
			lcd_gotolc ( 1 , 14) ;
			lcd_print ( string ) ;
	
			status_RTC = rtc_read_status_register ( ) ;
			itoa ( status_RTC , string , 10 ) ;
			lcd_gotolc ( 1 , 16 ) ;
			lcd_print ( string ) ;
	
			_delay_ms ( 250 ) ;
		
	// Zurcksetzen der Alarmmeldungen
				
			if ( status_RTC != 0x00 )
			{
				if ( ( status_RTC & 0x1 ) != 0 )
				{
					_delay_ms ( 1000 ) ;	
					rtc_quit_DCF77_int ( ) ;
					lcd_command( LCD_CLEAR ) ;
	 				_delay_ms ( 5 ) ;
				}

				if ( ( status_RTC & 0x2 ) != 0 ) 
				{
					_delay_ms ( 1000 ) ;	
					rtc_quit_peri_interrupt ( ) ;
					lcd_command( LCD_CLEAR ) ;
		 			_delay_ms ( 5 ) ;
				}

				if ( ( status_RTC & 0x4 ) != 0 )
				{
					_delay_ms ( 1000 ) ;
					rtc_quit_alarm ( ) ;
					lcd_command( LCD_CLEAR ) ;
					_delay_ms ( 5 ) ;
				}
			}
				
			Uhrlaeuft = 1 ;
			_delay_ms ( 900 ) ;
		}
	
		else
		{
			lcd_gotolc ( 1 , 1 ) ;
			lcd_print_P ( PSTR ( "Warten auf DCF77" ) ) ;
			lcd_gotolc ( 2 , 1 ) ;
			lcd_print_P ( PSTR ( "Signal" ) ) ;
		}
	
//	} while (1) END

		while ( Uhrlaeuft != 1 )
		{	
		
// Abfrage und Ausgabe des Statusregisters		
	
		
			alarm_config_reg = rtc_read_alarm_config ( ) ;
			itoa ( alarm_config_reg , string , 10 ) ;
			lcd_gotolc ( 2 , 10) ;
			lcd_print ( string ) ;
		
			per_int_config_reg = rtc_read_periodic_interrupt_config ( ) ;
			itoa ( per_int_config_reg , string , 10 ) ;
			lcd_gotolc ( 2 , 12) ;
			lcd_print ( string ) ;
		
			DCF77_status = rtc_read_DCF77_config ( ) ;
			itoa ( DCF77_status , string , 10 ) ;
			lcd_gotolc ( 2 , 14) ;
			lcd_print ( string ) ;
	
			status_RTC = rtc_read_status_register ( ) ;
			itoa ( status_RTC , string , 10 ) ;
			lcd_gotolc ( 2 , 16 ) ;
			lcd_print ( string ) ;
	
			_delay_ms ( 500 ) ;
		
	// Zurcksetzen der Alarmmeldungen
				
			if ( status_RTC != 0x00 )
			{
				if ( ( status_RTC & 0x1 ) != 0 )
				{
					Uhrlaeuft = 1 ;					// Startet die ausgabe der Uhrzeit
					_delay_ms ( 1000 ) ;	
//					rtc_quit_DCF77_int ( ) ;
//					lcd_command( LCD_CLEAR ) ;
//	 				_delay_ms ( 5 ) ;
				}

				if ( ( status_RTC & 0x2 ) != 0 ) 
				{
//					Uhrlaeuft = 1 ;					// <- Test ob auslesen Funktioniert
					_delay_ms ( 1000 ) ;	
					rtc_quit_peri_interrupt ( ) ;
//					lcd_command( LCD_CLEAR ) ;
//		 			_delay_ms ( 5 ) ;
				}

				if ( ( status_RTC & 0x4 ) != 0 )
				{
//					Uhrlaeuft = 1 ;					// <- Test ob auslesen Funktioniert
					_delay_ms ( 1000 ) ;
					rtc_quit_alarm ( ) ;
//					lcd_command( LCD_CLEAR ) ;
//					_delay_ms ( 5 ) ;
				}
			}
		}
	}
}




