library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.Numeric_Std.all;

entity ram is
  port (
    clk25   : in  std_logic;
    we      : in  std_logic;
    wr_addr : in  std_logic_vector (11 downto 0);
    rd_addr : in  std_logic_vector (11 downto 0);
    d       : in  std_logic_vector (7 downto 0);
    q       : out std_logic_vector (7 downto 0)
  );
end entity ram;

architecture RTL of ram is

type ram_type is array (0 to 2399) of std_logic_vector(7 downto 0);
signal ram : ram_type :=(
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"54", x"65", x"73", x"6c", x"61", x"20", x"37", x"32", x"30", x"32", 
  x"20", x"43", x"68", x"61", x"72", x"61", x"63", x"74", x"65", x"72", 
  x"20", x"53", x"65", x"74", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", 
  x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", x"3d", 
  x"3d", x"3d", x"3d", x"3d", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"64", x"69", x"73", x"70", x"6c", x"61", x"79", x"65", x"64", x"20", 
  x"62", x"79", x"20", x"61", x"6e", x"20", x"41", x"6c", x"74", x"65", 
  x"72", x"61", x"20", x"43", x"79", x"63", x"6c", x"6f", x"6e", x"65", 
  x"20", x"49", x"49", x"20", x"46", x"50", x"47", x"41", x"20", x"62", 
  x"6f", x"61", x"72", x"64", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"00", x"01", x"02", x"03", x"04", x"05", x"06", x"07", x"08", x"09", 
  x"0a", x"0b", x"0c", x"0d", x"0e", x"0f", x"10", x"11", x"12", x"13", 
  x"14", x"15", x"16", x"17", x"18", x"19", x"1a", x"1b", x"1c", x"1d", 
  x"1e", x"1f", x"20", x"21", x"22", x"23", x"24", x"25", x"26", x"27", 
  x"28", x"29", x"2a", x"2b", x"2c", x"2d", x"2e", x"2f", x"30", x"31", 
  x"32", x"33", x"34", x"35", x"36", x"37", x"38", x"39", x"3a", x"3b", 
  x"3c", x"3d", x"3e", x"3f", x"40", x"41", x"42", x"43", x"44", x"45", 
  x"46", x"47", x"48", x"49", x"4a", x"4b", x"4c", x"4d", x"4e", x"4f", 
  x"50", x"51", x"52", x"53", x"54", x"55", x"56", x"57", x"58", x"59", 
  x"5a", x"5b", x"5c", x"5d", x"5e", x"5f", x"60", x"61", x"62", x"63", 
  x"64", x"65", x"66", x"67", x"68", x"69", x"6a", x"6b", x"6c", x"6d", 
  x"6e", x"6f", x"70", x"71", x"72", x"73", x"74", x"75", x"76", x"77", 
  x"78", x"79", x"7a", x"7b", x"7c", x"7d", x"7e", x"7f", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"48", x"65", x"6c", x"6c", x"6f", x"20", x"57", x"6f", 
  x"72", x"6c", x"64", x"21", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", 
  x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20", x"20" );
  
begin

process
begin
  wait until rising_edge(clk25);
    if we = '1' then
      ram((to_integer(unsigned(wr_addr)))) <= d;   
    else   
      q <= ram((to_integer(unsigned(rd_addr)))); 
    end if;  
end process;
end architecture RTL;