library IEEE;
use IEEE.STD_LOGIC_1164.all;
use IEEE.Numeric_Std.all;

entity rom is
  port (
    clk25   : in  std_logic;
    addr_a  : in  std_logic_vector (11 downto 0);
    q_a     : out  std_logic_vector (7 downto 0)
 );
end entity rom;

architecture RTL of rom is

type rom_type is array (0 to 1023) of std_logic_vector(7 downto 0);
signal rom : rom_type :=(
x"C3", x"66", x"67", x"67", x"60", x"64", x"C3", x"00", 
x"81", x"C3", x"66", x"E7", x"66", x"66", x"66", x"00", 
x"E3", x"66", x"66", x"E3", x"66", x"66", x"E3", x"00", 
x"C3", x"66", x"60", x"60", x"60", x"66", x"C3", x"00", 
x"E1", x"63", x"66", x"66", x"66", x"63", x"E1", x"00", 
x"E7", x"60", x"60", x"E1", x"60", x"60", x"E7", x"00", 
x"E7", x"60", x"60", x"E1", x"60", x"60", x"60", x"00", 
x"C3", x"66", x"60", x"67", x"66", x"66", x"C3", x"00", 
x"66", x"66", x"66", x"E7", x"66", x"66", x"66", x"00", 
x"C3", x"81", x"81", x"81", x"81", x"81", x"C3", x"00", 
x"87", x"03", x"03", x"03", x"03", x"63", x"C1", x"00", 
x"66", x"63", x"E1", x"E0", x"E1", x"63", x"66", x"00", 
x"60", x"60", x"60", x"60", x"60", x"60", x"E7", x"00", 
x"6C", x"EE", x"EF", x"6D", x"6C", x"6C", x"6C", x"00", 
x"66", x"E6", x"E7", x"E7", x"67", x"66", x"66", x"00", 
x"C3", x"66", x"66", x"66", x"66", x"66", x"C3", x"00", 
x"E3", x"66", x"66", x"E3", x"60", x"60", x"60", x"00", 
x"C3", x"66", x"66", x"66", x"66", x"C3", x"07", x"00", 
x"E3", x"66", x"66", x"E3", x"E1", x"63", x"66", x"00", 
x"C3", x"66", x"60", x"C3", x"06", x"66", x"C3", x"00", 
x"E7", x"81", x"81", x"81", x"81", x"81", x"81", x"00", 
x"66", x"66", x"66", x"66", x"66", x"66", x"C3", x"00", 
x"66", x"66", x"66", x"66", x"66", x"C3", x"81", x"00", 
x"6C", x"6C", x"6C", x"6D", x"EF", x"EE", x"6C", x"00", 
x"66", x"66", x"C3", x"81", x"C3", x"66", x"66", x"00", 
x"66", x"66", x"66", x"C3", x"81", x"81", x"81", x"00", 
x"E7", x"06", x"03", x"81", x"C0", x"60", x"E7", x"00", 
x"C3", x"C0", x"C0", x"C0", x"C0", x"C0", x"C3", x"00", 
x"03", x"84", x"C0", x"E3", x"C0", x"64", x"F3", x"00", 
x"C3", x"03", x"03", x"03", x"03", x"03", x"C3", x"00", 
x"00", x"81", x"C3", x"E7", x"81", x"81", x"81", x"81", 
x"00", x"80", x"C0", x"EF", x"EF", x"C0", x"80", x"00", 
x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", 
x"81", x"81", x"81", x"81", x"00", x"00", x"81", x"00", 
x"66", x"66", x"66", x"00", x"00", x"00", x"00", x"00", 
x"66", x"66", x"FF", x"66", x"FF", x"66", x"66", x"00", 
x"81", x"C7", x"60", x"C3", x"06", x"E3", x"81", x"00", 
x"64", x"66", x"03", x"81", x"C0", x"66", x"26", x"00", 
x"C3", x"66", x"C3", x"C1", x"6E", x"66", x"CF", x"00", 
x"06", x"03", x"81", x"00", x"00", x"00", x"00", x"00", 
x"03", x"81", x"C0", x"C0", x"C0", x"81", x"03", x"00", 
x"C0", x"81", x"03", x"03", x"03", x"81", x"C0", x"00", 
x"00", x"66", x"C3", x"FF", x"C3", x"66", x"00", x"00", 
x"00", x"81", x"81", x"E7", x"81", x"81", x"00", x"00", 
x"00", x"00", x"00", x"00", x"00", x"81", x"81", x"C0", 
x"00", x"00", x"00", x"E7", x"00", x"00", x"00", x"00", 
x"00", x"00", x"00", x"00", x"00", x"81", x"81", x"00", 
x"00", x"0C", x"06", x"03", x"81", x"C0", x"60", x"00", 
x"C3", x"66", x"67", x"E6", x"66", x"66", x"C3", x"00", 
x"81", x"81", x"C1", x"81", x"81", x"81", x"E7", x"00", 
x"C3", x"66", x"06", x"03", x"C0", x"60", x"E7", x"00", 
x"C3", x"66", x"06", x"83", x"06", x"66", x"C3", x"00", 
x"06", x"07", x"87", x"66", x"EF", x"06", x"06", x"00", 
x"E7", x"60", x"E3", x"06", x"06", x"66", x"C3", x"00", 
x"C3", x"66", x"60", x"E3", x"66", x"66", x"C3", x"00", 
x"E7", x"66", x"03", x"81", x"81", x"81", x"81", x"00", 
x"C3", x"66", x"66", x"C3", x"66", x"66", x"C3", x"00", 
x"C3", x"66", x"66", x"C7", x"06", x"66", x"C3", x"00", 
x"00", x"00", x"81", x"00", x"00", x"81", x"00", x"00", 
x"00", x"00", x"81", x"00", x"00", x"81", x"81", x"C0", 
x"07", x"81", x"C0", x"60", x"C0", x"81", x"07", x"00", 
x"00", x"00", x"E7", x"00", x"E7", x"00", x"00", x"00", 
x"E0", x"81", x"03", x"06", x"03", x"81", x"E0", x"00", 
x"C3", x"66", x"06", x"03", x"81", x"00", x"81", x"00", 
x"00", x"00", x"00", x"FF", x"FF", x"00", x"00", x"00", 
x"01", x"83", x"C7", x"EF", x"EF", x"83", x"C7", x"00", 
x"81", x"81", x"81", x"81", x"81", x"81", x"81", x"81", 
x"00", x"00", x"00", x"FF", x"FF", x"00", x"00", x"00", 
x"00", x"00", x"FF", x"FF", x"00", x"00", x"00", x"00", 
x"00", x"FF", x"FF", x"00", x"00", x"00", x"00", x"00", 
x"00", x"00", x"00", x"00", x"FF", x"FF", x"00", x"00", 
x"C0", x"C0", x"C0", x"C0", x"C0", x"C0", x"C0", x"C0", 
x"03", x"03", x"03", x"03", x"03", x"03", x"03", x"03", 
x"00", x"00", x"00", x"70", x"F0", x"C1", x"81", x"81", 
x"81", x"81", x"83", x"0F", x"0E", x"00", x"00", x"00", 
x"81", x"81", x"C1", x"F0", x"70", x"00", x"00", x"00", 
x"30", x"30", x"30", x"30", x"30", x"30", x"FF", x"FF", 
x"30", x"70", x"E0", x"C1", x"83", x"07", x"0E", x"0C", 
x"0C", x"0E", x"07", x"83", x"C1", x"E0", x"70", x"30", 
x"FF", x"FF", x"30", x"30", x"30", x"30", x"30", x"30", 
x"FF", x"FF", x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", 
x"00", x"C3", x"E7", x"E7", x"E7", x"E7", x"C3", x"00", 
x"00", x"00", x"00", x"00", x"00", x"FF", x"FF", x"00", 
x"C6", x"EF", x"EF", x"EF", x"C7", x"83", x"01", x"00", 
x"60", x"60", x"60", x"60", x"60", x"60", x"60", x"60", 
x"00", x"00", x"00", x"0E", x"0F", x"83", x"81", x"81", 
x"3C", x"7E", x"E7", x"C3", x"C3", x"E7", x"7E", x"3C", 
x"00", x"C3", x"E7", x"66", x"66", x"E7", x"C3", x"00", 
x"81", x"81", x"66", x"66", x"81", x"81", x"C3", x"00", 
x"06", x"06", x"06", x"06", x"06", x"06", x"06", x"06", 
x"01", x"83", x"C7", x"EF", x"C7", x"83", x"01", x"00", 
x"81", x"81", x"81", x"FF", x"FF", x"81", x"81", x"81", 
x"30", x"30", x"C0", x"C0", x"30", x"30", x"C0", x"C0", 
x"81", x"81", x"81", x"81", x"81", x"81", x"81", x"81", 
x"00", x"00", x"0C", x"C7", x"E6", x"C6", x"C6", x"00", 
x"FF", x"EF", x"CF", x"8F", x"0F", x"0E", x"0C", x"08", 
x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"00", 
x"F0", x"F0", x"F0", x"F0", x"F0", x"F0", x"F0", x"F0", 
x"00", x"00", x"00", x"00", x"FF", x"FF", x"FF", x"FF", 
x"FF", x"00", x"00", x"00", x"00", x"00", x"00", x"00", 
x"00", x"00", x"00", x"00", x"00", x"00", x"00", x"FF", 
x"30", x"30", x"30", x"30", x"30", x"30", x"30", x"30", 
x"33", x"33", x"CC", x"CC", x"33", x"33", x"CC", x"CC", 
x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", 
x"00", x"00", x"00", x"00", x"33", x"33", x"CC", x"CC", 
x"FF", x"F7", x"F3", x"F1", x"F0", x"70", x"30", x"10", 
x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", 
x"81", x"81", x"81", x"8F", x"8F", x"81", x"81", x"81", 
x"00", x"00", x"00", x"00", x"0F", x"0F", x"0F", x"0F", 
x"81", x"81", x"81", x"8F", x"8F", x"00", x"00", x"00", 
x"00", x"00", x"00", x"F1", x"F1", x"81", x"81", x"81", 
x"00", x"00", x"00", x"00", x"00", x"00", x"FF", x"FF", 
x"00", x"00", x"00", x"8F", x"8F", x"81", x"81", x"81", 
x"81", x"81", x"81", x"FF", x"FF", x"00", x"00", x"00", 
x"00", x"00", x"00", x"FF", x"FF", x"81", x"81", x"81", 
x"81", x"81", x"81", x"F1", x"F1", x"81", x"81", x"81", 
x"30", x"30", x"30", x"30", x"30", x"30", x"30", x"30", 
x"70", x"70", x"70", x"70", x"70", x"70", x"70", x"70", 
x"0E", x"0E", x"0E", x"0E", x"0E", x"0E", x"0E", x"0E", 
x"FF", x"FF", x"00", x"00", x"00", x"00", x"00", x"00", 
x"FF", x"FF", x"FF", x"00", x"00", x"00", x"00", x"00", 
x"00", x"00", x"00", x"00", x"00", x"FF", x"FF", x"FF", 
x"0C", x"0C", x"0C", x"0C", x"0C", x"0C", x"FF", x"FF", 
x"00", x"00", x"00", x"00", x"F0", x"F0", x"F0", x"F0", 
x"0F", x"0F", x"0F", x"0F", x"00", x"00", x"00", x"00", 
x"81", x"81", x"81", x"F1", x"F1", x"00", x"00", x"00", 
x"F0", x"F0", x"F0", x"F0", x"00", x"00", x"00", x"00", 
x"F0", x"F0", x"F0", x"F0", x"0F", x"0F", x"0F", x"0F");


begin

process
begin
  wait until rising_edge(clk25);
    q_a <= rom((to_integer(unsigned(addr_a))));
end process;
end architecture RTL;