library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity vga_text is
port(
  clock : in std_logic;
  
  hsync : out std_logic;
  vsync : out std_logic;
  red   : OUT STD_LOGIC_VECTOR(3 downto 0);
  green : OUT STD_LOGIC_VECTOR(3 downto 0);
  blue  : OUT STD_LOGIC_VECTOR(3 downto 0)
  ); 
end vga_text;

architecture behavioral of vga_text is

signal offs     : std_logic_vector (6 downto 0);
signal counterx : std_logic_vector (9 downto 0);
signal countery : std_logic_vector (9 downto 0);
signal basis    : std_logic_vector (11 downto 0);

signal counterxmaxed : std_logic;
signal counterymaxed : std_logic;
signal h_enable      : std_logic;
signal v_enable      : std_logic;
signal vid_enable    : std_logic;
signal pixel         : std_logic;
signal clk25         : std_logic;

signal charlin : std_logic_vector (11 downto 0);
signal dat     : std_logic_vector (7 downto 0);

signal char    : std_logic_vector (7 downto 0);
signal dat_w   : std_logic_vector (7 downto 0);
signal zpos    : std_logic_vector (11 downto 0);
signal wr_addr : std_logic_vector (11 downto 0);
signal we      : std_logic;

component ram port(
  clk25   : in  std_logic;
  we      : in  std_logic;
  wr_addr : in  std_logic_vector (11 downto 0);
  rd_addr : in  std_logic_vector (11 downto 0);
  d       : in std_logic_vector  (7 downto 0);
  q       : out std_logic_vector (7 downto 0)
  );
end component;

component rom port(
  clk25  : in  std_logic;
  addr_a : in  std_logic_vector (11 downto 0);
  q_a    : out  std_logic_vector (7 downto 0)
  );
end component;

begin
io1 : ram  port map(
 clk25   => clk25,
 we      => we,
 rd_addr => zpos,
 wr_addr => wr_addr,
 q       => char,
 d       => dat_w
);

io2 : rom  port map(
  clk25  => clk25,
  addr_a => charlin,
  q_a    => dat
);

clk25 <= not clk25 when rising_edge(clock);

process
begin
  wait until rising_edge(clk25);
    if counterxmaxed ='1' then
      counterx <= "0000000000";
    else
      counterx <= counterx + "0000000001"; 
      if dat(to_integer(unsigned(counterx(2 downto 0)))) = '0' then
        pixel<='0';
      else
        pixel<='1';
      end if;       
    end if;
    
    if counterxmaxed ='1' then
      if counterymaxed ='1' then 
        countery <= "0000000000";
      else  
        countery<= countery + "0000000001";      
      end if;  
    end if ; 
    
    if counterx (2 downto 0)="000" then
      if counterx ="0000000000" and  countery ="0000000000" then
        basis <= "000000000000";
      elsif counterx ="0000000000" and countery(3 downto 0) ="0000" then 
        basis<= basis + "000001010000"; 
      end if;        
    end if;    
  
    offs <= counterx(9 downto 3);
    zpos <= basis + offs;
end process;

process
begin
  wait until rising_edge(clk25);
    if vid_enable ='1' and pixel='1' then
      red  <="1111";
      green<="1111";
      blue <="1111";
    else
      red  <="0000";
      green<="0000";
      blue <="0000";    
    end if;
end process;

counterxmaxed <='1' when  counterx = "1100100000" else '0';
counterymaxed <='1' when  countery = "1000001101" else '0';

hsync <='1' when  counterx < "1010001111" or counterx > "1011101111" else '0';
vsync <='1' when  countery < "0111101001" or countery > "0111101011" else '0';

h_enable   <= '1' when  counterx > "0000000100" and counterx < "1010000000" else '0';
v_enable   <= '1' when  countery < "0111100000" else '0'; 
vid_enable <= '1' when h_enable = '1' and v_enable = '1' else '0';

charlin <= std_logic_vector(to_unsigned(to_integer(unsigned(char)) + to_integer(unsigned(countery(3 downto 1))),12));

end behavioral;