;////////////////////////////// breakpoint sample routine /////////////////////////////////
;(c) B.Nollmeyer / this sample belongs to the 4Flash development tool!
;this sample shows how to make use of the breakpoint feature of the AT89S8252 dev. tool.
;after loading defined values into seperate memory location a breakpoint will be invoked.
;////////////////////// Processor definition & Signal declaration /////////////////////////

				$NOMOD51
				$INCLUDE (89S8252.MCU)

b_addrr				equ 20h				;bitaddressable area 16 byte
breakpoint			equ 1000H			;breakpoint address

;### its important to set cseg @ 8000H, this is the start address of the emulation RAM

                       		cseg at 8000H             	;cpu reset
                       		ljmp start                	;jmp above interrupts

;//////////////////////////////////// breakpoint sample ///////////////////////////////////

				cseg at 8100h             	;
start:				mov sp,#60h			;stackpointer set to 60h
				call clear_iram			;clear lower internal ram
				call clear_u_iram		;clear upper internal ram

;///////////////////// load some testvalues to the internal ram space /////////////////////
	
;### 16 bytes bitaddressable! usefull as flag memory (128 bit)

				setb b_addrr.5			;bitaddressable area 20H - 2Fh

;### lower internal ram, 30H - 77H, 78H - 7FH reserved for internal use
;### direct accessable

				mov 30H,#30h			;start of internal ram is here
				mov 40h,#40h			;write some testvalues to lower
				mov 50h,#50h			;internal ram 30h - 7Fh
;### dont use 60h		mov 60h,#60h			;here we moved the stackpointer
				mov 70h,#70h			;
				mov 71h,#71h			;
				mov 72h,#72h			;
				mov 73h,#73h			;
				mov 74h,#74h			;
				mov 75h,#75h			;
				mov 76h,#76h			;
				mov 77h,#77h			;

;### upper internal ram, 80H - FFH, location is parallel to the special function register
;### indirect accessable

				mov r0,#80h			;write some testvalues to
				mov a,#80h			;upper internal ram.
				mov @r0,a			;access is only possible
				mov r0,#90h			;by indirect addressing.
				mov a,#90h			;keep in mind the upper
				mov @r0,a			;internal ram is parallel
				mov r0,#0A0h			;to the sfr map.
				mov a,#0A0h			;80h - FFh
				mov @r0,a			;
				mov r0,#0B0h			;
				mov a,#0B0h			;
				mov @r0,a			;
				mov r0,#0C0h			;
				mov a,#0C0h			;
				mov @r0,a			;
				mov r0,#0D0h			;
				mov a,#0D0h			;
				mov @r0,a			;
				mov r0,#0E0h			;
				mov a,#0E0h			;
				mov @r0,a			;
				mov r0,#0F0h			;
				mov a,#0F0h			;
				mov @r0,a			;

;//////////////////////////// load @ rb0 - rb3 some testvalues ////////////////////////////
		
;### rb0 - rb3 are part of the lower internal ram
clr rs0	;### register bank 0
clr rs1
				mov r0,#01h			;test value rb0
				mov r1,#02h			;
				mov r2,#03h			;
				mov r3,#04h			;
				mov r4,#05h			;
				mov r5,#06h			;
				mov r6,#07h			;
				mov r7,#08h			;

clr rs1	;### register bank 1
setb rs0
				mov r0,#09h			;test value rb1
				mov r1,#10h			;
				mov r2,#11h			;
				mov r3,#12h			;
				mov r4,#13h			;
				mov r5,#14h			;
				mov r6,#15h			;
				mov r7,#16h			;

setb rs1 ;### register bank 2
clr rs0
				mov r0,#17h			;test value rb2
				mov r1,#18h			;
				mov r2,#19h			;
				mov r3,#20h			;
				mov r4,#21h			;
				mov r5,#22h			;
				mov r6,#23h			;
				mov r7,#24h			;

setb rs0 ;### register bank 3
setb rs1
				mov r0,#25h			;test value rb3
				mov r1,#26h			;
				mov r2,#27h			;
				mov r3,#28h			;
				mov r4,#29h			;
				mov r5,#30h			;
				mov r6,#31h			;
				mov r7,#32h			;	

;/////////////////// load some testvalues to sperate register @ the cpu ///////////////////
			
				mov a,#0AAh			;test value for accu
				mov b,#0BBh			;test value for b
				mov dptr,#0CCDDH		;test value for dptr
				setb c				;test value for PSW

;### if you want to write some testvalues to the timer, keep in mind,
;### one timer is reserved for the emulator itself!

;				mov tl0,#0ABh			;timer0 test value
;				mov th0,#0CDh			;
;				mov tl1,#0ABh			;timer1 test value
;				mov th1,#0CDh			;
;				mov tl2,#0ABh			;timer2 test value
;				mov th2,#0CDh			;
		
				ljmp breakpoint			;invoke breakpoint

;/////////////////// subroutines to clear the lower, upper internal ram ///////////////////

clear_iram:			clr a				;lower internal ram till rb3
				mov r0,#5Fh			;clear memory starts at 5Fh
				mov r1,#40h			;clear 64 memory cells
clear_ram:			mov @r0,a			;internal lower ram will
				dec r0				;be cleared
				djnz r1,clear_ram		;
				ret				;

clear_u_iram:			clr a				;upper internal ram
				mov r0,#0FFh			;clear memory starts at FFh
				mov r1,#80h			;clear 128 memory cells
clear_u_ram:			mov @r0,a			;internal ram will
				dec r0				;be cleared from
				djnz r1,clear_ram		;80h to FFh
				ret				;
		
end