#include "Timer.h"


unsigned int GlobalTime = 0; // global timer counter (counts in ticks)
                             // One tick is the smallest countable unit

// Use this function to increase global timer (e.g. in timer interrupt)
inline void TimerIntReload(){   // inline is a compiler optimisation to suppress a real function call. It doesn't change the functionality!

	GlobalTime++;  // Increase global time
}

// returns the current value of the global timer
unsigned int StartTimer()
{
	return GlobalTime;
}

// returns the difference between start time and the current time value
unsigned int ElapsedTime(unsigned int StartTime)
{
	if (StartTime > GlobalTime)  // Test if global time had an overflow
	        // overflow occured!
		return (0xFFFF - (StartTime - GlobalTime)); // Subtract the difference between start and current value from the maxium possibe value to get the elapsed time.
	else
		return (GlobalTime - StartTime); // Subtract the the start value from the current value to get the elapsed time.
}

