/*********************************************

Project : Funk-Relaisesteuerung

Author  : M. Gschwandtner, Sohn von Hubert (OE5GHN)
    */
    
    
    // #define DEBUG
    
    #ifdef _CHIP_AT90S4433_
    /*  Chip type           : AT90S4433
    *********************************************/
    #include <90s4433.h>
    #define OCIE1A 6
    #define SE 5
    #define ACD 7
    #define TOIE0 1
    #define RXCIE 7
    #define RXEN 4
    #define TXEN 3
    #endif
    
    #ifdef _CHIP_AT90S8515_
    /*  Chip type           : AT90S8515
    *********************************************/
    #include <90s8515.h>
    #define OCIE1A 6
    #define SE 5
    #define ACD 7
    #define TOIE0 1
    #define RXCIE 7
    #define RXEN 4
    #define TXEN 3
    #endif
    
    
    #ifdef _CHIP_ATMEGA8_
    /*  Chip type           : AT90S4433
    *********************************************/
    #include <mega8.h>
    #define SE 5
    #define OCIE1A 4
    #define ACD 7
    #define TOIE0 0
    #define RXCIE 7
    #define RXEN 4
    #define TXEN 3
    #endif
    
    #include "timer.h"
    
    #include <stdio.h>
    /*********************************************
    Clock frequency     : 3,000000 MHz ( 4 MHz )
        Memory model        : Tiny
        Internal SRAM size  : 128
        External SRAM size  : 0
        Data Stack size     : 32
        
        Version:    */
        flash char VERSION[]="VERSION 2.3.1\0x00d";

/*********************************************
History:
0.1.0: Start des Projekt
1.0.0: erste funktionstchtige Version
1.1.0: Die Jumper wurden durch eine flexiblere Softwarelsung ersetzt. Hierzu hat eine Konfiguration ber die Serielle Schnittstelle einzug gehalten.
1.2.0: Die vollstndig mengefhrte Konfiguration wurde aus Speicherplatzgrnden durch eine kleinere Version ersetzt.
1.2.2: Viele Fehler behoben; Diese Version wurde an das Relais Linz/Froschberg ausgeliefert.
1.2.3: Der Aktive-Pegel der Ein-/Ausgabepins kann ber den EEProm konfiguriert werden. Reset ber Terminal mglich.
1.3.0: Eine Squelchsteuerung wurde hinzugefgt. Dies soll bei Strungen die den Squelch kurz ffnen bessere Ergebnisse liefern.
1.3.1: RS232 Men berarbeitet (Kompakter Code).
1.4.0: 1750 Hz-Ton-Konstolle--> Zustzliches Bit im Port-Level-Register; SquelchDelay ist im Falle der Verwendung des 1750Hz-Ton deaktiviert.
1.4.1: Problem mit Ansagetext-unterbrechung
1.5.0: RBZeitBisPTTaus von char auf int; Bei Auslsen nach Zeit (PTT nicht aktiv) wird kein RogerBeep ausgegeben und es findet keine PTT-Verzgerung statt.
2.0.0: Auf AT90S4433 portiert; Fehler in der Ereignisszhlung behoben; DTMF hinzugefgt
2.0.1: 2313: Keine nderungen
4433: Bakenkennung abschaltbar, Sprachkennung (Ansage) abschaltbar,
2.1.0: 4433: CW-Ausage hinzugefgt; EEPROM-Code gendert
2.1.1: Clock auch an 4 MHz angepasst
2.2.0: Clock kann nun im eeProm eingestellt werden. Baudrate- und Timer-Werte werden daraus errechnet. Standardmssig sind 3 MHz eingestellt.
Standardwerte der Parameter PortAktivLevel, Feature Control, Startverzgerung gendert.
2.2.1: Clock-Berechungsberlauf bei Frequenzen ber 5.1 MHz behoben, Krachen in CW/RogerBeep behoben.
2.2.2: Fehler 'CW luft nicht durch, wenn Squelch aktiv wird' behoben.
Fehler 'Bei Timeout aktiv, wird nach kurzem Squelch abfall und reaktivierung die Ansage zwei mal ausgelst und PTT-Verzgerungszeit ist das Relais blockiert. DTMF Reset aber mglich."
Fehler 'Startverzgerung: Die Zeiten bei mehrmaligem kurzen Squelch-aktivieren addieren sich und ffen das Relais.'
Fehler 'Wenn Reset und Squelch offen dann findet keine CW-Ausgabe statt. (Fr DTMF problematisch)'
Kennung bei PTT abfall
2.2.3: Fehler: CW-Zeichen 'p' falsch
2.3.0: Mega8-Version 
2.3.1: Morsezeichen "/" eingefgt
/*********************************************/

#define Squelch_Port 	PIND
#define Squelch_Pin 	4


// Fr Jumpermige Rogerbeep- und Sperrsteuerung:
// Im Quell mssen dazu mehrere Zeile auskommentiert werden  (Markiert)
/*
#define RogerBeepEinschalten_Port 	PIND
#define RogerBeepEinschalten_Pin 	4

#define MinutenspeereEinschalten_Port 	PIND
#define MinutenspeereEinschalten_Pin 	5
*/

#define RogerBeep_Port  	PORTB
#define RogerBeep_Pin  		2

#define CW_Port  	PORTC
#define CW_Pin  		5

#define Ansage_Port  	PORTB
#define Ansage_Pin  	1


#define PTT_Port  	PORTB
#define PTT_Pin  	0

#define Squelch1750Hz_Port  	PIND
#define Squelch1750Hz_Pin  	6

// Output-Pins (nur 4433 mit DTMF)

#define OUTPORT PORTB
#define OUTPINPORT PINB

#define OUTPORTMOD << 3;

//DTMF (nur 4433)

#define DTMFVALID (PINC.4)
#define DTMFPIN (PINC&0x0f)


eeprom unsigned int  TimeoutSperre 		= 6000;	// Zeit bis PTT abfllt, obwohl der Squelch aktiv ist. ; 0=Deaktiviert
eeprom unsigned int  Ansagewiederholugszeit 	= 7200;	// Leerlaufzeit bis der Ansagetext wiederholt wird

eeprom unsigned int  AnsageSteuerZeit   = 20;		// Gibt an wielange der Ansagesteuerpin auf aktiv gesetzt ist
eeprom unsigned int  AnsagezeitbisPTTaus= 70;		// Gesamtzeit der Ansage bis PTT aus
eeprom unsigned char ZeitBisAnsage	= 2;    	// Zeit bis zur Ausgabe des Ansagetext beginnt

eeprom unsigned char RufeBisAnsage	= 10;       	// Anzahl der Sqelchaktivierungen bis zum Wiederholen der Ansgage

eeprom unsigned char ZeitBisRogerBeep	= 2;    	// Zeit vom Abfall des Squelch's bis zur Ausgabe des RogerBeep (sofern aktieviert)
eeprom unsigned int  RBZeitBisPTTaus	= 35;  		// Zeit vom Abfall des Squelch's bis zum Abfall des PTT

eeprom unsigned char RogerBeepHalbePeriode = 255-24; 	// Dauer einer Halben Periode des RogerBeep
eeprom unsigned char RogerBeepControl	   = 3;  	// RogerBeep Controlle (Prescaler); 0=Deaktivierter Rogerbeep
eeprom unsigned int  RogerBeepDauer	   = 400;	// Anzahl der Halbperioden

eeprom unsigned char PortAktivLevel	   =0x07;//0b00001111;
/* Aktive-Pegel der Ein-/Ausgabepins (RESET nach nderung notwendig!):
Bit 0: Squelch (Aktiv)
    Bit 1: Ansage (Aktiv)
        Bit 2: PTT (Aktiv)
            Bit 3: 1750 Hz-Ton (Aktiv) */
            
            
            eeprom unsigned char SquelchStartDelay	= 2;		// Minimale Zeit die der Squelch aktiv sein mu, damit der PTT akiviert wird (nur beim ersten Mal, dann normales Verhalten bis SquelchOffenZeit abgelaufen ist); Bei Null ist die Funktion deaktiert; Aus Kompatiblilittsgrngen ist diese Funktion standardmssig deaktiviert.
eeprom unsigned int  SquelchOffenZeit	= 600;		// Startet nach der Squelch-Startverzgerung und wird mit berschreitung der Squelch-Mini-Zeit zurckgesetzt. Innerhalb der Squelch-Offen-Zeit wird die PTT ohne Verzgerung mit Squelch aktiviert.
eeprom unsigned char SquelchMin         = 50;		// Zeit die ein Squelch offen sein mu, damit die SquelchOffenZeit verlngert wird.
eeprom unsigned char FeatureControl     = 0x1e;   /* Aktiviert Feature's : Bit 0: (De-)Aktiviert den 1750Hz Ton
Bit 1: Sprachkennung (Ansage) Nur 4433
Bit 2: Bakenkennung           Nur 4433
Bit 3: DTMF                   Nur 4433
Bit 4: Morsekennung           Nur 4433
Bit 5: Ansage bei PTT-Abfall  Nur 4433 */

// Nur 4433:
eeprom unsigned char DTMFKey[4]={'2','5','8','0'};      // DTMF-Key- Wenn 0, dann ist DTMF deaktiviert.
eeprom unsigned char DTMFTimeout=20;			// Timeout zwischen 2 DTMF-Tnen
eeprom unsigned int  DTMFIgnoreTime=600;		// Zeit die ein DTMF-Ruf ignoriert wird, nach einer Falscheingabe
eeprom unsigned char DTMFOutputPortValue=0;		// Muster das am Outputport nach einem Reset angelegt wird. (Wird bei setzen des Port ber DTMF berschriben)

eeprom unsigned char Morsekennung[9]        = "OE5GHN"; // Morsekennung der Station
eeprom unsigned char ZeitBisMorsekennung    = 2;        // Zeit bis die Ausgabe der Morsekennung beginnt.
eeprom unsigned int  MorseZeitbisPTTaus     = 150;       // Zeit die gewartet wird, nach dem die Morsekennung abgesetzt wird und der Rogerbeep aktiviert wird / PTT abfllt.
eeprom unsigned char MorsePunktHalbePeriode = 255-24; 	// Dauer einer Halben Periode des Morse-Punkt
eeprom unsigned char MorsePunktControl	    = 3;  	// Morse Controlle (Prescaler); 0=Deaktivierter Morsekennung
eeprom unsigned int  MorsePunktDauer	    = 150;      // Anzahl der Halbperioden des Morse-Punkt

eeprom unsigned long int Clock = 3e6;		// in Hz


flash unsigned char Morsezeichen[38][2]={{0b11111000,5}, // '0'
    {0b01111000,5}, // '1'
    {0b00111000,5}, // '2'
    {0b00011000,5}, // '3'
    {0b00001000,5}, // '4'
    {0b00000000,5}, // '5'
    {0b10000000,5}, // '6'
    {0b11000000,5}, // '7'
    {0b11100000,5}, // '8'
    {0b11110000,5}, // '9'
    {0b01000000,2}, // 'a'
    {0b10000000,4}, // 'b'
    {0b10100000,4}, // 'c'
    {0b10000000,3}, // 'd'
    {0b00000000,1}, // 'e'
    {0b00100000,4}, // 'f'
    {0b11000000,3}, // 'g'
    {0b00000000,4}, // 'h'
    {0b00000000,2}, // 'i'
    {0b01110000,4}, // 'j'
    {0b10100000,3}, // 'k'
    {0b01000000,4}, // 'l'
    {0b11000000,2}, // 'm'
    {0b10000000,2}, // 'n'
    {0b11100000,3}, // 'o'
    {0b01100000,4}, // 'p'
    {0b11010000,4}, // 'q'
    {0b01000000,3}, // 'r'
    {0b00000000,3}, // 's'
    {0b10000000,1}, // 't'
    {0b00100000,3}, // 'u'
    {0b00010000,4}, // 'v'
    {0b01100000,3}, // 'w'
    {0b10010000,4}, // 'x'
    {0b10110000,4}, // 'y'
    {0b11000000,4}, // 'z'
    {0b00000000,8}, // Irrung
    {0b10010000,5} // '/'
};


char buffer[20];
bit buffercomplete=0;
char bufferlen=0;

unsigned int Counter		=0;  			// Zhler der Timer1-Durchlufe
unsigned int AnsageCounter	=0;			// Zeit zwischen 2 Ansagen

bit Ruf			=0;			// Kennweichnet ob ein Ruf aktiv ist oder war
bit TimeoutSperreAktiv	=0;   			// Kennzeichnet ob der PTT Aufgund von Zeitberschreitung abgefallen ist
bit AnsageLaeuft	=0;			// Kennzeichnet ob eine Ansage gerade luft.
bit RogerBeepLaeuft	=0;                     // Kennzeichnet ob ein Rogerbeep gerade luft.
bit PTTAuto		=0;			// Kennzeichnet ob Automatikmodus aktiviert ist.
bit PTTState		=0;                     // Gibt dem PPT-Status fr den Manuellen Modus an
bit Squelchzeit_checked =0;			// Kennzeichnet ob die Squelchzeit bereits berprft wurde.
bit SquelchAktivLevel;
bit AnsageAktivLevel;
bit PTTAktivLevel;
bit Squelch1750HzAktivLevel;
bit PTTOffenBeiAnsagestart;
bit Squelch1750HzAktiv;


unsigned char  SquelchDelay =0;
unsigned int   SquelchOffen;

unsigned char RufCounter=0;                     // Anzahl der bisherigen Squelchaktivierung

// DTMF
bit DTMFZeichenGueltig=0;
int DTMFTimer;
char DTMFReceiveBuffer[9];// Buffer fr "*#" + 4 Zeichen PWD + 2 Zeichen Befehl+EOS
char DTMFReceiveCounter=0;// Anzahl der Empfangenen Zeichen
bit DTMFBackPTTAuto;
bit DTMFBackPTTState;
bit DTMFIgnore;
unsigned char DTMF2ASCII(unsigned char DTMFCode);

// Morse
bit MorsekennungLaeuft=0;
bit MorsekennungSymbolPause; //  Pause zwischen zwei Morse-Symbole (. | -)
bit MorsekennungCharPause;   //  Pause zwischen zwei Character

unsigned char MorsekennungSymCounter=0;
unsigned char MorsekennungCodierung;
unsigned char MorsekennungLength=0;

// Feature
bit BakenkennungAktiv; // Aktivierung des Feature Bakenkennung

bit SprachkennungAktiv;

bit DTMFAktiv;

bit MorsekennungAktiv;

unsigned int PTTAutoTime=0;

void RogerBeep();
void Ansage();
void AusgabeMorsekennung();

void RogerBeep(){
    if (RogerBeepLaeuft==0){
        // Ausgabe des RogerBeep wird aktivert
        RogerBeepLaeuft=1;
        Counter=0;
    }
    else{
        // Ausgabe luft ...
        if (Counter > RBZeitBisPTTaus){
            // RogerBeep fertig ausgegeben und gewartet -> Deaktivieren des PTT
            // if (Squelch_Port.Squelch_Pin != SquelchAktiv){  // Falls nach dem Rogerbeep wieder ein Squelch anliegt fllt der PTT nicht ab!
            
            
            
            if (FeatureControl&0b0100000){  // Bei Ansage bei PTT aus wird die PTT nicht abgeschalten and die Ansage / CW aktiviert wird.
                PTTOffenBeiAnsagestart=0;
                Ansage();
                AusgabeMorsekennung();
            }
            else{
                PTT_Port.PTT_Pin=!PTTAktivLevel;
                #ifdef DEBUG
                putchar('r');
                putchar('c');
                #endif
            }
            
            
            
            RufCounter++;
            // }
            RogerBeepLaeuft=0;
            Ruf=0;
            Counter=0;
            
            
        }
        else if (Counter == ZeitBisRogerBeep){
            //  if (RogerBeepEinschalten_Port.RogerBeepEinschalten_Pin==1){ // Fr Jumper-Version
            //  RogerBeep wird gestartet, sofern nicht durch Jumper deaktiviert
            TCNT0=RogerBeepHalbePeriode;
            TCCR0=RogerBeepControl;
            //  }
        }
        else   {
            // PTT aktivieren (zur Sicherheit)
            PTT_Port.PTT_Pin=PTTAktivLevel;
        }
    }
}

unsigned char ASCII2Morse(unsigned char character) {
    if ((character>='0') &&(character<='9')){
        return character - '0';
    }
    else if ((character>='a') &&(character<='z')){
        return character - 'a'+10;
    }
    else if ((character>='A') &&(character<='Z')){
        return character - 'A'+10;
    }  
    else if ((character=='/')){
        return 37;
    }
    else{
        return 36; // Irrung
    }
}

void AusgabeMorsekennung(){
    
    static unsigned int MorseTimer;
    
    if (MorsekennungLaeuft==0){
        // Ausgabe der Morsekennung wird aktiviert
        if (MorsekennungAktiv){
            MorsekennungLaeuft=1;
            MorseTimer = StartTimer();
            
            RogerBeepLaeuft=0;
        }
    }
    else{
        // Ausgabe der Morsekennung luft ...
        if ((ElapsedTime(MorseTimer) > MorseZeitbisPTTaus)){
            // Ansage Fertig und Zeitspanne gewartet -> PTT abfallen lassen
            
            
            MorsekennungLaeuft=0;
            //    TimeoutSperreAktiv=0;
            TCNT0=MorsePunktHalbePeriode;   // Timer ausschalten
            TCCR0=0;
            if (PTTOffenBeiAnsagestart==0){
                // Bei Aufruf nach Zeit kommt kein Roger-Beep und die PTT fllt sofort ab
                
                PTT_Port.PTT_Pin=!PTTAktivLevel;
                #ifdef DEBUG
                putchar('m');
                putchar('c');
                #endif
                RufCounter=1;
            }
            else{
                RufCounter=0;
                RogerBeep(); // Nach der Morsekennung wird ein Rogerbeep ausgelt
            }
            AnsageCounter=0;
        }
        else if (ElapsedTime(MorseTimer)> ZeitBisMorsekennung){
            // Nach (kurzer) Wartezeit wird die Morseausgabe aktiviert
            
            
            if (MorsekennungCharPause&&!MorsekennungLength){
                if ((MorsekennungSymCounter>=9)|| !Morsekennung[MorsekennungSymCounter]){
                    TCNT0=MorsePunktHalbePeriode;   // Timer ausschalten       
                    TCCR0=0;
                }
                else{
                    MorsekennungCodierung=Morsezeichen[ASCII2Morse(Morsekennung[MorsekennungSymCounter])][0];
                    MorsekennungLength=Morsezeichen[ASCII2Morse(Morsekennung[MorsekennungSymCounter])][1];
                    MorsekennungSymCounter++;
                    
                    if (MorsekennungSymbolPause&&MorsekennungCharPause){
                        // Bereite erstes Zeichen fr Ausgabe vor
                        PTT_Port.PTT_Pin=PTTAktivLevel; // Zur Sicherheit
                        TCNT0=MorsePunktHalbePeriode;   // Starte Timer
                        TCCR0=MorsePunktControl;
                        MorsekennungSymbolPause=0;
                        MorsekennungCharPause=1;// Ist bereits gesetzt und bleibt es auch, damit zu beginn gleich ein neues Symbol geladen wird.
                    }
                }
            }
        }
        else{
            // PTT aktivieren (zur Sicherheit)
            MorsekennungSymbolPause=1;
            MorsekennungCharPause=1;
            MorsekennungSymCounter=0;
            MorsekennungLength=0;
            PTT_Port.PTT_Pin=PTTAktivLevel;
            TCNT0=MorsePunktHalbePeriode;   // Timer ausschalten
            TCCR0=0;
        }
    }
}



void Ansage(){
    if (AnsageLaeuft==0){
        // Ausgabe der Ansage wird aktiviert
        
        Counter=0;
        RogerBeepLaeuft=0;
        
        
        if (SprachkennungAktiv){
            
            
            AnsageLaeuft=1;
            
            
        }
        
    }
    else{
        // Ausgabe luft ...
        if ((Counter > AnsagezeitbisPTTaus)){
            // Ansage Fertig und Zeitspanne gewartet -> PTT abfallen lassen
            
            Ansage_Port.Ansage_Pin=!AnsageAktivLevel;
            AnsageLaeuft=0;
            //   TimeoutSperreAktiv=0;
            
            if (PTTOffenBeiAnsagestart==0){
                // Bei Aufruf nach Zeit kommt kein Roger-Beep und die PTT fllt sofort ab
                
                PTT_Port.PTT_Pin=!PTTAktivLevel;
                RufCounter=1;
                #ifdef DEBUG
                putchar('a');
                putchar('c');
                #endif
            }
            else{
                RufCounter=0;
                RogerBeep(); // Nach der Ansage wird ein Rogerbeep ausgelt
            }
            AnsageCounter=0;
        }
        else if (Counter > (ZeitBisAnsage+AnsageSteuerZeit)){
            // Der Ansagetext lut weiter, aber der Aktivierungspin wird wieder zurckgesetzt
            Ansage_Port.Ansage_Pin=!AnsageAktivLevel;
        }
        else if (Counter > ZeitBisAnsage){
            // Nach kurzer Wartezeit wird die Ansagetext aktiviert
            Ansage_Port.Ansage_Pin=AnsageAktivLevel;
        }
        else   {
            // PTT aktivieren (zur Sicherheit)
            PTT_Port.PTT_Pin=PTTAktivLevel;
        }
    }
}


// Timer 1 output compare interrupt service routine
#if defined(_CHIP_AT90S8515_) || defined(_CHIP_ATMEGA8_)
interrupt [TIM1_COMPA] void timer1_comp_isr(void)
    #else
        interrupt [TIM1_COMP] void timer1_comp_isr(void)
            #endif
        {
            Counter++;                                  // Timer1-Durchlufezhler
            AnsageCounter++; 				// Zeit seit der letzten Ansage (in 100ms)
            
            TimerIntReload();
            
            if (AnsageLaeuft){
                // PTTOffenBeiAnsagestart=0;
                Ansage();
            }
            
            if (MorsekennungLaeuft){
                //   PTTOffenBeiAnsagestart=0;
                AusgabeMorsekennung();
            }
            
            if (RogerBeepLaeuft){
                RogerBeep();
            }
        }


interrupt [TIM0_OVF] void timer0_ovf_isr(void){
    static unsigned int Halbperioden=1;    	// 1 weil zu beginn einmal decrementiert wird und es sonst zu einem berlauf kommen wrde;
    // so wird gleich mal ein neuer Wert geladen;
    // 1 RogerBeep nach Reset finden jedoch nicht statt!
    
    Halbperioden--;    // Zhler fr die Halbperioden
    
    if (Halbperioden>0){
        // Die Zeit einer Halbperiode ist abgelaufen.
        if (!MorsekennungLaeuft){
            TCNT0=RogerBeepHalbePeriode; // Timer0 wird zurckgesetzt
            RogerBeep_Port.RogerBeep_Pin=~RogerBeep_Port.RogerBeep_Pin; // Halbperioden werden Modulo 2 gerechnet, so wird der Pin abwechselned gesetzt
        }
        else{
            TCNT0=MorsePunktHalbePeriode; // Timer0 wird zurckgesetzt
            if (MorsekennungCharPause||MorsekennungSymbolPause){
                //Pause
                //RogerBeep_Port.RogerBeep_Pin=0; // Ruhe
            }
            else{
                CW_Port.CW_Pin=~CW_Port.CW_Pin; // Halbperioden werden Modulo 2 gerechnet, so wird der Pin abwechselned gesetzt
            }
        }
    }
    else{
        if (!MorsekennungLaeuft){
            TCCR0=0x00;  // Timer0 wird deaktiviert
            Halbperioden=RogerBeepDauer;  // Zhler wird zurckgesetz
        }
        else{
            TCNT0=MorsePunktHalbePeriode; // Timer0 wird zurckgesetzt
            if (MorsekennungCharPause||MorsekennungSymbolPause){
                // Pause (Stille) ist abgelaufen, neues Zeichen wird versandt
                if (MorsekennungCodierung&0x80){
                    // -
                    Halbperioden=MorsePunktDauer*3;  // Zhler wird zurckgesetz
                    
                }
                else
                {
                    // .
                    Halbperioden=MorsePunktDauer;  // Zhler wird zurckgesetz
                    
                }
                MorsekennungCodierung=MorsekennungCodierung<<1;
                if (MorsekennungLength){ // sollte immer grer 0 sein...
                    
                    MorsekennungLength--;
                }
                MorsekennungCharPause=0;
                MorsekennungSymbolPause=0;
            }
            else{
                if (MorsekennungLength){
                    
                    // Pause fr die Lnge  von 1 Punkt (Pause zwischen 2 Symbolen)
                    Halbperioden=MorsePunktDauer;  // Zhler wird zurckgesetz
                    MorsekennungSymbolPause=1;
                }
                else
                {
                    // Pause fr die Lnge  von 3 Punkt (Pause zwischen 2 Charater)
                    Halbperioden=MorsePunktDauer*3;  // Zhler wird zurckgesetz
                    MorsekennungCharPause=1;
                }
            }
        }
    }
}

#if defined(_CHIP_ATMEGA8_)
interrupt [USART_RXC] void uart_rx_isr(void)
    #else
        interrupt [UART_RXC] void uart_rx_isr(void)
            #endif
        {
            buffer[bufferlen]=UDR;
            
            if (buffer[bufferlen]==0x0d){
                buffer[(unsigned char)(bufferlen+1)]='\0';
                buffercomplete=1;
            }
            if (bufferlen<20){
                bufferlen++;
            }
            else{
                bufferlen=0;
            }
            
        }
/*
void inttoascii(unsigned int src,char *dest){
register unsigned char nibble;
register unsigned char counter=4;

while (counter){
counter--;
nibble = (unsigned char) src &0x0f;

if (nibble > 0x9){
nibble += ('A'-10);
}
else{
nibble += '0';
}
dest[counter] = nibble;
src = src >> 4 ;
}
dest[4]=0;
}

unsigned int asciitoint(char * string){
register unsigned int sum=0;
register unsigned char character;
register unsigned char counter=0;

while (counter<4){

sum = sum << 4 ;
character=string[counter];
if (character > ('A' - 1)){
sum |= character- ('A' - 10);
}
else{
sum |= character - '0';
}
counter++;


}
return sum;
}
*/

void chartoascii(unsigned char src,char *dest){
    // Eine Low-Level-Version, da die CV-Lib's zu gro sind
    register unsigned char nibble;
    register unsigned char counter=2;
    
    while (counter){
        counter--;
        nibble=(unsigned char)src &0x0f;
        
        if (nibble>0x9){
            nibble+=('A'-10);
        }
        else{
            nibble+='0';
        }
        dest[counter]=    nibble;
        src=src>>4 ;
    }
    dest[4]=0;
    
}

unsigned char asciitochar(char * string){
    // Eine Low-Level-Version, da die CV-Lib's zu gro sind
    register unsigned char sum=0;
    register unsigned char character;
    register unsigned char counter=0;
    
    while (counter<2){
        
        sum = sum << 4 ;
        character=string[counter];
        if (character > ('A' - 1)){
            sum |= character- ('A' - 10);
        }
        else{
            sum |= character - '0';
        }
        counter++;
        
        
    }
    return sum;
}

void WriteOK(){
    /* buffer[0]='O';
    buffer[1]='K';
    buffer[2]=0x0d;
    buffer[3]='\0';  */
    putsf("OK\x00d");
}
/*
char strequal(char *str1, char flash *str2){
unsigned char counter=0;
char equal=2;
while (equal==2){
if (str1[counter]!=0){
if (str2[counter]!=0){
if (str1[counter]==str2[counter]){
counter++;
}
else{
equal=0;
}
}
else{
equal--;
}
}
else{
equal=0;
}


}
return equal;
}
*/


char ReadEEProm(unsigned int Address){
    return *( char eeprom * )Address;
}

void WriteEEProm(unsigned int Address,unsigned char Data){
    *( char eeprom * )Address=Data;
}


/*
void writeERROR(){
buffer[0]='E';
buffer[1]='R';
buffer[2]='R';
buffer[3]='O';
buffer[4]='R';
buffer[5]=0x0d;
buffer[6]='\0';
}
*/

unsigned char DTMF2ASCII(unsigned char DTMFCode){
    /*
    FLOW 	FHIGH 	KEY 	TOW Q4 Q3 Q2 Q1
    697 	1209 	1 	H   0  0  0  1
    697 	1336 	2 	H   0  0  1  0
    697 	1477 	3 	H   0  0  1  1
    770 	1209 	4 	H   0  1  0  0
    770 	1336 	5 	H   0  1  0  1
    770 	1477 	6 	H   0  1  1  0
    852 	1209 	7 	H   0  1  1  1
    852 	1336 	8 	H   1  0  0  0
    852 	1477 	9 	H   1  0  0  1
    941 	1336 	0 	H   1  0  1  0
    941 	1209 	* 	H   1  0  1  1
    941 	1477 	# 	H   1  1  0  0
    697 	1633 	A 	H   1  1  0  1
    770 	1633 	B 	H   1  1  1  0
    852 	1633 	C 	H   1  1  1  1
    941 	1633 	D 	H   0  0  0  0
    */
    switch (DTMFCode){
        case 0b1010:
            return '0';
        case 0b1011:
            return '*';
        case 0b1100:
            return '#';
        case 0b1101:
            return 'A';
        case 0b1110:
            return 'B';
        case 0x1111:
            return 'C';
        case 0x0000:
            return 'D';
        default:
            return DTMFCode+'0';
    }
}

#pragma warn+
void main(void){
    
    // Input/Output Ports initialization
    // Port B
    
    PORTB=0x04;
    DDRB=0x3f;
    //  DDRB=0x0f;
    
    PORTC=0xff;
    DDRC=0x20;
    
    // Port D
    PORTD=0xff;
    DDRD=0x00;
    
    
    // Timer/Counter 1 initialization
    // Clock source: System Clock
    // Clock value: 375,000 kHz
    // Mode: Output Compare
    // OC1 output: Discon.
    // Noise Canceler: Off
    // Input Capture on Falling Edge
    // Auto Clean on Compare Match
    
    //   TCCR1A=0x00;
    
    //   TCNT1H=0x00;
    //   TCNT1L=0x00;
    
    #if defined(_CHIP_AT90S8515_) || defined(_CHIP_ATMEGA8_)
    //Uni-Clock for 8515 (other symbols):
    if (Clock&0xffc00000){
        TCCR1B=0x0b;  // Prescaler: 64
        OCR1A=(Clock/640);
    }
    else{
        TCCR1B=0x0a;  // Prescaler: 8
        OCR1A=(Clock/80);
    }
    #else
        //Uni-Clock:
        if (Clock&0xffc00000){
            TCCR1B=0x0b;  // Prescaler: 64
            OCR1=(Clock/640);
        }
        else{
            TCCR1B=0x0a;  // Prescaler: 8
            OCR1=(Clock/80);
        }
    
    #endif
    
    //For Debug:
    // OCR1H=0x00;
    // OCR1L=0x20;
    
    // External Interrupt(s) initialization
    // INT0: Off
    // INT1: Off
    
    //   GIMSK=0x00;
    MCUCR=1<<SE;
    
    // Timer(s)/Counter(s) Interrupt(s) initialization
    TIMSK=  1<<OCIE1A | 1<<TOIE0;
    
    // Analog Comparator initialization
    // Analog Comparator: Off
    // Analog Comparator Input Capture by Timer/Counter 1: Off
    ACSR=1<<ACD;
    
    // UART initialization
    // Communication Parameters: 8 Data, 1 Stop, No Parity
    // UART Receiver: On
    // UATT Receiver Interrupt: On
    // UART Transmitter: On
    // UART Transmitter Interrupt: Off
    // UART Baud rate: 4800
    
    #if defined(_CHIP_AT90S8515_)
    // Code for 8515
    UCR= 1<<RXCIE | 1<< RXEN | 1<<TXEN;
    
    
    //Uni-Clock:
    
    UBRR =((Clock/(16*4800))-1);
    #endif
    #if defined(_CHIP_AT90S4433_)
    UCSRB= 1<<RXCIE | 1<< RXEN | 1<<TXEN;
    
    
    //Uni-Clock:
    
    UBRR =((Clock/(16*4800))-1);
    
    UBRRHI=0x00;
    #endif
    #if defined(_CHIP_ATMEGA8_)
    UCSRB=1<<RXCIE | 1<< RXEN | 1<<TXEN;
    
    
    //Uni-Clock:
    
    UBRRL =((Clock/(16*4800))-1);
    
    UBRRH=0x00;
    #endif
    
    
    // Initialisierte Varibalen mit Werte aus EEProm:
    SquelchAktivLevel =	 PortAktivLevel & (0b00000001);
    Squelch1750HzAktiv = FeatureControl & (0b00000001);
    
    AnsageAktivLevel  = 	 PortAktivLevel & (0b00000010);
    
    SprachkennungAktiv= 	 FeatureControl & (0b00000010);
    
    PTTAktivLevel     = 	 PortAktivLevel & (0b00000100);
    
    BakenkennungAktiv = 	 FeatureControl & (0b00000100);
    
    Squelch1750HzAktivLevel =    PortAktivLevel & (0b00001000);
    
    DTMFAktiv =       	         FeatureControl & (0b00001000);
    
    MorsekennungAktiv = 	 FeatureControl & (0b00010000);
    
    
    SquelchDelay       = SquelchStartDelay;
    SquelchOffen      = 0;
    
    
    Ansage_Port.Ansage_Pin = !AnsageAktivLevel;
    PTT_Port.PTT_Pin  = !PTTAktivLevel ;
    #ifdef DEBUG
    putchar('s');
    putchar('c');
    #endif
    
    // Global enable interrupts
    #asm("sei")
    
    
    // Wert am Outputport wiederherstellen:
    DTMFReceiveBuffer[7]=  DTMFOutputPortValue;
    DTMFReceiveBuffer[7]= DTMFReceiveBuffer[7] OUTPORTMOD;
    DTMFReceiveBuffer[7] |=(OUTPINPORT&0x07);
    OUTPORT=DTMFReceiveBuffer[7];
    
    #ifdef DEBUG
    putchar('o');
    putchar('n');
    #endif
    
    Ansage();
    AusgabeMorsekennung();
    
    
    while ((AnsageLaeuft||MorsekennungLaeuft));
    
    RogerBeep();
    while ((AnsageLaeuft||MorsekennungLaeuft||RogerBeepLaeuft));
    
    PTTAuto		=1;
    PTTAutoTime=StartTimer();
    
    while (1)
    {
        
        if (buffercomplete){
            buffercomplete=0;
            bufferlen=18; //Reset RX-Buffer
            
            if (buffer[0]=='?'){
                buffer[3]='=';
                buffer[6]=0x0d;
                buffer[7]='\0';
                chartoascii(ReadEEProm((unsigned int) asciitochar(&buffer[1])),&buffer[4]);
                puts(buffer);
                
            }
            else  if (buffer[0]=='!'){
                WriteEEProm((unsigned int) asciitochar(&buffer[1]),asciitochar(&buffer[4]));
                WriteOK();
            }
            else if ((buffer[0]=='P')&&(buffer[1]=='T')&&(buffer[2]=='T')){
                if ((buffer[3]=='O')&&(buffer[4]=='N')){
                    PTT_Port.PTT_Pin = PTTAktivLevel;
                    PTTAuto=0;
                    PTTState=1;
                    WriteOK();
                }
                else  if ((buffer[3]=='O')&&(buffer[4]=='F')&&(buffer[5]=='F')) {
                    PTT_Port.PTT_Pin = !PTTAktivLevel;
                    PTTAuto=0;
                    PTTState=0;
                    WriteOK();
                }
                
                else if ((buffer[3]=='A')&&(buffer[4]=='U')&&(buffer[5]=='T')&&(buffer[6]=='O')){
                    PTTAuto=1;
                    WriteOK();
                }
                else {
                    putsf("AUTO=");
                    putchar(PTTAuto+'0');
                    putchar(0x0d);
                    putsf("PTT=");
                    putchar(PTTState+'0');
                    putchar(0x0d);
                }
                
            }
            else if ((buffer[0]=='R')&&(buffer[1]=='B')){
                RogerBeep();
                WriteOK();
            }
            else if ((buffer[0]=='C')&&(buffer[1]=='W')){
                AusgabeMorsekennung();
                WriteOK();
            }
            else if ((buffer[0]=='C')&&(buffer[1]=='A')&&(buffer[2]=='L')&&(buffer[3]=='L')){
                Ansage();
                WriteOK();
            }
            else if ((buffer[0]=='V')&&(buffer[1]=='E')&&(buffer[2]=='R')&&(buffer[3]=='S')&&(buffer[4]=='I')&&(buffer[5]=='O')&&(buffer[6]=='N')){
                putsf(VERSION);
            }
            else if ((buffer[0]=='R')&&(buffer[1]=='E')&&(buffer[2]=='S')&&(buffer[3]=='E')&&(buffer[4]=='T')){
                WriteOK();
                TCNT1H=0x00;
                TCNT1L=0x00;
                
                #asm("rjmp 0x00"); // Reset AVR
            }
            else{
                putsf("ERROR\x00d");
            }
            
            bufferlen=0;
        }
        
        
        // DTMF
        if (!DTMFIgnore){
            // DTMF-Signale werden akzepiert
            if ((DTMFVALID)){
                // Es steht ein gltiges externes Signal vom Decoder an
                if (!DTMFReceiveCounter){
                    DTMFBackPTTAuto=PTTAuto;
                    DTMFBackPTTState=PTTState;
                }
                if (!DTMFZeichenGueltig){
                    // DTMFValid hat gerade den Pegel gewechselt, (Flanke)
                    DTMFZeichenGueltig=1;
                    DTMFReceiveBuffer[DTMFReceiveCounter]=DTMF2ASCII(DTMFPIN);
                    DTMFReceiveCounter++;
                    DTMFTimer=StartTimer();
                    
                    if ((DTMFReceiveCounter==2)&&(DTMFReceiveBuffer[0]=='*')&&(DTMFReceiveBuffer[1]=='#')){
                        // Zwei Zeichen, '*#',  empfangen --> deaktiviere PTT um mithorchen zu verhindern                        DTMFBackPTTAuto=PTTAuto;
                        PTTAuto=0;
                        PTTState=0;
                    }
                }
            }
            else{
                // Es steht kein Signal an.
                DTMFZeichenGueltig=0;
                if (DTMFReceiveCounter>=7){
                    // Ein kompletter String wurde empfangen. Teste ob Passwort korrekt ist
                    char PasswortState=0;   // 0.. Okay
                    // 1.. Falsch
                    char i;
                    if ((DTMFReceiveBuffer[0]!='*')||(DTMFReceiveBuffer[1]!='#')){
                        PasswortState=1;
                    }
                    
                    for (i=2;i<6;i++){
                        if ((!DTMFReceiveBuffer[i])||(DTMFReceiveBuffer[i]!=DTMFKey[i-2])){
                            PasswortState=1;
                        }
                    }
                    
                    if (PasswortState){
                        // Passwort ist falsch, schalte DTMF fr 10x DTMFTimeout aus
                        DTMFIgnore=1;
                        DTMFReceiveCounter=0;
                        PTTAuto=DTMFBackPTTAuto;
                        PTTState=DTMFBackPTTState;
                    }
                    else{
                        // Passwort ist korrekt.
                        switch(DTMFReceiveBuffer[6]){
                            // Werte Befehl aus
                            case '1':  // PTT ON;
                                PTTState=1;
                                PTTAuto=0;
                                DTMFReceiveCounter=0;
                                break;
                            case '2': //PTT OFF;
                                PTTState=0;
                                PTTAuto=0;
                                DTMFReceiveCounter=0;
                                break;
                            case '3': // PTT AUTO
                                PTTAuto=1;
                                DTMFReceiveCounter=0;
                                break;
                            case '4': // Ansage
                                PTTAuto=DTMFBackPTTAuto;
                                PTTState=DTMFBackPTTState;
                                DTMFReceiveCounter=0;
                                Ansage();
                                break;
                            case '5': // Rogerbeep
                                PTTAuto=DTMFBackPTTAuto;
                                PTTState=DTMFBackPTTState;
                                DTMFReceiveCounter=0;
                                RogerBeep();
                                
                                break;
                            case '6':
                                #asm("rjmp 0x00"); // Reset AVR
                            case '7': // Morsekennung
                                AusgabeMorsekennung();
                                break;
                            case '8': // Morsekennung ein/aus
                                MorsekennungAktiv=~MorsekennungAktiv;
                                FeatureControl=(FeatureControl&0b11101111)|(MorsekennungAktiv<<4);
                                break;
                                
                            case '9': // Ansage ein/aus
                                SprachkennungAktiv=~SprachkennungAktiv;
                                FeatureControl=(FeatureControl&0b11111101)|(SprachkennungAktiv<<1);
                                break;
                                
                            case '0': // Set Port(b)
                                if (DTMFReceiveCounter==8){
                                    if ((DTMFReceiveBuffer[7]<'8')&&(DTMFReceiveBuffer[7]>='0')){
                                        DTMFReceiveBuffer[7]-='0';
                                        DTMFOutputPortValue=DTMFReceiveBuffer[7]; // Speichert Wert im EEProm ab, um ihn nach einem Reset wiederherstellen zu knnen.
                                        DTMFReceiveBuffer[7]= DTMFReceiveBuffer[7] OUTPORTMOD;
                                        DTMFReceiveBuffer[7] |=(OUTPINPORT&0x07);
                                        OUTPORT=DTMFReceiveBuffer[7];
                                    }
                                    PTTAuto=DTMFBackPTTAuto;
                                    PTTState=DTMFBackPTTState;
                                    DTMFReceiveCounter=0;
                                }
                                break;
                            default:
                                PTTAuto=DTMFBackPTTAuto;
                                PTTState=DTMFBackPTTState;
                                DTMFReceiveCounter=0;
                        }
                    }
                }
                if ((DTMFReceiveCounter)&&(ElapsedTime(DTMFTimer)>DTMFTimeout)){
                    PTTAuto=DTMFBackPTTAuto;
                    PTTState=DTMFBackPTTState;
                    DTMFReceiveCounter=0;
                }
            }
        }
        else{
            // DTMF wird fr DTMFIgnoreTime abgeschatet
            if (ElapsedTime(DTMFTimer)>DTMFIgnoreTime){
                // DTMF-Ignore-Zeit ist vergangen, schalte DTMF wieder ein.
                DTMFTimer=StartTimer();
                DTMFIgnore=0;
            }
        }
        
        // Control
        if (ElapsedTime(PTTAutoTime)){
            
            PTTAutoTime=StartTimer();
            
            
            if (PTTAuto){
                // Automaticher Modus: Squelch, Ansage, CW und Rogerbeep steueren PTT
                
                if (Squelch_Port.Squelch_Pin == SquelchAktivLevel){
                    // Squelch ist aktiv
                    if (TimeoutSperreAktiv == 0){
                        // Ruf ist nicht gesperrt
                        if ((Ruf == 0)&&(SquelchDelay == 0)){
                            // Squelch ist  auf High gewechselt und die Squelch-Verzgerung ist abgelaufen.
                            Counter = 0;
                            Ruf = 1;
                            PTT_Port.PTT_Pin = PTTAktivLevel;
                            #ifdef DEBUG
                            putchar('1');
                            #endif
                        }else if ((Ruf == 0)&&(SquelchDelay!=0)){
                            //  Squelch ist  auf High gewechselt, die Verzgerung luft
                            if (Squelch1750HzAktiv){
                                if (Squelch1750Hz_Port.Squelch1750Hz_Pin==Squelch1750HzAktivLevel){
                                    SquelchDelay=0;
                                }
                            }
                            else{
                                SquelchDelay--;
                            }
                            #ifdef DEBUG
                            putchar('2');
                            #endif
                            
                        }else if ((TimeoutSperre!=0) && (Counter > TimeoutSperre)){
                            // berzeitsperre wird aktiviert (sofern nicht deaktiviert)
                            PTTOffenBeiAnsagestart=0;
                            Ansage();
                            
                            AusgabeMorsekennung();
                            
                            TimeoutSperreAktiv = 1;
                            #ifdef DEBUG
                            putchar('3');
                            #endif
                        }
                        else{
                            // Ruf bereits lnger aktiv
                            // Einige Variablen werden zurckgesetzt um Probleme mit Umschaltenden Squelch zu vermeiden
                            RogerBeepLaeuft = 0;
                            Squelchzeit_checked=0;
                            #ifdef DEBUG
                            putchar('4');
                            #endif
                        }
                    }
                    else{
                        // Timeout (Quasselsperre)
                        #ifdef DEBUG
                        putchar('5');
                        #endif
                        // PTTOffenBeiAnsagestart=0;
                        if (!(MorsekennungLaeuft||AnsageLaeuft||RogerBeepLaeuft))   {
                            
                            PTT_Port.PTT_Pin = !PTTAktivLevel;
                        }
                        
                        
                        //  TimeoutSperreAktiv = 1;  // Ansage setzt die Timeoutsperre zurck, daher wird sie hier wiederhergestellt
                    }
                    
                }
                else{
                    // Squelch ist nicht aktiv.
                    if (Ruf==1){
                        #ifdef DEBUG
                        putchar('6');
                        #endif
                        // Squelch ist gerade abgefallen
                        if (!Squelchzeit_checked && (Counter>SquelchMin)){
                            #ifdef DEBUG
                            putchar('A');
                            #endif
                            // die Angegebene minimale Zeit fr einen offenen Squelch wurde berschritten.
                            SquelchOffen = SquelchOffenZeit;
                            SquelchDelay = 0;
                        }
                        Squelchzeit_checked=1; // Verhindert das die Zeit von Rogerbeep und Ansage mit in die zeit eingerechnet werden.
                        if ((RufCounter>=RufeBisAnsage)||(AnsageCounter>Ansagewiederholugszeit)||(TimeoutSperreAktiv)){
                            #ifdef DEBUG
                            putchar('B');
                            #endif
                            // Zeit fr eine Kennungsansage
                            PTTOffenBeiAnsagestart=1;
                            
                            Ansage();
                            
                            AusgabeMorsekennung();
                            
                            if (TimeoutSperreAktiv){
                                Ruf=0;
                                PTTOffenBeiAnsagestart=0;
                            }
                            
                            
                            // putsf("ruf=1;timeout\xd");
                        }
                        else{
                            // RogerBeep wird ausgegeben
                            //   putsf("ruf=1;a=1\xd");
                            
                            //    putsf("ruf=1;\xd");
                            #ifdef DEBUG
                            putchar('C');
                            #endif
                            
                            RogerBeep();
                            
                        }
                    }
                    else{
                        //            putsf("ruf=0;\xd");
                        // Squelch schon lnger abgefallen
                        #ifdef DEBUG
                        putchar('7');
                        #endif
                        
                        if (((Counter>Ansagewiederholugszeit)&&BakenkennungAktiv)){
                            // Ansage nach Leerlaufzeit,sofern aktiviert, oder wenn eine Ansage gerade luft
                            #ifdef DEBUG
                            putchar('A');
                            #endif
                            
                            PTTOffenBeiAnsagestart=0;
                            Ansage();
                            
                            AusgabeMorsekennung();
                            
                        }
                        
                        
                        if (TimeoutSperreAktiv &&(!(AnsageLaeuft||MorsekennungLaeuft))){
                            #ifdef DEBUG
                            putchar('B');
                            #endif
                            PTTOffenBeiAnsagestart=0;
                            TimeoutSperreAktiv=0;
                        }
                    }
                    if (SquelchOffen){
                        SquelchOffen--;
                    }
                    else if (Ruf==0){
                        //  SquelchOffen = SquelchOffenZeit;
                        if (Squelch1750HzAktiv){
                            SquelchDelay =1;
                        }
                        else{
                            SquelchDelay = SquelchStartDelay;
                        }
                    }
                }
            }
            
            else{
                // Manueller Modus: PTT wird per Terminal gesteuert
                
                
                if (PTTState){
                    
                    
                    PTT_Port.PTT_Pin = PTTAktivLevel;
                    
                }
                else{
                    if (!((AnsageLaeuft||MorsekennungLaeuft||RogerBeepLaeuft)))
                    {
                        PTT_Port.PTT_Pin = !PTTAktivLevel;
                    }
                }
            }
        }
        
    };
}







