
#ifndef _PIN_H_
#define _PIN_H_

#include <avr/io.h>

#include "templates.h"

enum portInit
{
	portA, portB, portC, portD, portE
};
enum pinInit
{
	pin0, pin1, pin2, pin3, pin4, pin5, pin6, pin7,
	pinInput	= 0x00,
	pinOutput	= 0x10,
	pinPullUp	= 0x30
};

#define PORT(x)		case port##x : port = &PORT##x; ddr = &DDR##x; pin = &PIN##x; break
class mcPin
{
private:
	volatile uint8_t *port;
	volatile uint8_t *ddr;
	volatile uint8_t *pin;
	uint8_t nr;
public:
	inline mcPin(portInit po, pinInit pi)
	{
		switch (po)
		{
#ifdef PORTA
			PORT(A);
#endif
#ifdef PORTB
			PORT(B);
#endif
#ifdef PORTC
			PORT(C);
#endif
#ifdef PORTD
			PORT(D);
#endif
#ifdef PORTE
			PORT(E);
#endif
			default:
				break;
		}
		nr = pi & 0x0F;
		if (pi & pinOutput)
			*ddr |= (1 << nr);
		if (pi & pinPullUp)
			*port |= (1 << nr);

	};
	inline void On()		{ *port |=  (1 << nr); };
	inline void Off()		{ *port &= ~(1 << nr); };
	inline void Toggle()	{ *port ^=  (1 << nr); };
	inline uint8_t Get()	{ return *pin & (1 << nr); };
};


#endif	// _PIN_H_
