#include <stdio.h>
#include <time.h>
#include <sys\stat.h>
#include <utime.h>
#include <windows.h>

#define MAXLINELENGTH 32768


typedef struct
 {
 int aktiv;
 char Name[200];
 char Formel[200];
 } satz;

double X[1024],Y[1024],Z[1024];
double Ddummy[1024];
int Geduld=0;

#include "Formelparser.c"

FILE *outfile;
satz *feld;
int Inspalten=8,spalten,Minzeit=0,Startzeit=0,
     Zahlenformat=0,
    SatzNr=0,Kopfzeilen=0,appendmode=0,Jahr=2000,oldhour=0;
char MonatName[12][12]={"Jan","Feb","Mar","Apr","Mai","Jun","Jul","Aug","Sep","Okt","Nov","Dez"};
double MaxWert=1.79769e+308,MinWert=-1.79769e+308;
struct stat src_stat;

double altzeit,aktzeit,Intervall=0;



char* myfgets(char* str,int MaxLineLength,FILE* datei)
 {
  char *cp1;
  int a,ch;
  cp1=str;
  a=0;
  do
   {
   ch=fgetc(datei);
   *cp1=ch;
   cp1++;
   a++;
   }
  while((!feof(datei))&&(ch!=10)&&(ch!=13)&&(a<MaxLineLength));
  cp1--;
  *cp1='\n';
  cp1++;
  *cp1=0;
  if (feof(datei)) return 0;
  return str; 
 }


double ParseTime(char* Ref, char** Wert)
 {
  struct tm Zeit;
  char *cp1, *cp2, *altptr, ch, Element,Separator;
  int a;
  static defday=1;
  double i,zeit,sec=0;
  time_t tt;
  
  Zeit.tm_sec=0;
  Zeit.tm_min=0;
  Zeit.tm_hour=0;
  Zeit.tm_mday=0;
  Zeit.tm_mon=0;
  Zeit.tm_year=Jahr-1900;
  Zeit.tm_isdst=-1;
  //printf("ParseTime Ref=%s,Wert=%s\n",Ref,*Wert);
  while(*Ref)
   {
    ch=*Ref;
    if (strchr("TMJhms",ch))
     {
      Element=ch;
     }
    else
     {
      Separator=ch;
      /* Separator im Datenstring suchen */
      cp1=strchr(*Wert,Separator);
      if(cp1) 
       {
       *cp1=0;
       while(*(cp1+1)==Separator) /*wiederholte Separatorzeichen ohne was drin*/
        {
        cp1++;
        *cp1=0;
        }
       altptr=*Wert; /*evtl brauchen wir den noch (Monatsname)*/
       i=atof(*Wert);
       *Wert=cp1+1; /* hinter den gelesenen Wert */
       switch(Element)
        {
        case 's': 
         {
         sec=i; 
         //printf("Sekunde=%lf\n",i);
         break;
         }
        case 'm': Zeit.tm_min=i; break;
        case 'h': Zeit.tm_hour=i; break;
        case 'T': Zeit.tm_mday=i; break;
        case 'M': 
            {
            Zeit.tm_mon=i-1;
            if((i>13)||(i<1))
             {
             a=0;
             while((strcmp(MonatName[a],altptr))&&(a<11))a++;
             Zeit.tm_mon=a;
             } 
            break;
            }
        case 'J': 
         {
         if(i<100) i+=2000; /* falls Jahr zweistellig ist! */
         Zeit.tm_year=i-1900; 
         break;
         }
        }
       }
     }
    Ref++;
   }
  if(oldhour>Zeit.tm_hour) defday++; /* Wenn Stunde kleiner wurde, muss neuer Tag sein */
  if(Zeit.tm_mday==0) Zeit.tm_mday=defday; /* Tag wurde nicht gelesen */
  oldhour=Zeit.tm_hour;
  Zeit.tm_sec=0; /* werden spter addiert */
  tt=mktime(&Zeit);
  zeit=tt;	/* ganzzahliger Teil */
  zeit=zeit+sec;
  return zeit;
 }


int Ausg(double t)
 {
  int a;
  struct tm *pTime;
  time_t tt;
  double fpart,ipart;

  fpart=modf(t,&ipart); 
  tt=ipart;
  pTime=localtime(&tt);
  fpart+=pTime->tm_sec;
  fprintf(outfile,"%02d.%02d.%04d;%02d:%02d:%lf",pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900,
                                               pTime->tm_hour,
                                               pTime->tm_min,
                                               fpart);
  for(a=1;a<spalten;a++)
   {
    if(feld[a].aktiv) 
     {
      if(Y[a]>MaxWert) fprintf(outfile,";1.#IND00"); else
      if(Y[a]<MinWert) fprintf(outfile,";-1.#IND00"); else
      fprintf(outfile,";%lf",Y[a]);
     }
   }
 Geduld++;
 if(Geduld>1000)
  {
  Geduld=0;
  printf("\r%02d.%02d.%04d",pTime->tm_mday,
                                               pTime->tm_mon+1,
                                               pTime->tm_year+1900);  
  }  
 fprintf(outfile,"\n");
 return 0;
 }

int main(int argc,char **argv)
 {
 int Separator=',',
      MinInterval=0,
      a,c,umgesetzt=0,monat,jahr,i;
 double wert;
 FILE *config,*infile;
 char st1[MAXLINELENGTH],Zeitformat[200],*cp,*cp1,*cp2,ch;
 struct tm t;
 struct utimbuf times;

 for(a=0;a<1024;a++) X[a]=Y[a]=0;
 strcpy(Zeitformat,"T.M.J h:m:s");
  
 if(argc<2)
  {
  printf("Benutzung:\nkonv2 <rohdatei> [configdatei] [zieldatei]\n");
  printf("Weiter mit Entertaste.");
  getch();  
  return -1;
  }
 
 strcpy(st1,"config.txt");
 if(argc>2) strcpy(st1,argv[2]);
 /*Konfigurationsdatei ffnen*/
 config=fopen(st1,"r");
 if(!config)
  {
  printf("Configdatei %s nicht gefunden!\n",st1);
  printf("Weiter mit Entertaste.");
  getch();  
  return -1;
  }

 /* Erfassen, wie viele Zeilen Musterzeilen enthalen (mindestens 1 Semikolon) */

 /* erste Zeile lesen */
 spalten=0;
 while(!feof(config))
  {
  /* nchste Zeile lesen */
  memset(st1,0,MAXLINELENGTH);
  fgets(st1,MAXLINELENGTH-2,config);
  if(st1[0]!=' ')		/* Kommentarzeile */
  if(cp=strchr(st1+1,';')) spalten++;
  }
 printf ("%d Spalten\n",spalten);
 rewind(config);
 

 /*Speicher reservieren*/
 feld=calloc(spalten+5,sizeof(satz));
 cp=st1;

 /*Jetzt die Config richtig einlesen*/
 a=0;
 while (!feof(config))
  {
   memset(st1,0,MAXLINELENGTH);
   fgets(st1,MAXLINELENGTH-2,config);
   /* CR durch Semikolon ersetzen */
   if(cp=strchr(st1,'\n')) *cp=';';
   
   if(cp=strchr(st1,'='))
    {
     /* Parameterzeile */
     *cp=0;
     cp++;
     cp1=st1;
     if(*cp1=='"') cp1++;
     if(!strcmp(cp1,"Separator"))
      {
      sscanf(cp,"%d;",&Separator);
      }
     if(!strcmp(cp1,"Minzeit"))
      {
      sscanf(cp,"%d;",&Minzeit);
      }
     if(!strcmp(cp1,"Zahlenformat"))
      {
      sscanf(cp,"%d;",&Zahlenformat);
      }
     if(!strcmp(cp1,"Spalten"))
      {
      sscanf(cp,"%d;",&Inspalten);
      }
     if(!strcmp(cp1,"Startzeit"))
      {
      sscanf(cp,"%d;",&Startzeit);
      }
     if(!strcmp(cp1,"Intervall"))
      {
      sscanf(cp,"%lf;",&Intervall);
      }
     if(!strcmp(cp1,"Jahr"))
      {
      sscanf(cp,"%d;",&Jahr);
      }
     if(!strcmp(cp1,"Kopfzeilen"))
      {
      sscanf(cp,"%d;",&Kopfzeilen);
      }
     if(!strcmp(cp1,"Zeitformat"))
      {
      strcpy(Zeitformat,cp);
      }
     if(!strcmp(cp1,"Erweitern"))
      {
      sscanf(cp,"%d;",&appendmode);
      }
     if(!strcmp(cp1,"Minwert"))
      {
      sscanf(cp,"%lf;",&MinWert);
      }
     if(!strcmp(cp1,"Maxwert"))
      {
      sscanf(cp,"%lf;",&MaxWert);
      }
     if(!strcmp(cp1,"Jan"))
      {
      strcpy(MonatName[0],cp);
      }
     if(!strcmp(cp1,"Feb"))
      {
      strcpy(MonatName[1],cp);
      }
     if(!strcmp(cp1,"Mar"))
      {
      strcpy(MonatName[2],cp);
      }
     if(!strcmp(cp1,"Apr"))
      {
      strcpy(MonatName[3],cp);
      }
     if(!strcmp(cp1,"Mai"))
      {
      strcpy(MonatName[4],cp);
      }
     if(!strcmp(cp1,"Jun"))
      {
      strcpy(MonatName[5],cp);
      }
     if(!strcmp(cp1,"Jul"))
      {
      strcpy(MonatName[6],cp);
      }
     if(!strcmp(cp1,"Aug"))
      {
      strcpy(MonatName[7],cp);
      }
     if(!strcmp(cp1,"Sep"))
      {
      strcpy(MonatName[8],cp);
      }
     if(!strcmp(cp1,"Okt"))
      {
      strcpy(MonatName[9],cp);
      }
     if(!strcmp(cp1,"Nov"))
      {
      strcpy(MonatName[10],cp);
      }
     if(!strcmp(cp1,"Dez"))
      {
      strcpy(MonatName[11],cp);
      }      
    }
   else
    { 
    c=0;
    cp=st1;
    while(cp=strchr(cp+1,';')) c++;
    if ((c>1)&&(st1[0]!=' '))
    {
      /* Kanalzeile */
     if(cp1=strchr(st1,';'))
      {
      *cp1=0;
      cp1++;		/* Anfang Formel */
      cp=st1;
      if(*cp=='"')
       {
        cp++;
        if(cp2=strchr(cp,'"')) *cp2=0;
       }
      strcpy(feld[a].Name,cp);
      cp=cp1;
      /* Kommas durch Punkte ersetzen*/
      while(cp1=strchr(cp1,',')) *cp1='.';

      if(cp1=strchr(cp,';')) *cp1=0;    
      if(cp1=strchr(cp,' ')) *cp1=0; /* Kommentar nach der Formel */
      strcpy(feld[a].Formel,cp);
      a++;
      }
     }
    }
  } 
 fclose(config);
 printf(" %d gelesene Spalten\n",a);
 spalten=a;	/* so viele haben wir wirklich */
 
 /* Namen durchschauen nach disable-tag */
 for(a=1;a<spalten;a++)
  {
   feld[a].aktiv=1;
   if(cp=strchr(feld[a].Name,'#')) 	/* Die Farbe */
    {
    if(cp=strchr(cp+1,'#'))
     {	  	/* Der Enable-Tag */
     if(cp[1]=='2') feld[a].aktiv=0;
     }
    }
  }
 
 
 /* Tabelle auf Bildschirm */
 for(a=1;a<spalten;a++)
  {
  printf("%2d: %-20s %d %-20s\n",a,feld[a].Name,feld[a].aktiv, feld[a].Formel);
  /* Formeln validieren */
  Y[a]=parse(feld[a].Formel,feld[a].Name);
  }
 
 /* Semikolon hinten am Zeitformat abschneiden */
 cp=strrchr(Zeitformat,';');
 if(cp) *cp=0;
 /* dann Separator anhngen */
 a=strlen(Zeitformat);
 Zeitformat[a]=Separator;
 Zeitformat[a+1]=0;
 printf("Zeitformat= [%s], Kopfzeilen=%d, Startzeit=%d\n",Zeitformat,Kopfzeilen,Startzeit);
 //printf("Maxwert=%lf, Minwert=%lf\n",MaxWert,MinWert);
 /* eventuelle Semikola hinter Monatsnamen entfernen */
 for(a=0;a<12;a++) if(cp=strchr(MonatName[a],';')) *cp=0;
 for(a=0;a<12;a++) printf("%d=%s;",a+1,MonatName[a]);
 printf("\nBeginne mit konvertieren...\n");
 aktzeit=0x01000000; /*rein Willkrlich festgelegt, um unterlauf zu vermeiden*/

 /* Versuchen Arbeitsdatei zu ffnen */
 stat(argv[1],&src_stat);	/* Zeitstempel Quelldatei merken */

 infile=fopen(argv[1],"r");
 if(!infile)
  {
  printf("Eingabedatei %s konnte nicht geffnet werden!\n",argv[1]);
  printf("Weiter mit Entertaste.");
  getch();  
  return -1;
  }
 
 switch (Startzeit)
  {
  case 1:
   {
   /* Ermittlung ber den Zeitstempel der Datei */
   aktzeit=src_stat.st_mtime; /* Datum der letzten nderung */
   a=0;
   while(!feof(infile))	/* Zeilen zhlen */
    {
     myfgets(st1,MAXLINELENGTH-2,infile);
     a++;
    }
   aktzeit-=(a*Intervall); /* fr jede gelesene Zeile ein Intervall zurck */
   rewind(infile);
   break;
   }
  case 2:
   {
   /* Anfangszeit aus Dateinamen unformatiert (JJJJMMTThhmmss) */
   int jahr=0,monat=0,tag=0,stunde=0,minute=0,sekunde=0;
   struct tm Zeit;
   char st1[500],*cp;
   strcpy(st1,argv[1]);
   cp=strrchr(st1,'\\');
   if(cp) cp++;
   else cp=st1;   
   sscanf(cp,"%04d%02d%02d%02d%02d%02d",&jahr,&monat,&tag,&stunde,&minute,&sekunde);     
   Zeit.tm_sec=sekunde;
   Zeit.tm_min=minute;
   Zeit.tm_hour=stunde;
   Zeit.tm_mday=tag;
   Zeit.tm_mon=monat-1;
   Zeit.tm_year=jahr-1900;
   Zeit.tm_isdst=-1;
   aktzeit=mktime(&Zeit);  
   break;
   }
  case 3:
   {
   /* Anfangszeit aus Dateinamen nach Formatstring */
   char st1[500],*cp;   
   cp=st1;
   strcpy(st1,argv[1]);
   // printf("suche in %s nach %s\n",st1,Zeitformat);
   aktzeit=ParseTime(Zeitformat,&cp);   
   break;
   }
  case 99:
   {
   /* Anfangszeit ist irrelevant (nur delta interressant) */
   aktzeit=946681200; /* 1.1.2000 */
   break;
   }
  }

 /* eventuelle Kopfzeilen berlesen */
 if(Kopfzeilen)
  {
  for(a=0;a<Kopfzeilen;a++) myfgets(st1,MAXLINELENGTH-2,infile);
  }
  
 /* Ausgabedatei ffnen */
 strcpy(st1,"temp.csv");
 if(argc>3) strcpy(st1,argv[3]);
 outfile=0;
 if(appendmode)
  {
   outfile=fopen(st1,"r");
   if(outfile)
    {
    fclose(outfile);
    outfile=fopen(st1,"a");
    }
  }
 if(!outfile)
  {
  outfile=fopen(st1,"w");
  if(!outfile)
   {
   printf("Ausgabedatei %s kann nicht beschrieben werden!\n",st1);
   printf("Weiter mit Entertaste.");
   getch();  
   return -1;
   }
  /*Kopfzeile schreiben*/
  fprintf(outfile,"Datum;Zeit");
  for(a=1;a<spalten;a++)
   {
   if(feld[a].aktiv) fprintf(outfile,";%s",feld[a].Name);
   }
  fprintf(outfile,"\n");
  }

 /* Werte konvertieren */
 while(!feof(infile))
  {
   memset(st1,0,MAXLINELENGTH);
   myfgets(st1,MAXLINELENGTH-2,infile);
   if(!feof(infile))
   {
    /* Kommas in Punkte umwandeln */
    cp=st1;
    if(Separator!=',') while(cp=strchr(cp,',')) *cp='.';
    /* Wagenrcklauf durch Separator ersetzen */
    if (cp=strchr(st1,'\n')) *cp=Separator;

    /* Separatoren zhlen */
    a=0;
    cp1=st1;
    while (cp1=strchr(cp1+1,Separator)) a++;
    if(a>=Inspalten)
    {
    /* Datensatz fr gltig befunden */
    /* Werte einlesen */
    cp=st1;
    if(!Intervall)
    {
     /* Datum, Uhrzeit einlesen */
     aktzeit=ParseTime(Zeitformat,&cp);
     
     if(Minzeit)
      {
      if((aktzeit>(altzeit+Minzeit))&&SatzNr)
       {
       /* Fge noch eine Zeile mit alten Werten ein */
       Ausg(aktzeit-Minzeit);
       }
      }      
    }
  
    cp1=cp;
    umgesetzt=0;
    a=1;
    while((*cp1)&&cp1)
     {
      if(cp=strchr(cp1,Separator))
       {
       *cp=0;
       cp++;
       }
      ch=*cp1;
     while((!isxdigit(ch))
          &&(ch!='.')
          &&(ch!='-')
          &&(ch))
      {
      cp1++;
      ch=*cp1;
      }
     switch(Zahlenformat)
      {
      case 1:	/* unsigned hex */
       {
        sscanf(cp1,"%x",&i);
        if(i>32767) i-=65536;
        X[a]=i;
        break;
       }
      case 2:	/* signed hex */
       {
        sscanf(cp1,"%x",&i);
        X[a]=i;
        break;
       }
      default:
       {
        sscanf(cp1,"%lf",&X[a]);
        break;
       }
      }
     umgesetzt++;
     cp1=cp;
     a++;
    }

    /* Jetzt die Berechnungen */
    for(a=1;a<spalten;a++)
     {
     Y[a]=parse(feld[a].Formel,feld[a].Name);
     }
    Ausg(aktzeit);
    altzeit=aktzeit;
    memcpy(Z,X,1024*sizeof(double));
    SatzNr++;
    if(Intervall) aktzeit+=Intervall;
    }
   }
  }
 fclose(outfile);
 fclose(infile);
 free(feld);
 times.modtime = src_stat.st_mtime;
 times.actime = time(0);
 if(argc>=4)
 utime(argv[3],&times); /* Zeitstempel Zieldatei setzen */
 else
 utime("temp.csv",&times); /* Zeitstempel Zieldatei setzen */
 if(!umgesetzt)
  {
  printf("Keine Daten umgesetzt!");
  getch();
  }
 return 0;
 }
