#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdlib.h>
#include "rf01.h"
#include "rs232.h"

#define RF01FREQ(freq)	((freq-860.0)/0.005)

unsigned char data[8];

int main(void)
{
	
	uart_init();
	rf01_init();					// ein paar Register setzen (z.B. CLK auf 10MHz)
	rf01_setfreq(RF01FREQ(868.75));	// Sende/Empfangsfrequenz einstellen
	rf01_setreceiver(0,1);			// -6dB Verstrkung, DRSSI threshold: -97dBm 
	rf01_setbaud(1200);				// 1200 Baud
	uart_putc (49);
	uart_putc (46);
	uart_putc (13);
	//uart_putc (10);

	for (;;)
	{	
		
		rf01_rxdata(data, 8);			// 8Bytes empfangen

		uart_putc (data[0]);			// per RS ausgeben
		uart_putc (data[1]);
		uart_putc (data[2]);
		uart_putc (data[3]);
		uart_putc (data[4]);
		uart_putc (data[5]);
		uart_putc (data[6]);
		uart_putc (data[7]);
		uart_putc (13);
	}
}

