#if !defined(GLOBAL_H_)
#define GLOBAL_H_

#include <avr/io.h>
#include <avr/pgmspace.h>
#include <stdint.h>

#define nop() asm volatile ("nop")


//
// PIN DEFINITIONS
//

#define HSYNC_DDR   DDRD
#define HSYNC_PORT  PORTD
#define HSYNC_PIN   PD5                 // OC1A

#define VSYNC_DDR   DDRD
#define VSYNC_PORT  PORTD
#define VSYNC_PIN   PD7                 // OC2A

#define COLOR_DDR	DDRA
#define COLOR_PORT	PORTA

#define SHIFT_PORT  PORTB
#define SHIFT_DDR   DDRB
#define SHIFT_PL    PB3
#define SHIFT_CE    PB4

//
// VGA TIMING
//

// CVT
// mode:        640x400 @ 75Hz
// pixel clock: 25MHz
//
// http://www.vesa.org/Public/CVT/CVTd6r1.xls
//
                                        // unit: characters = PIXELS*8
#define H_FRONT   2                     // front porch
#define H_SYNC    8                     // sync pulse -- NEGATIVE polarity
#define H_BACK    10                    // back porch
#define H_ACTIVE  80                    // active video
#define H_TOTAL   (H_SYNC+H_BACK+H_ACTIVE+H_FRONT)
#define H_CHARS   H_ACTIVE
                                        // unit: LINES
#define V_FRONT   3                     // front porch
#define V_SYNC    6                     // sync pulse -- POSITIVE polarity
#define V_BACK    12                    // back porch
#define V_ACTIVE  400                   // active video
#define V_TOTAL   (V_SYNC+V_BACK+V_ACTIVE+V_FRONT)
#define V_CHARS   (V_ACTIVE/8)


//
// GLOBAL DATA
//

// FONT.C
extern const uint8_t font[256*8] PROGMEM;

// FRAMEBUFFER.C
extern volatile uint8_t framebuf[H_CHARS*V_CHARS];


#endif // GLOBAL_H_
