/* PC KEYBOARD Interface for AVR
 ***********************
 * DATA on PORTD BIT 2 *
 * SCK  on PORTB BIT 0 *
 ***********************
*/

#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include "keyboard.h"
#include "framebuffer.h"
#include "uart.h"

typedef unsigned char const scan_code[2]; // for scancodes.h
#include "scancodes.h"


uint8_t             kb_buffer[KB_BUFF_SIZE];
uint8_t             kb_bufpos;
unsigned char       *inpt, *outpt;
uint8_t             buffcnt;
unsigned char       is_up = 0,
                    shift = 0,
                    funckey = 0,
                    altgr = 0,
                    control = 0;
unsigned char       keys_down[32];


//--------------------------------------
void kbInit(void) {

	unsigned char i;

	inpt =  kb_buffer;                  // Initialize buffer
	outpt = kb_buffer;
	buffcnt = 0;

	for (i = 0; i < 32; i++) {
        keys_down[i]=0;
        }
 
	UCSR1A = 0;
	UCSR1B = (1<<RXEN1);                // Enable receiver
	UCSR1C = (1<<UMSEL10)|(1<<UCSZ11)|(1<<UCSZ10); // sync. mode, no parity, 1 stop bit, sample on falling clock edge

	kb_bufpos = 0;
	shift=0;
    }


//--------------------------------------
void put_kbbuff(unsigned char c) {

    if (control) {
        c &= 0x1f;
        }

    if (buffcnt < KB_BUFF_SIZE) {       // If buffer not full
        *inpt = c;                      // Put character into buffer
        inpt++;                         // Increment pointer
        buffcnt++;
        if (inpt >= (kb_buffer + KB_BUFF_SIZE)) {
            inpt = kb_buffer;
            }
        }
//	uart_putchar(c);
    }


//--------------------------------------
/*
void edit_key(unsigned char x,unsigned char state)
{
	if(state) sbi(keys_down[x>>3],x & 7);
		else cbi(keys_down[x>>3],x & 7);
}
*/


//--------------------------------------
uint8_t decode(unsigned char sc) {

	unsigned char   i;
	uint8_t         decode_complete = 0;

/*
    uart_putchar('<');                   // output scancode for debug
    dump_byte(sc);
    uart_putchar('>');
*/
    if (is_up)    {
        if(sc != 0xE0) {
        	is_up = 0;                         // Two 0xF0 in a row not allowed
       	    }
        funckey = 0;
    	//edit_key(sc,0);
        switch (sc) {
          case 0x12:                    // Left SHIFT
          case 0x59: shift = 0; break;  // Right SHIFT
          case 0x11: altgr = 0; break;  // 
          case 0x14: control=0; break;  // STRG
          }
        }
    else {
        //edit_key(sc,1);
        switch (sc) {
          case 0xF0: is_up = 1; break;  // The up-key identifier
          case 0x12:                    // Left SHIFT
          case 0x59: shift = 1; break;  // Right SHIFT
          case 0x58: shift = !shift; break;  // Caps Lock
          case 0xE0: funckey=1; break;
          case 0x11: altgr = 1; break;
          case 0x14: control=1; break;
          
          default:
            if (funckey) {
            	put_kbbuff(0);
            	put_kbbuff(sc);
            	funckey=0;
                }
            else if (altgr) {
                for(i = 0; pgm_read_byte(&alt_gr[i][0])!=sc && pgm_read_byte(&alt_gr[i][0]); i++);
                if (pgm_read_byte(&alt_gr[i][0]) == sc) {
                    put_kbbuff(pgm_read_byte(&alt_gr[i][1]));
                    }
                }
            else if(!shift) {
                for(i = 0; pgm_read_byte(&unshifted[i][0])!=sc && pgm_read_byte(&unshifted[i][0]); i++);
                if (pgm_read_byte(&unshifted[i][0]) == sc) {
                    put_kbbuff(pgm_read_byte(&unshifted[i][1]));
                    }
                else {
                    put_kbbuff(0); put_kbbuff(sc);
                    }
                }
            else {                    // If shift pressed
                for(i = 0; pgm_read_byte(&shifted[i][0])!=sc && pgm_read_byte(&shifted[i][0]); i++);
                if (pgm_read_byte(&shifted[i][0]) == sc) {
                    put_kbbuff(pgm_read_byte(&shifted[i][1]));
                    }
                else {
                    put_kbbuff(0); put_kbbuff(sc);
                    }
                }
			decode_complete = 1;
              
          }
        }
	if(decode_complete) return 1;
	else return 0;
    }


//--------------------------------------
/*
unsigned char  kbKeyPressed(void)	// returns true if a key is pressed
{
  return (buffcnt!=0);
}
*/


//--------------------------------------
/*
unsigned char  kbReadKey(void)	// returns Ascii code of pressed key, waits until a key is pressed
{
    unsigned char byte;

    while(buffcnt==0);                        // Wait for data

    byte = *outpt;                                // Get byte
    outpt++;                                    // Increment pointer
    if (outpt >= (kb_buffer + KB_BUFF_SIZE)) outpt = kb_buffer;
    buffcnt--;                                    // Decrement buffer count
    return byte;
}
*/


//--------------------------------------
/*
unsigned char  kbKey(unsigned char x)		// returns true if Key x is pressed (scancode)
{
  return bitset(keys_down[x>>3],x & 7);
}
*/
