#include <avr/io.h>
#include <stdint.h>
#include "global.h"
#include "uart.h"

volatile uint8_t uart0_buf[UART0_BUFLEN];
volatile uint8_t uart0_index;


//--------------------------------------
uint8_t uart_putsts(void) {
    return(UCSR0A & (1<<UDRE0));
    }


//--------------------------------------
void uart_putchar(uint8_t c) {
	while(!(UCSR0A & (1<<UDRE0)));
	UDR0 = c;
    }


//--------------------------------------
const char hex[16] PROGMEM = {"0123456789ABCDEF"};


/*--------------------------------------------------------------------*/
void dump_nibble(unsigned char ch) {
    uart_putchar(pgm_read_byte(&hex[ch]));
	}


/*--------------------------------------------------------------------*/
void dump_byte(uint8_t ch) {
	dump_nibble((ch & 0xf0) >> 4);
	dump_nibble(ch & 0x0f);
	}


/*--------------------------------------------------------------------*/
void dump_word(int word) {
	dump_byte((word & 0xff00) >> 8);
	dump_byte(word & 0x00ff);
	}


/*--------------------------------------------------------------------*/
void dump(char *buffer, char cnt) {

	char	i;

	for (i = 0; i < cnt; i++) {
		dump_byte(*buffer++);
		uart_putchar(' ');
		}
	}

