// Emulation eines VT52 Terminals
// Es sind nicht alle Funktionen realisiert
// 09-JAN-2015 DF2AU

#include <avr/io.h>
#include <stdint.h>
#include "global.h"
#include "framebuffer.h"
#include "vt52.h"

// vt STATES
#define VS_CHARACTER    0
#define VS_ESCAPE       1
#define VS_CADDRL       2
#define VS_CADDRC       3

static uint8_t vt_state = VS_CHARACTER;


//--------------------------------------
void vt_putchar(uint8_t c) {
    fb_putchar(c);
    cursor_advance();
    }


//--------------------------------------
void vt_handle_input(uint8_t c) {

    uint8_t     i, j;

    switch(vt_state) {
      case VS_CHARACTER:
        if (c == 27) {
            vt_state = VS_ESCAPE;
            break;
            }
        if (c == '\n') {
            cursor_newline();
            break;
            }
        if (c == '\r') {
        	fb_putchar(c_char);
            cursor_x = 0;
            break;
            }

        vt_putchar(c);
        break;

      case VS_ESCAPE:
        switch (c) {
          case 'A':                     // Cursor up
            vt_state = VS_CHARACTER;
            break;

          case 'B':                     // Cursor down  
            vt_state = VS_CHARACTER;
            break;

          case 'C':                     // Cursor right  
            vt_state = VS_CHARACTER;
            break;

          case 'D':                     // Cursor left  
            vt_state = VS_CHARACTER;
            break;

          case 'H':                     // Cursor Home
            fb_putchar(c_char);  
            cursor_x = cursor_y = 0;
            vt_state = VS_CHARACTER;
            break;

          case 'J':                     // Erase to end of screen  
            for (i = cursor_x; i < H_CHARS; i++) { 
                fb_putchar_xy(i, cursor_y, ' ');
                }            
            for (j = (cursor_y +1); j < V_CHARS; j++) {
                for (i = 0; i < H_CHARS; i++) { 
                    fb_putchar_xy(i, j, ' ');
                    }            
                }
            vt_state = VS_CHARACTER;
            break;

          case 'K':                     // Erase to end of line
            for (i = cursor_x; i < H_CHARS; i++) { 
                fb_putchar_xy(i, cursor_y, ' ');
                }            
            vt_state = VS_CHARACTER;
            break;

          case 'Y':                     // Direct cursor address  
            vt_state = VS_CADDRL;
            break;
            }
        break;

      case VS_CADDRL:
        cursor_y = c - 0x20;
        vt_state = VS_CADDRC;
        break;

      case VS_CADDRC:
        cursor_x = c - 0x20;
        vt_state = VS_CHARACTER;
        break;

      default:
        vt_state = VS_CHARACTER;
        vt_putchar(c);
      }
    }
