#include <Wire.h>
#include <LiquidCrystal_I2C.h>
LiquidCrystal_I2C lcd(0x3F,20,4);

#include <SPI.h>
#include <Mirf.h>
#include <MirfHardwareSpiDriver.h>
#include <MirfSpiDriver.h>
#include <nRF24L01.h>


//RX

//int Sens1[] = {4};
//int Sens2[] = {1011};
float data[3]; 

  
void setup()
{
  Serial.begin(9600);
  lcd.init();    
  lcd.setBacklight(100);
  
  Mirf.spi = &MirfHardwareSpi;
  Mirf.init();
  Mirf.channel = 2;
  Mirf.setRADDR((byte *)"serv0");    //Empfangsadresse
  //Mirf.setTADDR((byte *)"sens1");
  Mirf.payload = sizeof(data);    //Wozu das genau dient ist mir noch unklar?????????
  //Mirf.payload = sizeof(Sens1);
  //Mirf.payload = sizeof(Sens2);
  
  Mirf.config(); //Gesetzte Parameter werden übernommen
}
  
void loop()
{
  Sensor1();  //gehe in Unterprogramm Sensor1
  delay(500);
  Sensor2();  //gehe in Unterprogramm Sensor1
}


void Sensor1(void)
{
  data[0] = 4;
  data[1] = 0;
  data[2] = 0;
  
  Mirf.setTADDR((byte *)"sens1");  //Setze Sendeadresse
  Mirf.send((byte *) &data);       //Sende data[]; data[0] = 4; ist das startzeichen für den Sensor1, dass er Sensorwerte übermitteln soll
  while(Mirf.isSending()){}        //Gesendet...
  Serial.println("Send...");
  Serial.println(data[0]);
  
  while(1){ if(Mirf.dataReady()) break; }  //Unendliche Schleife bis was empfangen wird

  Mirf.setRADDR((byte *)"serv0");  //setze Empfangsadresse
  Mirf.getData((byte *) &data);    //Empfangene Daten in data-Array schreiben
  
  Serial.println("Sensor1:"); 
  Serial.print("Temp: "); Serial.println(data[1]);  //gibt Sensordaten aus Array aus
  Serial.print("Feu:  "); Serial.println(data[2]);
  
  delay(2000);
  data[0] = 0;  //Setze Array auf 0 
  data[1] = 0;
  data[2] = 0;
}

void Sensor2(void)    //Wie bei Unterprogramm sensor1 nur mit Startzeichen 5 für den zweiten Sensor
{
  data[0] = 5,
  data[1] = 0;
  data[2] = 0;
  
  Mirf.setTADDR((byte *)"sens2");
  Mirf.send((byte *) &data);
  while(Mirf.isSending()){}
  Serial.println("Send...");
  Serial.println(data[0]);
  
  while(1){ if(Mirf.dataReady()) break; }

  Mirf.setRADDR((byte *)"serv0");
  Mirf.getData((byte *) &data);
  
  Serial.println("Sensor2:"); 
  Serial.print("Temp: "); Serial.println(data[1]);
  Serial.print("Feu:  "); Serial.println(data[2]);
  
  delay(2000);
  data[0] = 0;
  data[1] = 0;
  data[2] = 0;
}  

