#include <dht11.h>
dht11 DHT11;

#include <SPI.h>
#include <Mirf.h>
#include <MirfHardwareSpiDriver.h>
#include <MirfSpiDriver.h>
#include <nRF24L01.h>

//TX
//die Serial.print aktionen sind nur Tests
//int Sens1[1];
//int x = 101;
float data[3];

void setup()
{
  DHT11.attach(4);
  Serial.begin(9600);
  Mirf.spi = &MirfHardwareSpi;
  Mirf.init();
  Mirf.channel = 2;
  Mirf.setRADDR((byte *)"sens1");    //Empfangsadresse
  Mirf.setTADDR((byte *)"serv0");    //Sendeadresse
  Mirf.payload = sizeof(data);      //auch unklar?????????
  //Mirf.payload = sizeof(Sens1);
  Mirf.config();
}
  
void loop()
{
  while(Mirf.dataReady())      //Warte bis empfangen wird, dann....
  {
    Serial.println("Warte...");      
    Mirf.setRADDR((byte *)"sens1");  //Empfangsadresse
    Mirf.getData((byte *) &data);    //Epfange daten und speichere sie in das Array
    Serial.println(data[0]);  
    
    if(data[0] == 4)  //Wenn Startzeichen gleich 4 ist dann sende daten an Master aller 300ms
    {
      delay(300);
      //data[0] = 7;
      int chk = DHT11.read();
      data[1] = (float)DHT11.temperature;    //Lese Sensordaten in Array
      data[2] = (float)DHT11.humidity;
      Serial.println(data[1]);
      Serial.println(data[2]);
      
      Mirf.setTADDR((byte *)"serv0");  //Setze Sendeadresse
      Mirf.send((byte *) &data);       //Sende daten an Master
      while(Mirf.isSending()){}
      
      data[0] = 0;  //data Array wird auf 0 gesetzt
      data[1] = 0;
      data[2] = 0;
      Serial.println(data[2]);
    }
  }
}




