#include <dht11.h>
dht11 DHT11;

#include <SPI.h>
#include <Mirf.h>
#include <MirfHardwareSpiDriver.h>
#include <MirfSpiDriver.h>
#include <nRF24L01.h>

//TX
int Sens1[1];
int x = 101;
float data[3];

void setup()
{
  DHT11.attach(4);
  Serial.begin(9600);
  Mirf.spi = &MirfHardwareSpi;
  Mirf.init();
  Mirf.channel = 2;
  Mirf.setRADDR((byte *)"sens2");
  Mirf.setTADDR((byte *)"serv0");
  Mirf.payload = sizeof(data);
  //Mirf.payload = sizeof(Sens1);
  Mirf.config();
}
  
void loop()
{
  while(Mirf.dataReady())
  {
    Serial.println("Warte...");
    Mirf.setRADDR((byte *)"sens2");
    Mirf.getData((byte *) &data);
    Serial.println(data[0]);
    
    if(data[0] == 5)
    {
      delay(300);
      data[0] = 8;
      int chk = DHT11.read();
      data[1] = (float)DHT11.temperature;
      data[2] = (float)DHT11.humidity;
      Serial.println(data[1]);
      Serial.println(data[2]);
      
      Mirf.setTADDR((byte *)"serv0");
      Mirf.send((byte *) &data);
      while(Mirf.isSending()){}
      
      data[0] = 0;
      data[1] = 0;
      data[2] = 0;
      Serial.println(data[2]);
    }
  }
}




