; ##############################################################################
; ##############################################################################
; ##############################################################################
ADC_INITIALISIERUNG:
;														
; ADC initialisieren mit "Free Run" und Vorteiler		
;														
; 	ADEN: ADC Enable                             		
; 	ADSC: ADC Start Conversion                   		
; 	ADFR: ADC Free Running Select                		
; 	ADIF: ADC Interrzpt Flag                     		
; 	ADIE: ADC Interrupt Enable                   		
; 	ADPS2: Vorteiler                             		
; 	ADPS2: Vorteiler                             		
; 	ADPS2: Vorteiler                             		
;														
;	ADPS2 ADPS1 ADPS0 Division Factor					
;	0 		0 	0 		2								
;	0 		0 	1 		2								
;	0 		1 	0 		4								
;	0 		1 	1 		8								
;	1 		0 	0 		16								
;	1 		0 	1	 	32								
; 	1 		1 	0 		64								
;	1 		1 	1 		128								
;														
	ldi temp, ((1<<ADEN)|(1<<ADSC)|(1<<ADFR)|(1<<ADPS2)|(1<<ADPS1)|(1<<ADPS0)) 
	out ADCSR, temp
;																					
; ADC REFERENZ																		
;																					
; REFS1 REFS0 Voltage Reference Selection											
;  0     0    AREF, Internal Vref turned off										
; *0     1    AVCC with external capacitor at AREF pin								
;  1     1    Internal 2.56V Voltage Reference with external capacitor at AREF pin	
	ldi temp, (0<<REFS1)|(1<<REFS0)
	out ADMUX, temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 0																		
; 																				
MESSEN_0:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, 0			; KANAL 0	
	out ADMUX, temp
	rcall MESSEN			; OUT: TEMP1 / TEMP2	
	STS(adr_ADC_0_L),temp1	; in SRAM speichern		
	STS(adr_ADC_0_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 1																		
; 																				
MESSEN_1:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -1			; KANAL 1	
	out ADMUX, temp
	rcall MESSEN			; OUT: TEMP1 / TEMP2	
	STS(adr_ADC_1_L),temp1	; in SRAM speichern		
	STS(adr_ADC_1_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 2																		
; 																				
MESSEN_2:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -2			; KANAL 2	
	out ADMUX, temp
	rcall MESSEN			; OUT: TEMP1 / TEMP2	
	STS(adr_ADC_2_L),temp1	; in SRAM speichern		
	STS(adr_ADC_2_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 																				
; Canal 3																		
; 																				
MESSEN_3:
	in temp, ADMUX
	andi temp, 0b11100000
	subi temp, -3			; KANAL 3	
	out ADMUX, temp
	rcall MESSEN			; OUT: TEMP1 / TEMP2	
	STS(adr_ADC_3_L),temp1	; in SRAM speichern		
	STS(adr_ADC_3_H),temp2	; in SRAM speichern		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ADC-WERT 256 mal einlesen und daraus den Mittelwert bilden					
;																				
; OUT: 	TEMP1 (low)  															
;		TEMP2																	
; 																				
MESSEN:
; neuen ADC-Wert lesen	 Wert verwerfen, da meist vom vorherigem ADC-Kanal	
	sbi ADCSRA, ADIF    		; logisch "1" lscht ADIF flag !
MESSEN_w:                  
	sbis ADCSRA, ADIF			; warten bis ADIF flag gesetzt	
	rjmp MESSEN_w
;--------------------------------------------------------------------------
	clr temp1					; HILFSREGISTER CLEAR								
	clr temp2
	ldi temp8,32				; SCHLEIFE initialisieren (32x)		
;--------------------------------------------------------------------------
; neuen ADC-Wert lesen	(Schleife)								
MESSEN_SCHLEIFE:                
	sbi ADCSRA, ADIF    		; logisch "1" lscht ADIF flag !
MESSEN_SCHLEIFE_w:                
	sbis ADCSR, ADIF 			; warten bis ADIF flag gesetzt	
	rjmp MESSEN_SCHLEIFE_w
; ADC einlesen:																
	in  temp3, ADCL 			; immer zuerst LOW Byte lesen				
	in  temp4, ADCH 			; danach das mittlerweile gesperrte High Byte
;  ADC-Werte addieren												
	add temp1,temp3     		; addieren  						
	adc temp2,temp4     		; addieren ber Carry  				
	dec temp8			 		; Schleifenzhler MINUS 1			
	brne MESSEN_SCHLEIFE 		; ==> SCHLEIFE						
; MITTELWERT-BERECHNUNG	(16 addieren)										
	ldi temp,16
	add temp1,temp	     		; addieren  						
	adc temp2,NULL	     		; addieren ber Carry  				
; 	Ergebnis durch 32 teilen												
	LSR temp2	; :2
	ROR temp1
	LSR temp2	; :2
	ROR temp1
	LSR temp2	; :2
	ROR temp1
	LSR temp2	; :2
	ROR temp1
	LSR temp2	; :2
	ROR temp1
; Begrenzung auf 1000														
	cpi temp2,HIGH(1000)	; HIGH	
	brlo MESSEN_BEGRENZUNG_OK
	cpi temp1, LOW(1000)	; LOW	
	brlo MESSEN_BEGRENZUNG_OK
	breq MESSEN_BEGRENZUNG_OK
	; Begrenzung	
	ldi temp1, LOW(1000)
	ldi temp2,HIGH(1000)
MESSEN_BEGRENZUNG_OK:


ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
