; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; LCD 2x16 4x16 4x20 ZEICHEN													
;																				
; LCD-INITIALISIERUNG															
LCD_INITIALISIERUNG:
	; auf LOW				
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	cbi (LCD_EN_PORT),(LCD_EN)
	cbi (LCD_RS_PORT),(LCD_RS)
	; auf Ausgang			
	sbi (LCD_DATA0_DDR),(LCD_DATA0)
	sbi (LCD_DATA1_DDR),(LCD_DATA1)
	sbi (LCD_DATA2_DDR),(LCD_DATA2)
	sbi (LCD_DATA3_DDR),(LCD_DATA3)
	sbi (LCD_RS_DDR),(LCD_RS)
	sbi (LCD_EN_DDR),(LCD_EN)
	; INITIALISIERUNG		
    cbi (LCD_RS_PORT),(LCD_RS) 			; RS aus (low)				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)  	; x03 muss 3mal hintereinander gesendet werden zur Initialisierun
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	rcall LCD_ENABLE					; 1	
	rcall LCD_ENABLE					; 2	
	rcall LCD_ENABLE					; 3	
    ldi temp, 0b00000010        ;4bit-Modus einstellen
	rcall LCD_COMMAND
    ldi temp, 0b00000001        ; DISPLAY lschen			
 	rcall LCD_COMMAND
    ldi temp, 0b00001111        ; DISPLAY ein / CURSOR blinken
	rcall LCD_COMMAND
    ldi temp, 0b00000110        ; Cursor Auto-Increment
 	rcall LCD_COMMAND
	rcall LCD_CLEAR
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; OLED-INITIALISIERUNG															
OLED_INITIALISIERUNG:
	; auf LOW				
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	cbi (LCD_EN_PORT),(LCD_EN)
	cbi (LCD_RS_PORT),(LCD_RS)
	; auf Ausgang			
	sbi (LCD_DATA0_DDR),(LCD_DATA0)
	sbi (LCD_DATA1_DDR),(LCD_DATA1)
	sbi (LCD_DATA2_DDR),(LCD_DATA2)
	sbi (LCD_DATA3_DDR),(LCD_DATA3)
	sbi (LCD_RS_DDR),(LCD_RS)
	sbi (LCD_EN_DDR),(LCD_EN)
;	send_nibble(0x03); //Be sure to	
;	send_nibble(0x03); //be in		
;	send_nibble(0x03); //8-Bit-Mode	
	; INITIALISIERUNG		
    cbi (LCD_RS_PORT),(LCD_RS) 			; RS aus/COMMAND (low)				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)  	; x03 muss 3mal hintereinander gesendet werden zur Initialisierun
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	rcall LCD_ENABLE					; 1	
	rcall wait_1ms
	rcall LCD_ENABLE					; 2	
	rcall wait_1ms
	rcall LCD_ENABLE					; 3	
	rcall wait_1ms
;	send_nibble(0x02); //Switch to 4 Bit										
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	rcall LCD_ENABLE
	rcall wait_1ms
;	WriteIns(0x28);//4-Bit-Mode													
    ldi temp, 0x28
 	rcall LCD_COMMAND
;	WriteIns(0x17);//Character mode and internel power on						
    ldi temp, (0x17)
 	rcall LCD_COMMAND
;	WriteIns(0x06);//entry mode set increment cursor by 1 not shifting display	
    ldi temp, 0x06
 	rcall LCD_COMMAND
;	WriteIns(0x0C); //display on												
    ldi temp, (0x0C)
 	rcall LCD_COMMAND
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																		  		
;erzeugt den Enable-Puls												  		
;																		  		
LCD_ENABLE:
	sbi LCD_EN_PORT, LCD_EN    		   	; Enable high		
 	rcall wait_5us            		  	; kurze PAUSE		
	cbi LCD_EN_PORT, LCD_EN    		  	; Enable low		
	rcall wait_50us            		 	; kurze PAUSE		
ret                          
; ##############################################################################
; ##############################################################################
; ##############################################################################
; sendet ein Datenbyte an das LCD										  		
;																		  		
; INPUT: temp															  		
;																		  		
; rcall LCD_DATA			; DATENBYTE an LCD inp: temp 				  		
;																		  		
LCD_DATA:
	sbi LCD_RS_PORT, LCD_RS 			; RS ein/auf DATA (high)				
LCD_DATA_RS:
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; alle auf LOW							
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,4							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,5
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,6
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,7
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	rcall lcd_enable        			; Enable-Routine aufrufen				
;-------------------------------------------------------------------------------
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; auf LOW								
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,0							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,1
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,2
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,3
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	rcall lcd_enable        			; Enable-Routine aufrufen				
	rcall wait_5us						; Pause 								
	sbi LCD_RS_PORT, LCD_RS 			; vorsichtshalber RS ein/auf DATA (high)
ret				                       
; ##############################################################################
; ##############################################################################
; ##############################################################################
;sendet einen Befehl an das LCD;wie lcd_data, nur ohne RS zu setzen		  		
;																		  		
; INPUT: temp															  		
;																		  		
LCD_COMMAND:                            
    cbi (LCD_RS_PORT),(LCD_RS) 			;	 RS aus (low)				
	rcall LCD_DATA_RS
	rcall wait_5ms						; Pause (wichtig)				
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Display lschen														  		
LCD_CLEAR:
   	ldi temp, 0b00000001
    rcall lcd_command
	rjmp LCD_ZEILE1
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR GO-HOME														  		
LCD_ZEILE1:
 	ldi temp, 0b00000010
	rjmp lcd_command 
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE2												  		
LCD_ZEILE2:
 	ldi temp, 0b11000000 
	rjmp lcd_command 
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE3														
LCD_ZEILE3:
	ldi temp, 0b10010000 	; LCD 4x16	
;	ldi temp, 0b10010100  	; LCD 4x20	
	rjmp lcd_command 
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE4												  		
LCD_ZEILE4:
	ldi temp, 0b11010000 	; LCD 4x16	
	;ldi temp, 0b11010100	; LCD 4x20	
	rjmp lcd_command 
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1															  		
ANZEIGE_1_STELLEN_HEX_ASC_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rjmp LCD_AUSGABE_ZAHL_1_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_2_STELLEN_HEX_ASC_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rjmp LCD_AUSGABE_ZAHL_2_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_3_STELLEN_HEX_ASC_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rjmp LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2																	
ANZEIGE_3_STELLEN_HEX_ASC_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rjmp LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2																	
ANZEIGE_4_STELLEN_HEX_ASC_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rjmp LCD_AUSGABE_ZAHL_4_STELLEN_KURZ
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2																	
ANZEIGE_5_STELLEN_HEX_ASC_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rjmp LCD_AUSGABE_ZAHL_5_STELLEN_KURZ
;######################################################################## 	
;######################################################################## 	
;######################################################################## 	
; INPUT: TEMP1...TEMP9 (temp)												
LCD_AUSGABE_ZAHL_10_STELLEN_KURZ:
	; temp !
	rcall LCD_DATA			; 10.ZEICHEN 	
LCD_AUSGABE_ZAHL_9_STELLEN_KURZ:
	mov temp, temp9			; 9.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_8_STELLEN_KURZ:
	mov temp, temp8			; 8.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_7_STELLEN_KURZ:
	mov temp, temp7			; 7.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_6_STELLEN_KURZ:
	mov temp, temp6			; 6.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_5_STELLEN_KURZ:
	mov temp, temp5			; 5.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_4_STELLEN_KURZ:
	mov temp, temp4			; 4.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_3_STELLEN_KURZ:
	mov temp, temp3			; 3.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_2_STELLEN_KURZ:
	mov temp, temp2			; 2.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_1_STELLEN_KURZ:
	mov temp, temp1			; 1.ZEICHEN (1-er Stelle)	
	rcall LCD_DATA
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
; STAND: 09.12.2011															
;																			
;	Value: 0...	9.999.999.999												
;																			
;	INPUT: 	temp1	(BYTE1)													
;	 		temp2	(BYTE2)													
;			temp3	(BYTE3)													
;			temp4	(BYTE4)													
;																			
;	OUTPUT:	temp1	(		     1-er Stelle)								
;			temp2	(		    10-er Stelle)								
;			temp3	(          100-er Stelle)								
;			temp4	(        1.000-er Stelle)								
;			temp5	(       10.000-er Stelle)								
;			temp6	(      100.000-er Stelle)								
;			temp7	(    1.000.000-er Stelle)								
;			temp8	(   10.000.000-er Stelle)								
;			temp9	(  100.000.000-er Stelle)								
;			temp	(1.000.000.000-er Stelle)								
; 																			
FUNKTION_HEX_ASC_32:
;---------------------------------------------------------------------------
	clr temp			
FUNKTION_HEX_ASC_109:	; 1.100.000.000
	inc temp
	subi temp1, BYTE1    (1000000000)
	sbci temp2, BYTE2    (1000000000)
	sbci temp3, BYTE3    (1000000000)
	sbci temp4, BYTE4    (1000000000)
	brcc FUNKTION_HEX_ASC_109
	subi temp, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000000)
	sbci temp2, BYTE2   (-1000000000)
	sbci temp3, BYTE3   (-1000000000)
	sbci temp4, BYTE4   (-1000000000)
;---------------------------------------------------------------------------
	clr temp9			
FUNKTION_HEX_ASC_108:	; 100.000.000
	inc temp9
	subi temp1, BYTE1    (100000000)
	sbci temp2, BYTE2    (100000000)
	sbci temp3, BYTE3    (100000000)
	sbci temp4, BYTE4    (100000000)
	brcc FUNKTION_HEX_ASC_108
	subi temp9, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000000)
	sbci temp2, BYTE2   (-100000000)
	sbci temp3, BYTE3   (-100000000)
	sbci temp4, BYTE4   (-100000000)
;---------------------------------------------------------------------------
	clr temp8
FUNKTION_HEX_ASC_107:	; 10.000.000
	inc temp8
	subi temp1, BYTE1    (10000000)
	sbci temp2, BYTE2    (10000000)
	sbci temp3, BYTE3    (10000000)
	sbci temp4, BYTE4    (10000000)
	brcc FUNKTION_HEX_ASC_107
	subi temp8, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-10000000)
	sbci temp2, BYTE2   (-10000000)
	sbci temp3, BYTE3   (-10000000)
	sbci temp4, BYTE4   (-10000000)
;---------------------------------------------------------------------------
	clr temp7
FUNKTION_HEX_ASC_106:	; 1.000.000
	inc temp7
	subi temp1, BYTE1    (1000000)
	sbci temp2, BYTE2    (1000000)
	sbci temp3, BYTE3    (1000000)
	brcc FUNKTION_HEX_ASC_106
	subi temp7, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000)
	sbci temp2, BYTE2   (-1000000)
	sbci temp3, BYTE3   (-1000000)
;---------------------------------------------------------------------------
	clr temp6
FUNKTION_HEX_ASC_105:	; 100.000	
	inc temp6
	subi temp1, BYTE1    (100000)
	sbci temp2, BYTE2    (100000)
	sbci temp3, BYTE3    (100000)
	brcc FUNKTION_HEX_ASC_105
	subi temp6, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000)
	sbci temp2, BYTE2   (-100000)
	sbci temp3, BYTE3   (-100000)
;---------------------------------------------------------------------------	clr temp
	clr temp5
FUNKTION_HEX_ASC_104:	; 10.000	
	inc temp5
	subi temp1, BYTE1    (10000)
	sbci temp2, BYTE2    (10000)
	sbci temp3, BYTE3    (10000)
	brcc FUNKTION_HEX_ASC_104
	subi temp5, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1  (-10000)
	sbci temp2, BYTE2  (-10000)
	sbci temp3, BYTE3  (-10000)
;---------------------------------------------------------------------------
	clr temp4
FUNKTION_HEX_ASC_103:	; 1.000		
	inc temp4
	subi temp1, low  (1000)
	sbci temp2, HIGH (1000)
	brcc FUNKTION_HEX_ASC_103
	subi temp4, (-48+1)	; HEX->ASC	
	subi temp1, low  (-1000)
	sbci temp2, HIGH (-1000)
;---------------------------------------------------------------------------
	clr temp3
FUNKTION_HEX_ASC_102:	; 100		
	inc temp3
	subi temp1, low  (100)
	sbci temp2, HIGH (100)
	brcc FUNKTION_HEX_ASC_102
	subi temp3, (-48+1)	; HEX->ASC	
	subi temp1, low  (-100)
	sbci temp2, HIGH (-100)
;---------------------------------------------------------------------------
	clr temp2
FUNKTION_HEX_ASC_101:	; 10		
	inc temp2
	subi temp1, low  (10)
	brcc FUNKTION_HEX_ASC_101
	subi temp2, (-48+1)	; HEX->ASC	
	subi temp1, low  (-10)
;---------------------------------------------------------------------------
FUNKTION_HEX_ASC_100:	; 1			
	subi temp1, -48		; HEX->ASC	
ret
;######################################################################## 
;########################################################################
;######################################################################## 
ANZEIGE_TEXT:
	LPM temp, Z+   			; aus Tabelle laden und Zeiger um 1 erhhen	
	tst temp  			
	brne ANZEIGE_TEXT_w
	ret
ANZEIGE_TEXT_w:
	rcall LCD_DATA			; Anzeige
	rjmp ANZEIGE_TEXT
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_SPACE:
	ldi temp, ' '		; SPACE
	rjmp LCD_DATA	
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_PUNKT:
	ldi temp, '.'		; PUNKT
	rjmp LCD_DATA	
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_3_PUNKT:
	ldi temp, '.'		; PUNKT
	rcall LCD_DATA	
	rcall LCD_DATA	
	rjmp LCD_DATA	
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_DOPPEL_PUNKT:
	ldi temp, ':'		; DOPPELPUNKT
	rjmp LCD_DATA	
;######################################################################## 
;######################################################################## 
;######################################################################## 
