; ##############################################################################
; ##############################################################################
; ##############################################################################
WDR_INITIALISIERUNG:
; Watchdog aktivieren (max. Zeit)					
	ldi TEMP,(1<<WDCE)|(1<<WDE)  
	out wdtcr,TEMP       
	ldi TEMP,(1<<WDE) | (1<<WDP2)|(1<<WDP1)|(1<<WDP0) 
	out wdtcr,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
NEUSTART_MIT_WDR:
	WDR
	in temp, MCUCSR
	andi temp,0b00001000
	tst temp
	breq NEUSTART_MIT_WDR_FEHLER
	; MCUCSR clear		
	out MCUCSR,NULL
	ret
NEUSTART_MIT_WDR_FEHLER:
	rjmp NEUSTART_MIT_WDR_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
SRAM_CLEAR:
	ldi ZL, LOW (SRAM_START)
	ldi ZH, HIGH(SRAM_START)
	ldi temp,0
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	breq SRAM_CLEAR_w		; gleich  => SPRUNG	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_CHECK:
	; NULL		
	tst NULL
	brne PROGRAMM_CHECK_FEHLER
	; EINS		
	mov temp,EINS
	cpi temp,1
	brne PROGRAMM_CHECK_FEHLER
	; VOLL		
	mov temp,VOLL
	cpi temp,255
	brne PROGRAMM_CHECK_FEHLER
	; SRAM CHECK
	LDS temp,(adr_SRAM_CHECK)
	cpi temp,'S'
	brne PROGRAMM_CHECK_FEHLER
	ret
;-------------------------------------------------------------------------------
; SCHLEIFE																		
PROGRAMM_CHECK_FEHLER:
	rcall wait_100ms
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	rcall wait_100ms
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	rjmp PROGRAMM_CHECK_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_INITIALISIERUNG:
	; auf AUSGANG								
	sbi (LED_GRUEN_DDR),(LED_GRUEN_PIN_NR)		; GRN		
	sbi (LED_GELB_DDR) ,(LED_GELB_PIN_NR)		; GELB		
	sbi (LED_ROT_DDR)  ,(LED_ROT_PIN_NR)		; ROT		
	; LEDs an									
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_TEST:
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB aus	
	sbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  aus	

	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an   
	rcall wait_100ms
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	rcall wait_100ms
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
	rcall wait_100ms

	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB aus	
	sbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
