;												
; TOUCH-SCREEN mit ATmega8						
; Bernhard.Erfurt@gmx.de						
; 15.01/2015									
;												
; Bei Bedarf: LCD 2x16 oder 4x16				
;												

;												
; Anschlussbelegung PINS						
;												
; PB0 ==> LCD									
; PB1 ==> LCD									
; PB2 ==> LCD									
; PB3 ==> LCD									
; PB4 ==> LCD R/S								
; PB5 ==> LCD E									
; PB6 ==> (Quarz)								
; PB7 ==> (Quarz)								
;												
; PC0 ==> ADC0(Y+)								
; PC1 ==> ADC1(X+)								
; PC2 ==> ADC2(Y-)								
; PC3 ==> ADC3(Y+)								
; PC4 ==> TWI-DATA								
; PC5 ==> TWI-SCL								
;												
; PD0 ==> 										
; PD1 ==> 										
; PD2 ==> 										
; PD3 ==> 										
; PD4 ==> 										
; PD5 ==> LED GRN								
; PD6 ==> LED GELB + BEEP						
; PD7 ==> LED ROT								
;												


; ATmega8 										
.include "m8def.inc"
; KONSTANTEN									
.equ TAKT							=1000000	; 1 MHz	
; TOUCH											
.equ TOUCH_ENTPRELLZEIT_ANTIPPEN	=35 		;(1=1ms)
.equ TOUCH_ENTPRELLZEIT_LOSLASSEN	=100 		;(1=1ms)

; TOUCH(Y+)										
.equ TOUCH_YP_PIN_NR				= 0
.equ TOUCH_YP_DDR					= DDRC
.equ TOUCH_YP_PORT					= PORTC
.equ TOUCH_YP_PIN					= PINC
; TOUCH(X+)										
.equ TOUCH_XP_PIN_NR				= 1
.equ TOUCH_XP_DDR					= DDRC
.equ TOUCH_XP_PORT					= PORTC
.equ TOUCH_XP_PIN					= PINC
; TOUCH(Y-)										
.equ TOUCH_YN_PIN_NR				= 2
.equ TOUCH_YN_DDR					= DDRC
.equ TOUCH_YN_PORT					= PORTC
.equ TOUCH_YN_PIN					= PINC
; TOUCH(X-)										
.equ TOUCH_XN_PIN_NR				= 3
.equ TOUCH_XN_DDR					= DDRC
.equ TOUCH_XN_PORT					= PORTC
.equ TOUCH_XN_PIN					= PINC
; LED-GRUEN										
.equ LED_GRUEN_PIN_NR				= 5
.equ LED_GRUEN_DDR					= DDRD
.equ LED_GRUEN_PORT					= PORTD
; LED-GELB										
.equ LED_GELB_PIN_NR				= 6
.equ LED_GELB_DDR					= DDRD
.equ LED_GELB_PORT					= PORTD
; LED-ROT										
.equ LED_ROT_PIN_NR					= 7
.equ LED_ROT_DDR					= DDRD
.equ LED_ROT_PORT					= PORTD
; LCD (DATA)									
.equ LCD_DATA0_DDR					= DDRB
.equ LCD_DATA1_DDR					= DDRB
.equ LCD_DATA2_DDR					= DDRB
.equ LCD_DATA3_DDR					= DDRB
.equ LCD_DATA0_PORT					= PORTB
.equ LCD_DATA1_PORT					= PORTB
.equ LCD_DATA2_PORT					= PORTB
.equ LCD_DATA3_PORT					= PORTB
.equ LCD_DATA0						= 0
.equ LCD_DATA1						= 1
.equ LCD_DATA2						= 2
.equ LCD_DATA3						= 3
; LCD RS (Befehl/DATEN)							
.equ LCD_RS_DDR						= DDRB
.equ LCD_RS_PORT					= PORTB
.equ LCD_RS							= 4
; LCD_ENABLE									
.equ LCD_EN_DDR						= DDRB
.equ LCD_EN_PORT					= PORTB
.equ LCD_EN							= 5
; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN						=SRAM_START		; 0x0060 START Adresse 		


.equ adr_ERROR_CODE					=SRAM_START+4		; ERROR CODE vom ersten auftretenden Fehler		



.equ adr_ADC_0_L					=SRAM_START+50
.equ adr_ADC_0_H					=SRAM_START+51
.equ adr_ADC_1_L					=SRAM_START+52
.equ adr_ADC_1_H					=SRAM_START+53
.equ adr_ADC_2_L					=SRAM_START+54
.equ adr_ADC_2_H					=SRAM_START+55
.equ adr_ADC_3_L					=SRAM_START+56
.equ adr_ADC_3_H					=SRAM_START+57


.equ adr_SRAM_CHECK					=SRAM_START+943	; SRAM CHECK muss immer "S" sein	
; REGISTER										

.def DUMMY_R0	= R0	; wichtige Hilfsregister (nicht verwenden !)
.def DUMMY_R1	= R1	; wichtige Hilfsregister (nicht verwenden !)

.def NULL 	= R12
.def EINS 	= R14
.def VOLL	= R15

.def temp 	= R16
.def temp1 	= R17
.def temp2 	= R18
.def temp3 	= R19
.def temp4 	= R20
.def temp5 	= R21
.def temp6 	= R22
.def temp7 	= R23
.def temp8 	= R24
.def temp9 	= R25





.cseg					;Beginn eines Code-Segmentes
.org 0					;Startadresse=0

rjmp RESET      		; Reset Handler                           				
rjmp INTERRUPT_ERROR	;rjmp EXT_INT0   ; IRQ0 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_OVF   	  	; Timer1 Overflow Handler       
rjmp INTERRUPT_ERROR	;rjmp TIM0_OVF   ; Timer0 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp INTERRUPT_ERROR	;rjmp ZEICHEN_EINLESEN 	; USART RX Complete Handler     
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp INTERRUPT_ERROR	;rjmp TWSI       ; Two-wire Serial Interface Handler 	
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Unkorrekten Interrupt Aufruf 						
INTERRUPT_ERROR:
	cbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB an	
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	rcall wait_100ms
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus  
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	rcall wait_100ms
	rjmp INTERRUPT_ERROR

RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; SRAM lschen										
	rcall SRAM_CLEAR
; PORT B initialisieren								
	ldi temp, 0b00000000	; 
	out DDRB, temp
; PORT B setzen										
	ldi temp, 0b00000000	; 
	out PORTB, temp				
; PORT C initialisieren								
	ldi temp, 0b00000000	; 
	out DDRC, temp
; PORT C setzen										
	ldi temp, 0b00000000	; 
	out PORTC, temp				
; PORT D initialisieren								
	ldi temp, 0b00000000	; 
	out DDRD, temp
; PORT D setzen										
	ldi temp, 0b00000000	; 
	out PORTD, temp				
; LED_INITIALISIERUNG								
	rcall LED_INITIALISIERUNG
; WDR_INITIALISIERUNG								
	rcall WDR_INITIALISIERUNG
; NEUSTART_MIT_WDR									
	rcall NEUSTART_MIT_WDR
; LED-TEST											
	rcall LED_TEST
; TOUCH_INITIALISIERUNG								
	rcall TOUCH_INITIALISIERUNG
; ADC_INITIALISIERUNG								
	rcall ADC_INITIALISIERUNG
; TOUCH_STANDBY_MODUS								
	rcall TOUCH_STANDBY_MODUS
; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
	; VOLL				
	ldi temp,255
	mov VOLL,temp
	; SRAM CHECK		
	ldi temp,'S'
	STS(adr_SRAM_CHECK),temp
; LCD-INITIALISIERUNG								
	rcall LCD_INITIALISIERUNG
; ANZEIGE_BEGRUESSUNG								
	rcall ANZEIGE_BEGRUESSUNG
	rcall WAIT_100ms
	rcall WAIT_100ms
	rcall WAIT_100ms
	rcall ANZEIGE_WAIT
; 	PROGRAMM_CHECK									
	rcall PROGRAMM_CHECK
; Interrupts freigeben								
	sei
	cbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN an   

; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	WDR										; Watch-Dog-RESET	
	; LOOP, bis Y+ gegen GND gezogen wird
	sbic (TOUCH_YP_PIN),(TOUCH_YP_PIN_NR)
	rjmp LOOP
;-------------------------------------------------------------------------------
	rcall TOUCH_MESSUNG
	rcall ANZEIGE_ERROR_CODE
	rcall PROGRAMM_CHECK
rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "TOUCH_TOUCH.asm"				; TOUCH							
.include "TOUCH_ADC.asm"				; ADC							
.include "TOUCH_LCD.asm"				; LCD allgemein					
.include "TOUCH_LCD_ini.asm"			; LCD  Initialisierung 2/4x16/20
.include "TOUCH_SONSTIGES.asm"			; sonstiges						
.include "TOUCH_WAIT_01MHZ.asm"			;  1 MHz						
;.include "TOUCH_WAIT_08MHZ.asm"		;  8 MHz						
;.include "TOUCH_WAIT_16MHZ.asm"		; 16 MHz						
; ##############################################################################
; ##############################################################################
; ##############################################################################

TEXT_BEGRUESSUNG_1:
.db "ATmega8",0
TEXT_BEGRUESSUNG_2:
.db "TOUCHSCREEN",0
TEXT_BEGRUESSUNG_3:
.db "V1 01/2015 ",0
TEXT_BEGRUESSUNG_4:
.db "TWI + 4-WIRE ",0




