#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/pgmspace.h>
#include <avr/eeprom.h>
#include <stdlib.h>
#include "global.h"
#include "uart.h"
#include "rf12.h"     

#define F_CPU 8000000UL

#define LED1_OFF() PORTD&=~(1<<PD5)
#define LED1_ON() PORTD|= (1<<PD5)
#define LED1_TOG() PORTD^= (1<<PD5)

#define LED2_OFF() PORTD&=~(1<<PD6)
#define LED2_ON() PORTD|= (1<<PD6)
#define LED2_TOG() PORTD^= (1<<PD6)

#define  Taster1 		PD3
#define  Taster2 		PD4


#include <util/delay.h>

void send(void);
void receive(void);

int main(void)
{
	// LEds	
	DDRD|=((1<<PD6)|(1<<PD5));
	// Pull ups fr Taster
	PORTD|=((1<<Taster1)|(1<<Taster2));

    uart_init(UART_BAUD_SELECT(19200, F_CPU));
	rf12_init();					// ein paar Register setzen (z.B. CLK auf 10MHz)
	
	rf12_setfreq(RF12FREQ(868.3));	// Sende/Empfangsfrequenz auf 868,92MHz einstellen 1784=868.92 
	rf12_setbandwidth(4, 1, 4);		// 200kHz Bandbreite, -6dB Verstrkung, DRSSI threshold: -79dBm 
	rf12_setbaud(19200);			// 19200 baud
	rf12_setpower(0, 6);			// 1mW Ausgangangsleistung, 120kHz Frequenzshift

	sei();
	uart_puts_P("Empfaenger laeuft !\n\r");
    uint16_t freq=1747; // Startwert fr Frequenzlauf 
	rf12_trans(0xA000|freq);
	//char 	sst[] = "          ";

	for (;;)
		{
	//	while (!(PIND&(1<<Taster1))) //Wenn Taster 1 gedrckt wird
	//		{
	//	
	//		LED2_TOG();			 				
	//		}
	//		
	//	rf12_trans(0xA000|freq);
	//	ltoa(freq, sst, 10);
	//	uart_puts(sst);
	//	uart_puts_P("\n\r");

	//	freq++;
	//	if (freq> 1751)
	//		freq=1745;	
		receive();
		LED1_TOG();
		}
}

void receive(void)
{	unsigned char test[32];	
	rf12_rxdata(test,32);	
	for (unsigned char i=0; i<32; i++)
		uart_putc(test[i]);
	uart_puts_P("\n\r");
		

}

void send(void)
{	unsigned char test[]="Dies ist ein 433MHz Test !!!\n   ";	
	rf12_txdata(test,32);
}

