#include "midi.h"
#include <avr/interrupt.h>
#include <avr/io.h>
/* ****************************** */
/* Midi uart for ATMEGA8 and 16 * */
/* ****************************** */


#ifndef F_CPU
/* Warning if F_CPU isnt defined in AVR Studio Options or in makefile */
#warning "F_CPU F_CPU not defined, using default 1MHz"
#define F_CPU 1000000UL  // F_CPU in Hz - definition as unsigned long 
#endif
 
#define BAUD 31250UL      // std midi baud rate
#include <util/setbaud.h>

/* Midi uart teste only for program change events, for guitar footcontrols */
void initMidiUart(unsigned char receiveOnly )   
{
   midiEnabled = 0;
   UBRRH = UBRRH_VALUE;
   UBRRL = UBRRL_VALUE;
   /* evtl. verkuerzt falls Register aufeinanderfolgen (vgl. Datenblatt)
      UBRR = UBRR_VALUE;
   */
#if USE_2X // U2X-Modus 
   UCSRA |= (1 << U2X);
#else   // Non U2X-Modus -> setbaud.h
   UCSRA &= ~(1 << U2X);
#endif
 //	if (receiveOnly) UCSRB = (( 1 << RXCIE ) | ( 1 << RXEN ) ); 
//	else UCSRB = (( 1 << RXCIE ) | ( 1 << RXEN ) | ( 1 << TXEN ));   //For ARTMEGA8 and 16
	enableIRQ(receiveOnly );
	UCSRC = (1<<URSEL)|(1<<UCSZ1)|(1<<UCSZ0); // Asynchron 8N1       
	
	//init global variables
	UART_RxTail = 0;
	UART_RxHead = 0;
	UART_TxTail = 0;
	UART_TxHead = 0;            
}
/* not testet so far */
void enableIRQ(unsigned char receiveOnly )
{
	if (midiEnabled == 1) return;
	if (receiveOnly) UCSRB = (( 1 << RXCIE ) | ( 1 << RXEN ) ); 
	else UCSRB = (( 1 << RXCIE ) | ( 1 << RXEN ) | ( 1 << TXEN )); 
	midiEnabled = 1;
}
/* not testet so far */
void disableIRQ()
{	
	if (midiEnabled == 0) return;
	UCSRB &= ~( ( 1 << RXCIE ) |  (1<<RXEN) | (1<<RXCIE) | ( 1 << TXEN ));
	midiEnabled = 0;
}
unsigned char readByte( void )
{
	unsigned char newTail;
 
    newTail = (UART_RxTail + 1) & UART_RX_BUFFER_MASK;
    UART_RxTail = newTail; 
 
    return UART_RxBuf[newTail];// return buffer byte
}
void writeByte( unsigned char byte ){
 
	unsigned char newHead; 
 
    newHead  = (UART_TxHead + 1) & UART_TX_BUFFER_MASK;
 
    while ( newHead == UART_TxTail ) {
        ;// wait for free space in buffer 
    }
 
    UART_TxBuf[newHead] = byte;
    UART_TxHead = newHead;

	UCSRB |= (1<<UDRIE); // Disable IRQ for ATMEGA8 and 16                 
} 

void writeString(const char *string )
{
    while (*string) writeByte(*string++); 
}

unsigned char bytesAvailable( void )
{
    // Return 0 (FALSE) if the receive buffer is empty 
	return ( UART_RxHead != UART_RxTail ); 
}
// Receiver IRQ 
SIGNAL(SIG_UART_RECV)         
{
	unsigned char byte;
	unsigned char newHead;
 
	byte = UDR;//read received byte
 
	/* Calculate buffer index */
	newHead = ( UART_RxHead + 1 ) & UART_RX_BUFFER_MASK;
 
	if ( newHead == UART_RxTail ) {
		//unhandled buffer overflow error
	}
	else {
        UART_RxHead = newHead; //new head
        UART_RxBuf[newHead] = byte; //append the read byte
    } 
}
// Sender IRQ 
SIGNAL(SIG_UART_DATA)   
{
	unsigned char newTail;
 
	/* Check if all data is transmitted */
	if ( UART_TxHead != UART_TxTail ){
		newTail = ( UART_TxTail + 1 ) & UART_TX_BUFFER_MASK;// new Tail
		UART_TxTail = newTail;      /* Store new index */
 
		UDR = UART_TxBuf[newTail];  //send the byte
	}
	else {      		
		UCSRB &= ~(1<<UDRIE);// Enable IRQ for ATMEGA8 and 16          
	}
}
