#ifndef MIDI_H
#define MIDI_H

/* UART Buffer Defines */
#define UART_RX_BUFFER_SIZE 32     /* 2,4,8,16,32,64,128 or 256 bytes */
#define UART_TX_BUFFER_SIZE 32     /* 2,4,8,16,32,64,128 or 256 bytes */
#define UART_RX_BUFFER_MASK ( UART_RX_BUFFER_SIZE - 1 )
#define UART_TX_BUFFER_MASK ( UART_TX_BUFFER_SIZE - 1 )
#if ( UART_RX_BUFFER_SIZE & UART_RX_BUFFER_MASK )
	#error RX buffer size is not a power of 2
#endif
#if ( UART_TX_BUFFER_SIZE & UART_TX_BUFFER_MASK )
	#error TX buffer size is not a power of 2
#endif

/* some midi defines */
/* compare with bit mask (byte & 0xF0) == MIDI_X... */
#define MIDI_PROG_CHANGE 0xC0
#define MIDI_NOTE_ON     0x90
#define MIDI_NOTE_OFF    0x80
#define MIDI_AFTERTOUCH  0xA0
#define MIDI_CC          0xB0
#define MIDI_PROG_CHANGE 0xC0
#define MIDI_CHAN_PRESS  0xD0
#define MIDI_PITCH_WHEEL 0xE0


static volatile unsigned char UART_TxBuf[UART_TX_BUFFER_SIZE];
static volatile unsigned char UART_RxBuf[UART_RX_BUFFER_SIZE];
static volatile unsigned char UART_TxHead;
static volatile unsigned char UART_TxTail;
static volatile unsigned char UART_RxHead;
static volatile unsigned char UART_RxTail;

static volatile unsigned char midiEnabled;




void initMidiUart(unsigned char receiveOnly ) ;
void enableIRQ(unsigned char receiveOnly );
void disableIRQ();
unsigned char readByte( void );
void writeByte( unsigned char byte );
void writeString(const char *string );
unsigned char bytesAvailable( void );



#endif
