#include "switch.h"
//#include <avr/io.h>

#include <util/delay.h>

#define SWITCH_LOW 0
#define SWITCH_HIGH 1

/* little switch helper, special for guitar amps with switches and no pushbuttons
switches can act like pushbottons, special fo my setup
no warranty of course :-) */

void initSwitch()
{
	portd_released = 0x00;
	portb_released = 0x00;
	/* set all pushbuttons to released
	switches will be set to its actual state
	this way pushbuttons and switches are possible */
	for (uint8_t i = 0; i < 8 ; i++){
		if ( ! (PIND & (1 << i)) ) setPressed_d(i);

		if ( ! (PINB & (1 << i)) ) setPressed_b(i);

		/* init toggle states, set all to 0 */
		portd_toggleState &= ~(1<<i);
		portb_toggleState &= ~(1<<i);
	}
/*
	for (uint8_t i = 0; i < 8 ; i++){
		if ( ! (PINB & (1 << i)) ) setPressed_b(i);
	}

	
	for (uint8_t i = 0; i < 8 ; i++){
		if ( ! (PINB & (1 << i)) ) setPressed_b(i);
		PORTC &= ~(1<<PC3);//turn off
	}

	for (uint8_t i = 0; i < 8 ; i++){
		if ( ! (PINB & (1 << i)) ) setPressed_b(i);
	}
	*/
}

/* PORT D INPUTS */
/* pushButtons shall return true only on toggle, if the button is held, it will return false */
/* switches will work then like pushButtons */
/* debounce shall only happen on toggle */
uint8_t pushBtn_d( uint8_t pin) 
{
	if ( ! (PIND & (1 << pin)) ) {
		if (isReleased_d( pin) ) {
			setPressed_d(pin);
			_delay_ms(50);//debounce press
			return  1;//switch on low
		}		
	}
	else if (!isReleased_d( pin)) {
		setReleased_d(pin);
		_delay_ms(50);	//debounce release	
	}
	return  0;
}
/* switches shall return its real state and are beeing debounced on state change only */
uint8_t switchBtn_d( uint8_t pin) 
{
	if ( ! (PIND & (1 << pin)) ) {
		if (isReleased_d( pin) ) {
			setPressed_d(pin);
			_delay_ms(50);//debounce press
		}
		return  1; //return tru as long as it is low
	}
	else if (!isReleased_d( pin)) {
		setReleased_d(pin);
		_delay_ms(50);	//debounce release	
	}
	return  0;
}
/* this function returns its toggled state */
/* pushbouttons once pressed will return true until next press */
uint8_t toggleBtn_d( uint8_t pin)
{
	if ( ! (PIND & (1 << pin)) ) {
		if (isReleased_d( pin) ) {
			setPressed_d(pin);
			_delay_ms(50);//debounce press
			portd_toggleState ^= (1 << pin);
		}
	}
	else if (!isReleased_d( pin)) {
		setReleased_d(pin);
		_delay_ms(50);	//debounce release	
	}
	return  (portd_toggleState & (1 << pin)) ;
}
void setReleased_d(uint8_t pin)
{
	portd_released &= ~(1<<pin);
}
void setPressed_d(uint8_t pin)
{
	portd_released |= (1<<pin);
}
uint8_t isReleased_d(uint8_t pin)
{
	return !(portd_released & (1 << pin));
}
/* PORT B INPUTS */
uint8_t pushBtn_b( uint8_t pin) 
{
	if ( ! (PINB & (1 << pin)) ) {
		if (isReleased_b( pin) ) {
			setPressed_b(pin);
			_delay_ms(50);//debounce press
			return  1;//switch on low
		}		
	}
	else if (!isReleased_b( pin)) {
		setReleased_b(pin);
		_delay_ms(50);	//debounce release	
	}
	return  0;
}
uint8_t switchBtn_b( uint8_t pin) 
{
	if ( ! (PINB & (1 << pin)) ) {
		if (isReleased_b( pin) ) {
			setPressed_b(pin);
			_delay_ms(50);//debounce press
		}
		return  1;		
	}
	else if (!isReleased_b( pin)) {
		setReleased_b(pin);
		_delay_ms(50);	//debounce release	
	}
	return  0;
}
uint8_t toggleBtn_b( uint8_t pin)
{
	if ( ! (PINB & (1 << pin)) ) {
		if (isReleased_b( pin) ) {
			setPressed_b(pin);
			_delay_ms(50);//debounce press
			portb_toggleState ^= (1 << pin);
		}
	}
	else if (!isReleased_b( pin)) {
		setReleased_b(pin);
		_delay_ms(50);	//debounce release	
	}
	return  (portb_toggleState & (1 << pin)) ;
}
void setReleased_b(uint8_t pin)
{
	portb_released &= ~(1<<pin);
}
void setPressed_b(uint8_t pin)
{
	portb_released |= (1<<pin);
}
uint8_t isReleased_b(uint8_t pin)
{
	return !(portb_released & (1 << pin));
}
/* setState gives a button state independend its real state */
void setState(uint8_t port, int8_t pin,int8_t value)
{
	if ( port == PINB) {
		if (value) portb_toggleState |= (1<<pin);
		else portb_toggleState &= ~(1<<pin);
		setReleased_b( pin);
	}
	else if ( port == PIND) {
		if (value) portd_toggleState |= (1<<pin);
		else portd_toggleState &= ~(1<<pin);
		setReleased_d( pin);
	}
}
