;minolta infrarot fernbedienung mit zeitraffer v2.0 (mai 2007) Alex S.
.include "tn13def.inc"
rjmp start
.org 0006 rjmp timer0uberlauf ;timer0berlauf interrupt

;registerbedeutung:
;r16 = hilfsregister fr alles mgliche
;r18 = portb1_portb2_flipflop (ir leds) (0=aus  1=an)
;r19 = 38095Hz an aus (bit0=0=an  bit0=1=aus) eigentlich sollen es 38000Hz sein aber es geht auch so
;r21 = data low  &  zeitrafferlnge low
;r22 = data high  &  zeitrafferlnge high
;r25 = ir_sequenz_wiederholungszhler
;r26 = timer0_berlaufzhler low
;r27 = timer0_berlaufzhler high
;r28 = zeitraffer_zhler low  &  ready_led_ausschaltverzgerungszhler
;r29 = zeitraffer_zhler high
;r30 = z_register low (data lesen)
;r31 = z_register high (data lesen)
;
;schalterstellungen: (2 umschalter an portb3 und portb4 die jeweils nach gnd und vcc schalten)
; portb4  portb3    zeitrafferdelay
;   gnd     gnd   =  10sekunden 
;   gnd     vcc   =   1minute (energiesparfunktion in der f200 auf mindestens 3minuten stellen) 
;   vcc     gnd   =   5minuten (energiesparfunktion in der f200 auf 10 minuten stellen)
;   vcc     vcc   =   9,5 mimnuten mehr geht nicht sonst geht die f200 in standby (energiesparfunktion im f200
;		      menue auf 10 minuten stellen)
;kathode von ir leds an port1 und port2 ber jeweils 330ohm nach vcc (anode).
;kathode von ready led an portb3 und ber einen von den beiden 330ohm nach vcc (anode)
;das fuse bit CKDIV8 muss abgeschaltet werden (im ponyprog das hkchen wegnehmen)
;bei mir hab ich nur die fuse SUT0 und CKSEL0 an (im ponyprog das hckchen da)

start:
	;stackpointer initialisieren
	ldi r16,low(ramend) 
	out spl,r16
	
	;spannungscomparator aus (strom sparen :) )
	sbi acsr,acd
	
	;timer0 auf compare modus stellen (ctc)
	ldi r16,0b00000010
	out tccr0a,r16
	;timer0 prescaler auf 1 stellen (ungeteilte 9,6MHz taktfrequenz)
	ldi r16,0b00000001
	out tccr0b,r16
 	;timer0 soll bis 126 laufen (d.h.125+1takt bis der interrupt ausgelst wird)
	ldi r16,125
	out ocr0a,r16
	;timer0 compare A interrupt an
	ldi r16,0b00000100  
	out timsk0,r16
	
	;alle interrupts an
	sei



allesnochmal:
	;38095Hz aus  &  portb1_portb2_flipflop aus 
	ldi r18,0
	sbr r19,1

	;ready_led an
	sbi ddrb,2 
	
	;timer0_berlaufzhler auf fast 0
	ldi r26,1	
	clr r27
	
	;;ready_led_ausschaltverzgerungszhler auf 0
	clr r28
leddelay:	
	;ready_led_ausschaltverzgerung
	tst r26 ;timer0_berlaufzhler low auf 0?
	brne leddelay
	tst r27 ;timer0_berlaufzhler high auf 0?
	brne leddelay
	inc r26 ;timer0_berlaufzhler um 1 erhhen damit low abfrage wieder zuschlgt
	inc r28 ;ready_led_ausschaltverzgerungszhler
	cpi r28,3 ;endwert erreicht?
	brne leddelay
	
	;ready_led aus
	cbi ddrb,2
	
	;ir_sequenz_wiederholungszhler auf 0
	clr r25



irrausnochmal: ;(infrarotsequenz muss 2mal wiederholt werden sonst setzt die f200 1mal aus beim ir empfang)
	;addresszeiger auf anfang der ir daten (data zeilen)
	ldi r30,low(data*2) ;(data*2 weil speicher ist 16bit aber nur 8bit wert wird gelesen)
	ldi r31,high(data*2)
	
	;portb1_portb2_flipflop an
	cbr r19,1
irraus:
	;timer0_berlaufzhler auf 0
	clr r26
	clr r27
	
	;data wert einlesen, wenn data wert=0 springe nach zeitraffer (ende der ir sequenz erreicht)
	lpm r21,z+ ;(z+ = addresszeiger auf nchsten data wert stellen)
	lpm r22,z+
	tst r21
	breq zeitraffer
weiter: 	
	;datawert und timer0_berlaufzhler vergleichen, wenn gleich dann 
	;38095Hz frequenz anhalten oder starten (toggle r19 bit0)
	;wenn nicht gleich dann abwarten bis der timer0_berlaufzhler den data wert erreicht hat (brne weiter)
	cp r21,r26
	brne weiter
	cp r22,r27
	brne weiter
	ldi r16,0b00000001
	eor r19,r16
	rjmp irraus


allesnochmal1: ;(zwischensprung weil relativer sprungbereich berschritten ist) 
	rjmp allesnochmal


zeitraffer:
	;wurde die infrarotsequnz 2mal wiederholt? wenn nein dann zurch zu ir_raus_nochmal
	inc r25
	cpi r25,2
	brne irrausnochmal
	
	;38095Hz aus  &  portb1_portb2_flipflop aus
	ldi r18,0
	sbr r19,1	
	
	;timer0_berlaufzhler auf 0
	clr r26
	clr r27
	
	;zeitraffer_zhler lschen
	clr r28
	clr r29
	
	;schalterstellungen abfragen
	in r16,pinb
	sbrc r16,3 ;portb3 auf gnd?
	rjmp schalter01a ;nein
	sbrc r16,4 ;portb4 auf gnd?
	rjmp schalter10a ;nein
	rjmp schalter00 ;portb3 und portb4 sind also auf gnd!
schalter01a:
	sbrc r16,4 ;portb4 auch auf gnd?
	rjmp schalter11 ;nein, dann sind also beide schalter auf vcc! 
	rjmp schalter01 ;ja, dann ist also nur schalter portb3 auf vcc! 
schalter10a:
	sbrc r16,3 ;portb3 auch auf gnd?
	rjmp schalter11 ;nein, dann sind also beide schalter auf vcc!
	rjmp schalter10 ;ja, dann ist also nur schalter portb4 auf vcc!
;zeitrafferlnge zuweisen: 
schalter00:
	ldi r21,8 ;alle 9sek (plus 1sek auslseverzgerung=10sek)
	clr r22
	rjmp weiter1
schalter01: 
	ldi r21,66 ;alle 59sek (plus 1sek auslseverzgerung=1min)
	clr r22
	rjmp weiter1
schalter10:
	ldi r21,88 ;alle 299sek (plus 1sek auslseverzgerung=5min)
	ldi r22,1
	rjmp weiter1
schalter11:
	ldi r21,144 ;alle 569sek (plus 1sek auslseverzgerung=9,5min)
	ldi r22,2
weiter1:
	;timer0_berlauf 65535mal zhlen...
	tst r26 
	brne weiter1
	tst r27
	brne weiter1
	inc r26
	
	;...und dann die ready_led an- oder ausschalten...
	ldi r16,0b00000100
	in r17,ddrb
	eor r17,r16
	out ddrb,r17
	
	;... und den zeitraffer_zhler um 1 erhhen. wenn zeilraffa_zhler=zeitrafferlnge dann allesochmal  
	adiw r28,1
	cp r28,r21
	brne weiter1
	cp r29,r22
	breq allesnochmal1
rjmp weiter1



timer0uberlauf:
	;statusregister sichern
	in r16,sreg 
	push r16
	
	adiw r26,1 ;timer0_berlaufzhler
	tst r18 ;flipflop an oder aus?
	breq iraus ;wenn aus (0) dann goto ir aus (ir led ausschalten)
	nop ;nop wegen taktlngenausgleich vom breq (38095Hz pulslngen ausgleich (eigentlich unntig))
	;ir leds an
	in r16,ddrb
	ori r16,0b00000011 
	out ddrb,r16
	cbr r18,1 ;flipflop beim nchstenmal aus
	
	;statusregister zurckschreiben
	pop r16
	out sreg,r16
	
	reti

iraus:	;ir leds aus
	in r16,ddrb
	andi r16,0b11111100
	out ddrb,r16
	sbrs r19,0 ;flipflop soll aus bleiben? (bit0=1=berpringe nchste anweisung)
	sbr r18,1 ;flipflop beim nchstenmal an
	
	;statusregister zurckschreiben
	pop r16
	out sreg,r16
	
	reti



;daten fr minolta f200 fernauslsung mit 1sec verzgerung (umgesetzt vom lirc archiv) 
data:
	.dw 295,130 ;ir leds mit 38095Hz an/aus schalten fr 295 zyklen und auslassen fr 130 zyklen
	
	.dw 40,33,40,33,40,101,40,33 ;jetzt ir leds fur 40 zyklen mit 38095Hz an/aus schalten und 33 oder 101 zyklen auslassen
	.dw 40,101,40,101,40,33,40,33 ;40 & 33 bedeutet fr die f200 eine 1 
	.dw 40,33,40,101,40,33,40,101 ;40 & 101 beedeutet fr die f200 eine 0
	.dw 40,33,40,33,40,101,40,101 ;der gesamte block hier bedeutet also D3AC7D das ist ein 
 	.dw 40,101,40,33,40,33,40,33 ;minolta spezifischer wert  
	.dw 40,33,40,33,40,101,40,33
	
	.dw 40,101,40,33,40,33,40,33 ;der block hier bedeutet 7F =f200 fernauslsen nach 1sek (FF = nach 2sek)
	.dw 40,33,40,33,40,33,40,33
	
	.dw 40,689 ;zum schluss noch fr 40 zyklen ein/aus schalten und fr 689 zyklen auslassen
	
	.dw 0 ; die null damit das prg das ende der daten erkennt
