#include "RFM02.h"


RFM02::RFM02(byte mosi, byte sck, byte irq, byte ss) {
  m_mosi = mosi;
  m_sck = sck;
  m_irq = irq;
  m_ss = ss;

  m_debug = false;
  m_dataRate = 0x13;
  m_frequency = 0;
  m_sync = true;
  m_high = false;


  pinMode(m_mosi, OUTPUT);
  pinMode(m_sck, OUTPUT);
  pinMode(m_irq, INPUT);
  pinMode(m_ss, OUTPUT);
}

void RFM02::SetDataRate(DataRates dataRate) {
  m_dataRate = dataRate;
  RFM02::spiWord(0xC800 | m_dataRate);
}

void RFM02::SetFrequency(unsigned long kHz) {
  m_frequency = kHz;
  RFM02::spiWord(40960 + (m_frequency - 860000) / 5);
}

unsigned long RFM02::GetFrequency() {
  return m_frequency;
}


RFM02::DataRates RFM02::GetDataRate() {
  return (RFM02::DataRates)m_dataRate;
}


void RFM02::EnableTransmitter(bool enable){
  if (enable) {
    RFM02::spiWord(0xC038);
  }
  else {
    RFM02::spiWord(0xC008);
  }
}



void RFM02::spiWord(unsigned short value) {
  RFM02::spiBegin();
  byte high = value >> 8;
  byte low = value & 0xFF;
  RFM02::spi(high);
  RFM02::spi(low);
  RFM02::spiEnd();
}



#define clrb(pin) (*portOutputRegister(digitalPinToPort(pin)) &= ~digitalPinToBitMask(pin))
#define setb(pin) (*portOutputRegister(digitalPinToPort(pin)) |= digitalPinToBitMask(pin))
void RFM02::spi(byte value)
{
  for (byte i = 0; i < 8; i++) {
    if (value & 0x80) {
      setb(RFM02::m_mosi);
    }
    else {
      clrb(RFM02::m_mosi);
    }
    value <<= 1;
    setb(RFM02::m_sck);
    asm("nop");
    asm("nop");
    clrb(RFM02::m_sck);
  }

}

void RFM02::spiBegin() {
  clrb(m_ss);
}

void RFM02::spiEnd() {
   setb(m_ss);
}


void RFM02::SendArray(byte *data, byte length) {
  if (m_debug) {
    Serial.print("Sending data: ");
    for (int p = 0; p < length; p++) {
      Serial.print(data[p], HEX);
      Serial.print(" ");
    }
    Serial.println();
  }

  // Transmitter on
  EnableTransmitter(true);

  RFM02::spiBegin();
  RFM02::spi(0xC6); // send data
  delay(2);
  // Sync, sync, sync ...
  m_buffer[0] = 0xAA;
  m_buffer[1] = 0xAA;
  m_buffer[2] = 0xAA;
  m_buffer[3] = 0x2D;
  m_buffer[4] = 0xD4;

  // prepare data
  for (int i = 0; i < length; ++i) {
    m_buffer[5+i] = (data[i]);
  }

  for(byte j = 0; j < length + 5; ++j){
    byte value = m_buffer[j];
    for (byte i = 0; i < 8; ++i) {
      if (value & 0x80) {
        m_high = true;
      } else {
        m_high = false;
      }
      m_sync = false;
      value <<= 1;
      while(!m_sync){};
    }
  }
  
  m_sync = false;
  
  
  RFM02::spiEnd();
  // Transmitter off
  delay(1);
  EnableTransmitter(false);
}

void RFM02::send()
{

 
}
void RFM02::sendISR()
{
  if(m_sync)
    return;
  if(m_high)
    setb(RFM02::m_mosi);
  else 
    clrb(RFM02::m_mosi);


    m_sync = true;
}



byte RFM02::CalculateCRC(byte data[], int len) {
  int i, j;
  byte res = 0;
  for (j = 0; j < len; j++) {
    uint8_t val = data[j];
    for (i = 0; i < 8; i++) {
      uint8_t tmp = (uint8_t)((res ^ val) & 0x80);
      res <<= 1;
      if (0 != tmp) {
        res ^= 0x31;
      }
      val <<= 1;
    }
  }
  return res;
}

void RFM02::PowerDown(){
  spiWord(0xC001);
}

void RFM02::InitialzeLaCrosse() {
  // Deselect the RFM and wait until it is up
  digitalWrite(m_ss, HIGH);
  for (int i = 0; i < 10; i++) { delay(10); }

  RFM02::spiWord(0x9782);              // 9782 CONFIGURATION 868 band,12.5pF, Deviation 90 kHz
  RFM02::spiWord(0xC800 | m_dataRate); // DATA RATE
  RFM02::spiWord(0xC2A0);  	       // TX bit, disable Wake-Up, 2,2V low Voltage 



}

void RFM02::SetDebugMode(boolean mode) {
  m_debug = mode;
}

