#ifndef _RFM02_h
#define _RFM02_h

#include "Arduino.h"

class RFM02 {
public:
  enum DataRates {
    DataRate17241 = 0x13,
    DataRate9579  = 0x23
  };

 enum {sendBufferSize = 50};
private:
  byte m_mosi, m_sck, m_irq, m_ss;
  bool m_debug;
  byte m_dataRate;
  byte m_buffer[sendBufferSize];
  volatile boolean m_high;
  volatile boolean m_sync;
  unsigned long m_frequency;

  void spiWord(unsigned short value);
  void send();
  
public:
  void sendISR();
  void spi(byte value);
  void spiBegin();
  void spiEnd();
  RFM02(byte mosi, byte sck, byte irq, byte ss);
  void InitialzeLaCrosse();
  void SendArray(byte *data, byte length);
  void SetDataRate(DataRates dataRate);
  DataRates GetDataRate();
  void SetFrequency(unsigned long kHz);
  unsigned long GetFrequency();
  void EnableTransmitter(bool enable);
  static byte CalculateCRC(byte data[], int len);
  void PowerDown();
  void SetDebugMode(boolean mode);
  
};


#endif



