/**
  ******************************************************************************
  * File Name          : main.c
  * Date               : 13/02/2015 14:01:38
  * Description        : Main program body
  ******************************************************************************
  *
  * COPYRIGHT(c) 2015 STMicroelectronics
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "stm32f4xx_hal.h"
#include "dac.h"
#include "i2c.h"
#include "i2s.h"
#include "ltdc.h"
#include "rtc.h"
#include "spi.h"
#include "usart.h"
#include "gpio.h"
#include "fmc.h"

/* USER CODE BEGIN Includes */
#define SDRAM_MODEREG_BURST_LENGTH_1             ((uint16_t)0x0000)
#define SDRAM_MODEREG_BURST_LENGTH_2             ((uint16_t)0x0001)
#define SDRAM_MODEREG_BURST_LENGTH_4             ((uint16_t)0x0002)
#define SDRAM_MODEREG_BURST_LENGTH_8             ((uint16_t)0x0004)
#define SDRAM_MODEREG_BURST_TYPE_SEQUENTIAL      ((uint16_t)0x0000)
#define SDRAM_MODEREG_BURST_TYPE_INTERLEAVED     ((uint16_t)0x0008)
#define SDRAM_MODEREG_CAS_LATENCY_2              ((uint16_t)0x0020)
#define SDRAM_MODEREG_CAS_LATENCY_3              ((uint16_t)0x0030)
#define SDRAM_MODEREG_OPERATING_MODE_STANDARD    ((uint16_t)0x0000)
#define SDRAM_MODEREG_WRITEBURST_MODE_PROGRAMMED ((uint16_t)0x0000) 
#define SDRAM_MODEREG_WRITEBURST_MODE_SINGLE     ((uint16_t)0x0200)      

/* USER CODE END Includes */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);

/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

int main(void)
{

  /* USER CODE BEGIN 1 */

  /* USER CODE END 1 */

  /* MCU Configuration----------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* Configure the system clock */
  SystemClock_Config();

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DAC_Init();
  MX_FMC_Init(); // Schritt 1 - Init SDRAM Controller, Schritt 2 - Init SDRAM Timing
	
	FMC_SDRAM_CommandTypeDef SDRAM1;
	
	SDRAM1.CommandMode = FMC_SDRAM_CMD_CLK_ENABLE;	
	SDRAM1.CommandTarget = FMC_SDRAM_BANK2;
	SDRAM1.AutoRefreshNumber = 1;
	SDRAM1.ModeRegisterDefinition = 0;

	while(HAL_SDRAM_GetState(&hsdram1) == HAL_SDRAM_STATE_BUSY){}
	HAL_SDRAM_SendCommand(&hsdram1, &SDRAM1,1); // Schritt 3 - Clock enable
	HAL_Delay(10);
	
	SDRAM1.CommandMode = FMC_SDRAM_CMD_PALL;
	SDRAM1.CommandTarget = FMC_SDRAM_BANK2;
	SDRAM1.AutoRefreshNumber = 1;
	SDRAM1.ModeRegisterDefinition = 0;	
	while(HAL_SDRAM_GetState(&hsdram1) == HAL_SDRAM_STATE_BUSY){}
	HAL_SDRAM_SendCommand(&hsdram1, &SDRAM1,1);// Schritt 4 - Precharge all
	
	//HAL_SDRAM_SetAutoRefreshNumber(&hsdram1, 8); 
	SDRAM1.CommandMode = 	FMC_SDRAM_CMD_AUTOREFRESH_MODE;
	SDRAM1.CommandTarget = FMC_SDRAM_BANK2;
	SDRAM1.AutoRefreshNumber = 4;
	SDRAM1.ModeRegisterDefinition = 0;
	while(HAL_SDRAM_GetState(&hsdram1) == HAL_SDRAM_STATE_BUSY){}
	HAL_SDRAM_SendCommand(&hsdram1, &SDRAM1,1); // Schritt 5 - Auto Refresh Mode
	
	while(HAL_SDRAM_GetState(&hsdram1) == HAL_SDRAM_STATE_BUSY){}
	HAL_SDRAM_SendCommand(&hsdram1, &SDRAM1,1); // Schritt 5 - Auto Refresh Mode
	

	SDRAM1.CommandMode = FMC_SDRAM_CMD_LOAD_MODE ;
	SDRAM1.CommandTarget = FMC_SDRAM_BANK2;	
	SDRAM1.AutoRefreshNumber = 1;
	SDRAM1.ModeRegisterDefinition = SDRAM_MODEREG_BURST_LENGTH_2 | SDRAM_MODEREG_BURST_TYPE_SEQUENTIAL | SDRAM_MODEREG_CAS_LATENCY_3 | SDRAM_MODEREG_OPERATING_MODE_STANDARD | SDRAM_MODEREG_WRITEBURST_MODE_SINGLE;
	while(HAL_SDRAM_GetState(&hsdram1) == HAL_SDRAM_STATE_BUSY){}
	HAL_SDRAM_SendCommand(&hsdram1, &SDRAM1,1); // Schritt 6 - load Mode Command
	

	HAL_SDRAM_ProgramRefreshRate(&hsdram1, 1386); // Schritt 7 - set refresh
	while(HAL_SDRAM_GetState(&hsdram1) == HAL_SDRAM_STATE_BUSY){}
	
  MX_I2C3_Init();
  MX_I2S3_Init();
  MX_LTDC_Init();
		
		LTDC_ColorTypeDef myColor;
		myColor.Blue= 0;
		myColor.Green= 0;
		myColor.Red = 0;
		
		
		LTDC_LayerCfgTypeDef myLayer;
		myLayer.WindowX0 =0;
		myLayer.WindowX1 =799;
		myLayer.WindowY0 =0;
		myLayer.WindowY1 =799;
		myLayer.PixelFormat = LTDC_PIXEL_FORMAT_RGB565;
		myLayer.Alpha = 255;
		myLayer.Alpha0 =255;
		myLayer.BlendingFactor1 = 0;
		myLayer.BlendingFactor2 = 0;
		myLayer.FBStartAdress = 0x00000000;
		myLayer.ImageWidth = 800;
		myLayer.ImageHeight = 600;
		myLayer.Backcolor = myColor;
		
		HAL_LTDC_ConfigLayer(&hltdc, &myLayer ,1);
		
		
		HAL_LTDC_DisableDither(&hltdc);
		HAL_LTDC_DisableCLUT(&hltdc,1);
		//HAL_LTDC_DisableCLUT(&hltdc,1);
		HAL_LTDC_DisableColorKeying(&hltdc, 1);
		//HAL_LTDC_DisableColorKeying(&hltdc, 1);
		
		
		//HAL_LTDC_SetAddress(&hltdc, 0xd0000000 , 0);
		//HAL_LTDC_SetPixelFormat(&hltdc,LTDC_PIXEL_FORMAT_RGB888,0);
		
	
		
		
  MX_RTC_Init();
  MX_SPI4_Init();
  MX_USART1_UART_Init();

  /* USER CODE BEGIN 2 */

  /* USER CODE END 2 */

  /* USER CODE BEGIN 3 */
  /* Infinite loop */
	uint32_t flashmem = 0;
  while (1)
  {
		/*
		myColor.Blue= 255;
		myColor.Green= 0;
		myColor.Red = 0;
		HAL_LTDC_ConfigLayer(&hltdc, &myLayer ,1);
		HAL_Delay(1000);
		
		myColor.Blue= 0;
		myColor.Green= 255;
		myColor.Red = 0;
		HAL_LTDC_ConfigLayer(&hltdc, &myLayer ,1);
		HAL_Delay(1000);
		
		myColor.Blue= 0;
		myColor.Green= 0;
		myColor.Red = 255;
		HAL_LTDC_ConfigLayer(&hltdc, &myLayer ,1);
		HAL_Delay(1000);	
		*/
		while(flashmem<960000){
		HAL_LTDC_SetAddress(&hltdc, flashmem , 1);
		flashmem += 1600;
		HAL_Delay(4);
		}
		
		while(flashmem>1600){
		HAL_LTDC_SetAddress(&hltdc, flashmem , 1);
		flashmem -= 1600;
		HAL_Delay(4);
		}
		
  }
  /* USER CODE END 3 */

}

/** System Clock Configuration
*/
void SystemClock_Config(void)
{

  RCC_OscInitTypeDef RCC_OscInitStruct;
  RCC_ClkInitTypeDef RCC_ClkInitStruct;
  RCC_PeriphCLKInitTypeDef PeriphClkInitStruct;

  __PWR_CLK_ENABLE();

  __HAL_PWR_VOLTAGESCALING_CONFIG(PWR_REGULATOR_VOLTAGE_SCALE1);

  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSE|RCC_OSCILLATORTYPE_LSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.LSEState = RCC_LSE_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLM = 8;
  RCC_OscInitStruct.PLL.PLLN = 336;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLQ = 4;
  HAL_RCC_OscConfig(&RCC_OscInitStruct);

  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_SYSCLK|RCC_CLOCKTYPE_PCLK1
                              |RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV4;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV2;
  HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_5);

  PeriphClkInitStruct.PeriphClockSelection = RCC_PERIPHCLK_I2S|RCC_PERIPHCLK_LTDC
                              |RCC_PERIPHCLK_RTC;
  PeriphClkInitStruct.PLLI2S.PLLI2SN = 192;
  PeriphClkInitStruct.PLLI2S.PLLI2SR = 4;
  PeriphClkInitStruct.PLLSAI.PLLSAIN = 320;
  PeriphClkInitStruct.PLLSAI.PLLSAIR = 2;
  PeriphClkInitStruct.PLLSAIDivR = RCC_PLLSAIDIVR_4;
  PeriphClkInitStruct.RTCClockSelection = RCC_RTCCLKSOURCE_LSE;
  HAL_RCCEx_PeriphCLKConfig(&PeriphClkInitStruct);

}

/* USER CODE BEGIN 4 */

/* USER CODE END 4 */

#ifdef USE_FULL_ASSERT

/**
   * @brief Reports the name of the source file and the source line number
   * where the assert_param error has occurred.
   * @param file: pointer to the source file name
   * @param line: assert_param error line source number
   * @retval None
   */
void assert_failed(uint8_t* file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
    ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
  /* USER CODE END 6 */

}

#endif

/**
  * @}
  */ 

/**
  * @}
*/ 

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/
