#cs ----------------------------------------------------------------------------

 AutoIt Version: 3.2.12.1
 Author:         myName

 Script Function:
	Template AutoIt script.

#ce ----------------------------------------------------------------------------

; Script Start - Add your code below here

#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <GUIConstantsEx.au3>
#include <ListViewConstants.au3>
#include <StaticConstants.au3>
#include <WindowsConstants.au3>
#Include <GuiListView.au3>
#include <TreeViewConstants.au3>
#Include <GuiTreeView.au3>
#include <GuiToolbar.au3>
#include <Constants.au3>
#include <ListViewConstants.au3>

#include <import.au3>
#include <output.au3>

Global Const $param_anz=7

Global $param_name[$param_anz],$param_inp[$param_anz]
Global $cmdList_selGrp=-1, $cmdList_selFnc, $prgList_sel=-1, $prgList_anz=0, $prgListArr[100][4], $tbItem, $aktFile=""
Global Const $prg_name=0, $prg_text=1, $prg_config=2, $prg_values=3

Opt("GUIOnEventMode", 1)
;Opt("MustDeclareVars",1)
#Region ### START Koda GUI section ### Form=
$Form1 = GUICreate("UNI-Computer-WEB  Funktionsinterpreter", 819, 458, 192, 124)
GUISetOnEvent($GUI_EVENT_CLOSE, "Form1_Close")
$btn_up = GUICtrlCreateButton("", 216, 152, 25, 25, $BS_ICON)
GUICtrlSetImage(-1, @ScriptDir&"\img\ar_up.ico", -1)
GUICtrlSetTip(-1, "nach oben")
GUICtrlSetOnEvent(-1, "btn_up_Click")
$btn_down = GUICtrlCreateButton("", 216, 280, 24, 25, $BS_ICON)
GUICtrlSetImage(-1, @ScriptDir&"\img\ar_down.ico", -1)
GUICtrlSetTip(-1, "nach unten")
GUICtrlSetOnEvent(-1, "btn_down_Click")
$btn_add = GUICtrlCreateButton("", 216, 200, 25, 25, $BS_ICON)
GUICtrlSetImage(-1, @ScriptDir&"\img\ar_right.ico", -1)
GUICtrlSetTip(-1, "Funktion hinzufgen")
GUICtrlSetOnEvent(-1, "btn_add_Click")
$btn_del = GUICtrlCreateButton("", 216, 232, 25, 25, $BS_ICON)
GUICtrlSetImage(-1, @ScriptDir&"\img\cancel.ico", -1)
GUICtrlSetTip(-1, "Befehl lschen")
GUICtrlSetOnEvent(-1, "btn_del_Click")
$Label1 = GUICtrlCreateLabel("verfgbare Befehle", 8, 32, 94, 17)
$Label2 = GUICtrlCreateLabel("Programmliste", 248, 32, 69, 17)
$Group1 = GUICtrlCreateGroup("Befehlskonfiguration", 552, 40, 257, 273)
$bk_des1 = GUICtrlCreateLabel("Stunde", 560, 68, 118, 17, $SS_RIGHT)
GUICtrlSetState(-1, $GUI_HIDE)
$bk_inp1 = GUICtrlCreateInput("", 688, 64, 105, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUICtrlSetState(-1, $GUI_HIDE)
$bk_des2 = GUICtrlCreateLabel("Stunde", 560, 92, 118, 17, $SS_RIGHT)
GUICtrlSetState(-1, $GUI_HIDE)
$bk_inp2 = GUICtrlCreateInput("", 688, 88, 105, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUICtrlSetState(-1, $GUI_HIDE)
$bk_des3 = GUICtrlCreateLabel("Stunde", 560, 116, 118, 17, $SS_RIGHT)
GUICtrlSetState(-1, $GUI_HIDE)
$bk_inp3 = GUICtrlCreateInput("", 688, 112, 105, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUICtrlSetState(-1, $GUI_HIDE)
$bk_des4 = GUICtrlCreateLabel("Stunde", 560, 140, 118, 17, $SS_RIGHT)
GUICtrlSetState(-1, $GUI_HIDE)
$bk_inp4 = GUICtrlCreateInput("", 688, 136, 105, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUICtrlSetState(-1, $GUI_HIDE)
$bk_des5 = GUICtrlCreateLabel("Stunde", 560, 164, 118, 17, $SS_RIGHT)
GUICtrlSetState(-1, $GUI_HIDE)
$bk_inp5 = GUICtrlCreateInput("", 688, 160, 105, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUICtrlSetState(-1, $GUI_HIDE)
$bk_des6 = GUICtrlCreateLabel("Stunde", 560, 188, 118, 17, $SS_RIGHT)
GUICtrlSetState(-1, $GUI_HIDE)
$bk_inp6 = GUICtrlCreateInput("", 688, 184, 105, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUICtrlSetState(-1, $GUI_HIDE)
$bk_des7 = GUICtrlCreateLabel("Stunde", 560, 212, 118, 17, $SS_RIGHT)
GUICtrlSetState(-1, $GUI_HIDE)
$bk_inp7 = GUICtrlCreateInput("", 688, 208, 105, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUICtrlSetState(-1, $GUI_HIDE)
$btn_change = GUICtrlCreateButton("bernehmen", 564, 276, 97, 25)
GUICtrlSetState(-1, $GUI_HIDE)
GUICtrlSetOnEvent(-1, "btn_change_Click")
$cb_useSRambuffer = GUICtrlCreateCheckbox("SRAM zwischenspeicher verwenden", 584, 240, 209, 25)
GUICtrlSetOnEvent(-1, "cb_useSRambuffer_Click")
GUICtrlCreateGroup("", -99, -99, 1, 1)
$list_cmds = GUICtrlCreateTreeView(8, 48, 201, 401, BitOR($GUI_SS_DEFAULT_TREEVIEW,$WS_BORDER), $WS_EX_STATICEDGE)
$list_cmdTab = GUICtrlCreateTreeView(248, 48, 297, 401, BitOR($GUI_SS_DEFAULT_TREEVIEW,$WS_BORDER), $WS_EX_STATICEDGE)
$Label3 = GUICtrlCreateLabel("Speicherkarte", 568, 408, 70, 17)
$btn_pickSd = GUICtrlCreateButton("", 784, 424, 23, 23, $BS_ICON)
GUICtrlSetImage(-1, "C:\WINDOWS\explorer.exe", -2, 0)
GUICtrlSetOnEvent(-1, "btn_pickSd_Click")
$inp_exportDir = GUICtrlCreateInput("", 568, 424, 209, 21, BitOR($GUI_SS_DEFAULT_INPUT,$WS_BORDER))
GUISetState(@SW_SHOW)
#EndRegion ### END Koda GUI section ###
;ImageList
$ImageList1 = _GUIImageList_Create(16, 16, 5)
_GUIImageList_AddIcon($ImageList1, @ScriptDir & "\img\exit.ico", 0, True)
_GUIImageList_AddIcon($ImageList1, @ScriptDir & "\img\export.ico", 0, True)
_GUIImageList_AddIcon($ImageList1, @ScriptDir & "\img\new.ico", 0, True)
_GUIImageList_AddIcon($ImageList1, @ScriptDir & "\img\open.ico", 0, True)
_GUIImageList_AddIcon($ImageList1, @ScriptDir & "\img\save.ico", 0, True)
_GUIImageList_AddIcon($ImageList1, @ScriptDir & "\img\saveas.ico", 0, True)
;Toolbar
$ToolBar1 = _GUICtrlToolbar_Create($Form1, 0)
_GUICtrlToolbar_SetImageList($ToolBar1, $ImageList1)
_GUICtrlToolbar_AddButton($ToolBar1, 1000, 2, 0)
_GUICtrlToolbar_AddButton($ToolBar1, 1001, 3, 0)
_GUICtrlToolbar_AddButton($ToolBar1, 1002, 4, 0)
_GUICtrlToolbar_AddButton($ToolBar1, 1003, 5, 0)
_GUICtrlToolbar_AddButtonSep($ToolBar1)
_GUICtrlToolbar_AddButton($ToolBar1, 1004, 1, 0)
_GUICtrlToolbar_AddButtonSep($ToolBar1)
_GUICtrlToolbar_AddButton($ToolBar1, 2, 0, 0)


GUIRegisterMsg($WM_NOTIFY, "WM_NOTIFY")
init()


While 1
	Sleep(100)
WEnd

Func btn_add_Click()
	Local $i,$j,$p
	if $cmdList_selGrp=-1 then Return
	ConsoleWrite("Add" & @crlf)
	if $prgList_sel<0 Then
		;Eintrag am Ende anfgen
		$p=$prgList_anz
	Else
		;Eintrag nach Selektion einfgen
		for $i=$prgList_anz to $prgList_sel+1 Step -1
			for $j=0 to UBound($prgListArr,2)-1
				$prgListArr[$i][$j]=$prgListArr[$i-1][$j]
			Next
		Next
		$p=$prgList_sel+1
	EndIf
	$prgListArr[$p][$prg_name]=$cmdgrp[$cmdList_selGrp][0] & "/" & $cmdList_selFnc
	Local $config=get_CMDParamArray()
	$prgListArr[$p][$prg_config]=$config
	if $config[$fx_pA] >0 Then
		Local $vals[$config[$fx_pA]]
		$prgListArr[$p][$prg_values]=$vals
	Else
		$prgListArr[$p][$prg_values]=-1
	EndIf
	$prgList_anz+=1
	Create_PrgTree($prgList_sel+1)
EndFunc

Func btn_change_Click()
	if $prgList_sel<0 then Return
	ConsoleWrite("Change" & @crlf)
	Local $c,$v,$a,$i,$p,$w,$err
	$c=$prgListArr[$prgList_sel][$prg_config]
	$v=$prgListArr[$prgList_sel][$prg_values]
	$a=$c[$fx_pA]
	$pd=$c[$fx_parA]
	$i=0
	While $i<$a
		$err="0"
		$p=$pd[$i]
		$w=GUICtrlRead($param_inp[$i])
		if StringLen($w)=0 Then
			$err="Der Parameter " & $p[$fn_name] & " darf nicht leer sein!"
		Else
			Switch $p[$fn_type]
			Case 0	;Dezimal
				$w=Int($w)
				$wc=$w
				if StringLower(stringleft($p[$fn_name],4))="sram" Then $wc=BitAND($w,0x7FFF)
				if $wc<$p[$fn_min] or $wc>$p[$fn_max] Then $err="Der Wert <" & $p[$fn_name] & "> muss zwischen " & $p[$fn_min] & " und " & $p[$fn_max] & " liegen!"
			Case 1  ;Hexa
				if StringLeft($w,2)="0x" Then $w=StringRight($w,stringlen($w)-2)
				$w=Dec($w)
				$wc=$w
				if StringLower(stringleft($p[$fn_name],4))="sram" Then $wc=BitAND($w,0x7FFF)
				if $wc<$p[$fn_min] or $wc>$p[$fn_max] Then $err="Der Wert <" & $p[$fn_name] & "> muss zwischen 0x" & Hex($p[$fn_min],$p[$fn_Len]*2) & " und 0x" & hex($p[$fn_max],$p[$fn_Len]*2) & " liegen!"
			Case 2	;String
				if StringLen($w) <> $p[$fn_Len] then $err="Der " & $p[$fn_name] & " muss " & $p[$fn_Len] & " Zeichen lang sein!"
			Case Else $err="unkekannt"
			EndSwitch
		EndIf
		if $err="0" Then
			$v[$i]=$w
		Else
			MsgBox(-1,"Fehler",$err)
		EndIf
		$i+=1
	WEnd
	$prgListArr[$prgList_sel][$prg_values]=$v
	Create_PrgTree($prgList_sel)
EndFunc

Func btn_del_Click()
	if $prgList_sel<0 Then Return
	ConsoleWrite("delete" & @crlf)
	Local $i,$j
	for $i=$prgList_sel to $prgList_anz-1
		for $j=0 to UBound($prgListArr,2)-1
			$prgListArr[$i][$j]=$prgListArr[$i+1][$j]
		Next
	Next
	$prgList_anz-=1
	Create_PrgTree()
	Update_FMove_Buttons()
EndFunc

Func btn_down_Click()
	if $prgList_sel>=$prgList_anz-1 Then Return
	ConsoleWrite("Move-Down" & @crlf)
	Local $j,$xm[UBound($prgListArr,2)]
	for $j=0 to UBound($prgListArr,2)-1
		$xm[$j]=$prgListArr[$prgList_sel][$j]
	Next
	for $j=0 to UBound($prgListArr,2)-1
		$prgListArr[$prgList_sel][$j]=$prgListArr[$prgList_sel+1][$j]
	Next
	for $j=0 to UBound($prgListArr,2)-1
		$prgListArr[$prgList_sel+1][$j]=$xm[$j]
	Next
	Create_PrgTree($prgList_sel+1)
EndFunc
	
Func btn_up_Click()
	if $prgList_sel<1 Then Return
	ConsoleWrite("Move-Up" & @crlf)
	Local $j,$xm[UBound($prgListArr,2)]
	for $j=0 to UBound($prgListArr,2)-1
		$xm[$j]=$prgListArr[$prgList_sel][$j]
	Next
	for $j=0 to UBound($prgListArr,2)-1
		$prgListArr[$prgList_sel][$j]=$prgListArr[$prgList_sel-1][$j]
	Next
	for $j=0 to UBound($prgListArr,2)-1
		$prgListArr[$prgList_sel-1][$j]=$xm[$j]
	Next
	Create_PrgTree($prgList_sel-1)
EndFunc

Func tool_new_Click()
	$prgList_anz=0
	$aktFile=""
	Create_PrgTree()
	Update_FMove_Buttons()
	param_setVisible(0)
EndFunc

Func tool_open_Click()
	Local $fi=FileOpenDialog("Programm laden",@scriptdir,"Userprogramms (*.ucup)",1,"",$Form1)
	if $fi<>"" then ArrayReadFromFile($fi)
	$aktFile=$fi
	Create_PrgTree()
	Update_FMove_Buttons()
	param_setVisible(0)
EndFunc

Func tool_save_Click()
	if $aktFile="" then tool_saveas_Click()
	ArrayWriteToFile($aktFile)
EndFunc

Func tool_saveas_Click()
	Local $fi=FileSaveDialog("Programm speichern",@scriptdir,"Userprogramms (*.ucup)",18,"",$Form1)
	if $fi="" then Return
	if StringLower(StringRight($fi,4))<>"ucup" then $fi = $fi & ".ucup"
	ArrayWriteToFile($fi)
EndFunc

Func tool_export_Click()
	Local $pf=GUICtrlRead($inp_exportDir)
	if StringLower(StringRight($pf,4))=".cfg" then makeProgramm($pf)
EndFunc

Func btn_pickSD_Click()
	Local $dir = FileSelectFolder("SD-Karte","",0,"",$Form1)
	if $dir="" then Return
	$dir = $dir & "cmd-int.cfg"
	IniWrite($cfgName,"SETUP","EXPORTDIR",$dir)
	GUICtrlSetData($inp_exportDir,$dir & IniRead($cfgName,"SETUP","PATHFILE",""))
EndFunc

Func Form1_Close()
	GUIDelete($Form1)
	Exit
EndFunc

Func list_cmds_Click($it)
	Local $pa=_GUICtrlTreeView_GetParentHandle($list_cmds,$it)
	if _GUICtrlTreeView_Level($list_cmds,$it) = 0 Then
		$cmdList_selGrp=-1
	Else
		$cmdList_selGrp=_GUICtrlTreeView_GetItemParam(GUICtrlGetHandle($list_cmds),$it)
		$cmdList_selFnc=_GUICtrlTreeView_GetText($list_cmds,$it)
	EndIf
	Update_FMove_Buttons()
EndFunc

Func list_cmdTab_Click($it)
	ConsoleWrite("CMD-Tab click" & @crlf)
	if _GUICtrlTreeView_Level($list_cmdTab,$it)=0 Then
		$prgList_sel=_GUICtrlTreeView_GetItemParam(GUICtrlGetHandle($list_cmdTab),$it)
		if $prgList_sel>=$prgList_anz Then
			$prgList_sel=-1
			Update_FMove_Buttons()
			Return
		EndIf
		Local $ix=_GUICtrlTreeView_GetFirstItem($list_cmdTab)
		While $ix<>0
			_GUICtrlTreeView_Expand($list_cmdTab,$ix,false)
			$ix=_GUICtrlTreeView_GetNextSibling($list_cmdTab,$ix)
		WEnd
		_GUICtrlTreeView_Expand($list_cmdTab,$it)
		Local $c,$v,$a,$i,$p,$val
		$c=$prgListArr[$prgList_sel][$prg_config]
		$val=$prgListArr[$prgList_sel][$prg_values]
		$a=$c[$fx_pA]
		$pd=$c[$fx_parA]
		$i=0
		While $i<$a
			$p=$pd[$i]
			GUICtrlSetData($param_name[$i],$p[$fn_name])
			$v=$val[$i]
			if StringLower(stringleft($p[$fn_name],4))="sram" Then
				setCB($cb_useSRambuffer,BitAND($v,0x8000)==0x8000)
			EndIf
			Switch $p[$fn_type]
			case 1
				$v="0x" & Hex($v,$p[$fn_Len]*2)
			EndSwitch
			GUICtrlSetData($param_inp[$i],$v)
			$i+=1
		WEnd
		param_setVisible($a)
	Else
		$prgList_sel=-1
		param_setVisible(0)
	EndIf
	Update_FMove_Buttons()
EndFunc

Func cb_useSRambuffer_Click()
	Local $st=getCB($cb_useSRambuffer), $i, $v
	for $i=0 to $param_anz-1
		if StringLower(stringleft(guictrlread($param_name[$i]),4))="sram" then
			$v=$prgListArr[$prgList_sel][$prg_values]
			if $st=True Then
				$v[$i]=BitOR($v[$i],0x8000)
			Else
				$v[$i]=BitAND($v[$i],0x7FFF)
			EndIf
		EndIf
	Next
	$prgListArr[$prgList_sel][$prg_values]=$v
	Create_PrgTree($prgList_sel)	
EndFunc
;-------------------------------------------------------------------------------------------------------------
Func init()
	;Parameter verknpfen
	$param_name[0]=$bk_des1
	$param_inp[0]=$bk_inp1
	$param_name[1]=$bk_des2
	$param_inp[1]=$bk_inp2
	$param_name[2]=$bk_des3
	$param_inp[2]=$bk_inp3
	$param_name[3]=$bk_des4
	$param_inp[3]=$bk_inp4
	$param_name[4]=$bk_des5
	$param_inp[4]=$bk_inp5
	$param_name[5]=$bk_des6
	$param_inp[5]=$bk_inp6
	$param_name[6]=$bk_des7
	$param_inp[6]=$bk_inp7
	param_setVisible(0)
	Update_FMove_Buttons()
	ImportConfig()
	GUICtrlSetData($inp_exportDir,IniRead($cfgName,"SETUP","EXPORTDIR","") & IniRead($cfgName,"SETUP","PATHFILE",""))
EndFunc

Func Update_FMove_Buttons()
	if $prgList_sel>0 Then
		GUICtrlSetState($btn_up,$GUI_ENABLE)
	Else
		GUICtrlSetState($btn_up,$GUI_DISABLE)
	EndIf
	if $prgList_sel<$prgList_anz-1 and $prgList_sel>-1 Then
		GUICtrlSetState($btn_down,$GUI_ENABLE)
	Else
		GUICtrlSetState($btn_down,$GUI_DISABLE)
	EndIf
	if $prgList_sel>-1 and $prgList_anz>0 Then
		GUICtrlSetState($btn_del,$GUI_ENABLE)
	Else
		GUICtrlSetState($btn_del,$GUI_DISABLE)
	EndIf
	if $cmdList_selGrp>-1 Then
		GUICtrlSetState($btn_add,$GUI_ENABLE)
	Else
		GUICtrlSetState($btn_add,$GUI_DISABLE)
	EndIf
	if $prgList_sel>-1 Then
		GUICtrlSetState($btn_change,$GUI_ENABLE)
	Else
		GUICtrlSetState($btn_change,$GUI_DISABLE)
	EndIf
	
EndFunc

Func param_setVisible($anz)
	Local $i,$vi,$srfx=$GUI_HIDE
	for $i=0 to $param_anz-1
		$vi=$GUI_HIDE
		if $i<$anz then $vi=$GUI_SHOW
		GUICtrlSetState($param_name[$i],$vi)
		GUICtrlSetState($param_inp[$i],$vi)
		if StringLower(stringleft(guictrlread($param_name[$i]),4))="sram" then $srfx=$GUI_SHOW
	Next
	if $anz>0 Then
		GUICtrlSetState($btn_change,$GUI_SHOW)
	Else
		GUICtrlSetState($btn_change,$GUI_HIDE)
	EndIf
	GUICtrlSetState($cb_useSRamBuffer,$srfx)
EndFunc

Func Create_PrgTree($s=-1)
	;[Re]Create TreeView
	Local $i,$tvi,$c,$a,$tvs,$n,$pm,$pa,$an,$v
	_GUICtrlTreeView_BeginUpdate($list_cmdTab)
	_GUICtrlTreeView_DeleteAll($list_cmdTab)
	if $prgList_anz>0 Then
		for $i=0 to $prgList_anz-1
			$tvi=_GUICtrlTreeView_Add($list_cmdTab,0,$prgListArr[$i][$prg_name])
			_GUICtrlTreeView_SetItemParam(GUICtrlGetHandle($list_cmdTab),$tvi,$i)
			$c=$prgListArr[$i][$prg_config]
			$a=$prgListArr[$i][$prg_values]
			$an=$c[$fx_pA]
			$pm=$c[$fx_parA]
			if $an>0 Then
				for $n=0 to $an-1
					$pa=$pm[$n]
					$v=$a[$n]
					Switch $pa[$fn_type]
					case 1
						$v="0x" & Hex($v,$pa[$fn_Len]*2)
					Case 2
						$v="'" & $v & "'"
					EndSwitch
					_GUICtrlTreeView_AddChild($list_cmdTab,$tvi,$pa[$fn_name] & "=" & $v)
				Next
			EndIf
			if $s=$i then $tvs=$tvi
		Next
	EndIf
	_GUICtrlTreeView_EndUpdate($list_cmdTab)
	;_GUICtrlTreeView_Expand($list_cmds)
	$prgList_sel=-1
	if $s>=0 Then _GUICtrlTreeView_SelectItem($list_cmdTab,$tvs)
	EndFunc
	
;######## Hilfsfunktionen #########
Func setCB($cb,$state)
	if $state==true Then
		GUICtrlSetState($cb,$GUI_CHECKED)
	Else
		GUICtrlSetState($cb,$GUI_UNCHECKED)
	EndIf
EndFunc

Func getCB($cb)
	if BitAND(GUICtrlRead($cb),$GUI_CHECKED)>0 then Return True
	Return False
EndFunc

;###########################################################################################
Func WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref $hWnd, $iMsg, $iwParam
	Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $param, $ix,$tNMTBHOTITEM

	$tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")

	Switch $hWndFrom
		Case GUICtrlGetHandle($list_cmds)
			Switch $iCode
				Case $NM_CLICK ; The user has clicked the left mouse button within the control
					Return 0 ; zero to allow the default processing
				Case $TVN_SELCHANGEDA, $TVN_SELCHANGEDW
					list_cmds_Click(_GUICtrlTreeView_GetSelection($list_cmds))
					Return 0
				EndSwitch
		Case GUICtrlGetHandle($list_cmdtab)
			Switch $iCode
				Case $NM_CLICK ; The user has clicked the left mouse button within the control
					Return 0 ; zero to allow the default processing
				Case $TVN_SELCHANGEDA, $TVN_SELCHANGEDW
					list_cmdTab_Click(_GUICtrlTreeView_GetSelection($list_cmdtab))
					Return 0
				EndSwitch
		Case $Toolbar1
			Switch $iCode
				Case $NM_LDOWN
					Switch $tbItem
						Case 1000
							tool_new_Click()
						case 1001
							tool_open_Click()
						case 1002
							tool_save_Click()
						case 1003
							tool_saveas_Click()
						case 1004
							tool_export_Click()
					EndSwitch	
				Case $TBN_HOTITEMCHANGE
					$tNMTBHOTITEM = DllStructCreate($tagNMTBHOTITEM, $ilParam)
					$i_idNew = DllStructGetData($tNMTBHOTITEM, "idNew")
					$tbItem = $i_idNew
			EndSwitch	
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_NOTIFY

