/*
 * BMP085.c
 *
 * Created: 10.11.2014 20:51:19
 *  Author: Michael
 */ 

#include "BMP085.h"
#include "Wait.h"


uint8_t bmp085_Init(bmp085Calib* Calib_data)
{

	//PORT_EOC |= (1 << PIN_EOC);	//Pull-Up ein
	DDR_EOC &= ~( 1 << EOC );	//EOC-Pin als Input
	
	I2CMasterStart (BMP085_BASE | I2C_WRITE); // R/#W = 0
	I2CMasterWrite ( EPROM_START );
	I2CMasterStart (BMP085_BASE | I2C_READ); // #R/W = 1
	
	Calib_data->AC1   = (((int16_t)I2CMasterReadAck() << 8) |
						  (int16_t)I2CMasterReadAck());
	Calib_data->AC2   = (((int16_t)I2CMasterReadAck() << 8) |
					   	  (int16_t)I2CMasterReadAck());
	Calib_data->AC3   = (((int16_t)I2CMasterReadAck() << 8) |
						  (int16_t)I2CMasterReadAck());					  					  
	Calib_data->AC4   = (((uint16_t)I2CMasterReadAck() << 8) |
						  (uint16_t)I2CMasterReadAck());						  
	Calib_data->AC5   = (((uint16_t)I2CMasterReadAck() << 8) |
						  (uint16_t)I2CMasterReadAck());
	Calib_data->AC6   = (((uint16_t)I2CMasterReadAck() << 8) |
						  (uint16_t)I2CMasterReadAck());
	Calib_data->B1   = (((int16_t)I2CMasterReadAck() << 8) |
						 (int16_t)I2CMasterReadAck());
	Calib_data->B2   = (((int16_t)I2CMasterReadAck() << 8) |
						 (int16_t)I2CMasterReadAck());
	Calib_data->MB   = (((int16_t)I2CMasterReadAck() << 8) |
						 (int16_t)I2CMasterReadAck());
	Calib_data->MC   = (((int16_t)I2CMasterReadAck() << 8) |
						 (int16_t)I2CMasterReadAck());
	Calib_data->MD   = (((int16_t)I2CMasterReadAck() << 8) |
						 (int16_t)I2CMasterReadNak());
	
	I2CMasterStop();
	return 0;
}


int32_t bmp085_read_temp_raw (void)
{
	int32_t temp = 0x0000000;
	
	I2CMasterStart (BMP085_BASE | I2C_WRITE); // R/#W = 0
	I2CMasterWrite ( CTRL_REG_ADR );
	I2CMasterWrite ( CTRL_REG_TEMP );
	I2CMasterStop();
	/*
	while (CONVERSION_RUNNING)
	{
		WaitMs(5);
		break;
	}
	*/
	WaitMs(5);
	I2CMasterStart (BMP085_BASE | I2C_READ); // #R/W = 1
	temp = ((I2CMasterReadAck() << 8) |
			 I2CMasterReadNak());
	
	I2CMasterStop();
	return temp;
}

int32_t bmp085_read_pressure_raw (uint8_t resolution)
{
	int32_t temp = 0x0000000;
	uint8_t msb;
	uint8_t lsb;
	uint8_t xlsb;
	
	I2CMasterStart (BMP085_BASE | I2C_WRITE); // R/#W = 0
	I2CMasterWrite ( CTRL_REG_ADR );
	I2CMasterWrite ( CTRL_REG_PRESS+(resolution << 6) );
	I2CMasterStop();
	/*
	while (CONVERSION_RUNNING)
	{
		WaitMs(2+(3 << resolution));
		break;
	}
	*/
	WaitMs(2+(3 << resolution));
	I2CMasterStart (BMP085_BASE | I2C_READ); // #R/W = 1
/*	temp = ((int32_t) I2CMasterReadAck() << 16);
	temp |= ((int32_t) I2CMasterReadAck() << 8);
	temp |= (int32_t) I2CMasterReadNak();
	temp = (temp >> (8-resolution));
*/
	msb= I2CMasterReadAck();
	lsb= I2CMasterReadAck();
	xlsb=I2CMasterReadNak();
	
	temp=((int32_t)msb << 16 | lsb << 8 | xlsb) >> (8-resolution);
	
	
	I2CMasterStop();
	return temp;
}

uint8_t bmp085_get_values(bmp085Calib Calib_data, int32_t* temperature, int32_t* pressure, uint8_t resolution)
{

	int32_t ut=0;
	int32_t up=0;
	int32_t x1, x2, b5, b6, x3, b3, p;
	uint32_t b4, b7;


	ut = bmp085_read_temp_raw();

	up = bmp085_read_pressure_raw(resolution);

	
	x1 = ((int32_t)ut - Calib_data.AC6) * ((int32_t)Calib_data.AC5 >> 15);
	x2 = ((int32_t)Calib_data.MC << 11) / ((int32_t)x1 + Calib_data.MD);
	b5 = x1 + x2;
	*temperature = (b5 + 8) >> 4;
	
	b6 = b5 - 4000;
	x1 = (Calib_data.B2 * ((b6 * b6) >> 12)) >> 11;
	x2 = (Calib_data.AC2 * b6) >> 11;
	x3 = x1 + x2;
	b3 = ((((Calib_data.AC1) * 4 + x3)<<resolution) + 2)>> 2;
	x1 = (Calib_data.AC3 * b6) >> 13;
	x2 = (Calib_data.B1 * ((b6 * b6) >> 12)) >> 16;
	x3 = ((x1 + x2) + 2) >> 2;
	b4 = (Calib_data.AC4 * (uint32_t) (x3 + 32768)) >> 15;
	b7 = ((uint32_t) (up - b3) * (50000 >> resolution));
	
	if (b7 < 0x80000000)
	{
		p = (b7 << 1) / b4;
	}
	else
	{
		p = (b7 / b4) << 1;
	}

	x1 = (p >> 8) * (p >> 8);
	x1 = (x1 * 3038) >> 16;
	x2 = (-7357 * p) >> 16;
	*pressure = p + ((x1 + x2 + 3791) >> 4);
	
	return 0;
}

