/*
 * BMP085.h
 *
 * Created: 10.11.2014 20:51:38
 *  Author: Michael
 
 BMP085 Pin	Pin Function
 VCC	Power (1.8V-3.6V)
 GND	Ground
 EOC	End of conversion output
 XCLR	Master Clear (low-active)
 SCL	Serial Clock I/O
 SDA	Serial Data I/O
 */ 


#ifndef BMP085_H_
#define BMP085_H_

#define DDR_EOC   DDRA
#define PORT_EOC  PORTA
#define PIN_EOC   PINA
#define EOC       PA0


#define BMP085_BASE 0xEE
#define EPROM_START 0xAA
#define CTRL_REG_ADR 0xF4
#define CTRL_REG_TEMP 0x2E	//temperature -> Conversion time 4.5ms
#define CTRL_REG_PRESS 0x34	//pressure
#define CTRL_REG_PR_ULP 0x00	//pressure, ultra low power -> Conversion time 4.5ms
#define CTRL_REG_PR_STD 0x01	//pressure, standart -> Conversion time 7.5ms
#define CTRL_REG_PR_HR 0x02	//pressure, high resolution -> Conversion time 13.5ms
#define CTRL_REG_PR_UHR 0x03	//pressure, ultra high resolution -> Conversion time 25.5ms


#define CONVERSION_COMPLETED			(PIN_EOC & (1 << EOC))
#define CONVERSION_RUNNING				!(PIN_EOC & (1 << EOC))

#include "I2CMaster.h"

typedef struct bmp085Calib {
	int16_t AC1;
	int16_t AC2;
	int16_t AC3;
	uint16_t AC4;
	uint16_t AC5;
	uint16_t AC6;
	int16_t B1;
	int16_t B2;	
	int16_t MB;	
	int16_t MC;	
	int16_t MD;	
} bmp085Calib;

extern uint8_t bmp085_Init(bmp085Calib* Calib_data);

extern int32_t bmp085_read_temp_raw(void);

extern int32_t bmp085_read_pressure_raw(uint8_t resolution);

uint8_t bmp085_get_values(bmp085Calib Calib_data, int32_t* temperature, int32_t* pressure, uint8_t resolution);

#endif /* BMP085_H_ */