/*
 * Haussteuerung.cpp
 *
 * Created: 10.11.2014 19:47:46
 *  Author: Michael
 */ 


#define F_CPU 16000000UL

enum buttons {none=0, sel, left, right, up, down};

#ifdef __cplusplus
extern "C" {
	#endif

#include <stdlib.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <avr/eeprom.h>
#include <util/delay.h>
#include <string.h>
#include <stdint.h>
#include "lcd.h"
#include "ADC.h"
#include "onewire.h"
#include "ds18x20.h"
#include "USART.h"
#include "BMP085.h"
#include "Wait.h"
#include "spi.h"
#include "w5100.h"
#include "socket.h"

#ifdef __cplusplus
}
#endif

#define BAUD 9600


#define NEWLINESTR "\r\n"

#define TIM5_PRELOAD -12500
#define MEASUREMENT_CYCLE 5 //Sekunden
#define FORCE_MEASUREMENT 255



uint8_t gSensorIDs[MAXSENSORS][OW_ROMCODE_SIZE];
char temperatures [MAXSENSORS][6];
uint8_t SensorID=1;
uint8_t nSensors, i;
volatile uint8_t tim5cnt=0;
volatile uint8_t meascnt=0;
int16_t decicelsius;
uint8_t error;
bmp085Calib bmp085_calib_data;
int32_t outtemp, outpress;
char buffer0[16];

static uint8_t search_sensors(void)
{
	uint8_t i;
	uint8_t id[OW_ROMCODE_SIZE];
	uint8_t diff, nSensors;
	
	printf( NEWLINESTR "Scanning Bus for DS18X20" NEWLINESTR );
	
	ow_reset();

	nSensors = 0;
	
	diff = OW_SEARCH_FIRST;
	while ( diff != OW_LAST_DEVICE && nSensors < MAXSENSORS ) {
		DS18X20_find_sensor( &diff, &id[0] );
		
		if( diff == OW_PRESENCE_ERR ) {
			printf( "No Sensor found" NEWLINESTR );
			break;
		}
		
		if( diff == OW_DATA_ERR ) {
			printf( "Bus Error" NEWLINESTR );
			break;
		}
		
		for ( i=0; i < OW_ROMCODE_SIZE; i++ )
		gSensorIDs[nSensors][i] = id[i];
		
		nSensors++;
	}
	
	return nSensors;
}

static void uart_put_temp(int16_t decicelsius)
{
	char s[10];

	printf("%i, decicelsius");
	DS18X20_format_from_decicelsius( decicelsius, s, 10 );
	printf("%s", s);
	printf(" C");
}


#if DS18X20_MAX_RESOLUTION

static void uart_put_temp_maxres(int32_t tval)
{
	char s[10];

	printf("%i", (int)tval);
	printf(" Ce-4, ");
	DS18X20_format_from_maxres( tval, s, 10 );
	printf("%s", s);
	printf(" C");
}

#endif /* DS18X20_MAX_RESOLUTION */


#if DS18X20_EEPROMSUPPORT

static void th_tl_dump(uint8_t *sp)
{
	DS18X20_read_scratchpad( &gSensorIDs[0][0], sp, DS18X20_SP_SIZE );
	printf( "TH/TL in scratchpad of sensor 1 now : " );
	printf("%i", sp[DS18X20_TH_REG]);
	printf( " / " );
	printf("%i", sp[DS18X20_TL_REG]);
	
	//	uart_puts_P( NEWLINESTR );
	printf( NEWLINESTR );
}

static void eeprom_test(void)
{
	uint8_t sp[DS18X20_SP_SIZE], th, tl;
	
	printf( NEWLINESTR "DS18x20 EEPROM support test for first sensor" NEWLINESTR );
	th_tl_dump( sp );
	th = sp[DS18X20_TH_REG];
	tl = sp[DS18X20_TL_REG];
	tl++;
	th++;
	DS18X20_write_scratchpad( &gSensorIDs[0][0], th, tl, DS18B20_12_BIT );
	printf( "TH+1 and TL+1 written to scratchpad" NEWLINESTR );
	th_tl_dump( sp );
	DS18X20_scratchpad_to_eeprom( DS18X20_POWER_PARASITE, &gSensorIDs[0][0] );
	printf( "scratchpad copied to DS18x20 EEPROM" NEWLINESTR );
	DS18X20_write_scratchpad( &gSensorIDs[0][0], 0, 0, DS18B20_12_BIT );
	printf( "TH and TL in scratchpad set to 0" NEWLINESTR );
	th_tl_dump( sp );
	DS18X20_eeprom_to_scratchpad(&gSensorIDs[0][0]);
	printf( "DS18x20 EEPROM copied back to scratchpad" NEWLINESTR );
	DS18X20_read_scratchpad( &gSensorIDs[0][0], sp, DS18X20_SP_SIZE );
	if ( ( th == sp[DS18X20_TH_REG] ) && ( tl == sp[DS18X20_TL_REG] ) ) {
		printf( "TH and TL verified" NEWLINESTR );
		} else {
		printf( "verify failed" NEWLINESTR );
	}
	th_tl_dump( sp );
}
#endif /* DS18X20_EEPROMSUPPORT */

void sensortest (void)
{
	error = 0;

	if ( nSensors == 0 ) {
		error++;
	}

	printf( NEWLINESTR "Convert_T and Read Sensor by Sensor (reverse order)" NEWLINESTR );
	for ( i = nSensors; i > 0; i-- ) {
		if ( DS18X20_start_meas( DS18X20_POWER_PARASITE,
		&gSensorIDs[i-1][0] ) == DS18X20_OK ) {
			_delay_ms( DS18B20_TCONV_12BIT );
			printf( "Sensor# " );
			printf("%i", (int) i );
			printf(" = ");
			if ( DS18X20_read_decicelsius( &gSensorIDs[i-1][0], &decicelsius)
			== DS18X20_OK ) {
				uart_put_temp( decicelsius );
				} else {
				printf( "CRC Error (lost connection?)" );
				error++;
			}
			printf( NEWLINESTR );
		}
		else {
			printf( "Start meas. failed (short circuit?)" );
			error++;
		}
	}
	
	printf( NEWLINESTR "Convert_T for all Sensors and Read Sensor by Sensor" NEWLINESTR );
	if ( DS18X20_start_meas( DS18X20_POWER_PARASITE, NULL )
	== DS18X20_OK) {
		_delay_ms( DS18B20_TCONV_12BIT );
		for ( i = 0; i < nSensors; i++ ) {
			printf( "Sensor# " );
			printf("%i", (int)i + 1 );
			printf(" = ");
			if ( DS18X20_read_decicelsius( &gSensorIDs[i][0], &decicelsius )
			== DS18X20_OK ) {
				uart_put_temp( decicelsius );
			}
			else {
				printf( "CRC Error (lost connection?)" );
				error++;
			}
			printf( NEWLINESTR );
		}
		#if DS18X20_MAX_RESOLUTION
		int32_t temp_eminus4;
		for ( i = 0; i < nSensors; i++ ) {
			printf( "Sensor# " );
			printf("%i", (i+1) );
			printf(" = ");
			if ( DS18X20_read_maxres( &gSensorIDs[i][0], &temp_eminus4 )
			== DS18X20_OK ) {
				uart_put_temp_maxres( temp_eminus4 );
			}
			else {
				printf( "CRC Error (lost connection?)" );
				error++;
			}
			printf( NEWLINESTR );
		}
		#endif
	}
	else {
		printf( "Start meas. failed (short circuit?)" );
		error++;
	}


	#if DS18X20_VERBOSE
	// all devices:
	printf( NEWLINESTR "Verbose output" NEWLINESTR );
	DS18X20_start_meas( DS18X20_POWER_PARASITE, NULL );
	_delay_ms( DS18B20_TCONV_12BIT );
	DS18X20_read_meas_all_verbose();
	#endif

	if ( error ) {
		printf( "*** problems - rescanning bus ..." );
		nSensors = search_sensors();
		printf("%i", (int) nSensors );
		printf( " DS18X20 Sensor(s) available" NEWLINESTR );
		error = 0;
	}
}


// Timer5 overflow interrupt service routine
ISR (TIMER5_OVF_vect)	//alle 50ms
{
	TCNT5 = TIM5_PRELOAD;
	tim5cnt++;
	if(tim5cnt>20)
	{					//jede Sekunde
		tim5cnt=0;
		meascnt++;
	}
}


int main( void )
{
	int result0;
	enum buttons taste=none;

	lcd_init(LCD_DISP_ON);
	USARTInit(0, BAUD, 0, 0, 1, 0);		// receiver enabled
	ADCInit(ADC_VREF_TYPE_EXTERNAL_AVCC);
	
	lcd_gotoxy(0,0);
	lcd_puts("Temperaturen");
	
	
	//Timer-Config, normal Mode, Prescaler 1/64
	//Timerclock = 250kHz -> T=4us -> 12500 clks -> OVF Int.
	TCCR5A = 0x00;
	TCCR5B |= ((1<<CS50) | (1<<CS51) | (0<<CS52));
	TIMSK5 |= (1<<TOIE5);
	TCNT5 = TIM5_PRELOAD;
	

	
	#ifndef OW_ONE_BUS
	ow_set_bus(&PINL,&PORTL,&DDRL,PL0);
	#endif
	
	
	printf( NEWLINESTR "DS18X20 1-Wire-Reader " NEWLINESTR );
	printf(            "-------------------------------------------" );
	
	nSensors = search_sensors();
	printf("%i", (int)nSensors);
	printf( " DS18X20 Sensor(s) available:" NEWLINESTR );
	
	for (i = 0; i < nSensors; i++ ) {
		printf("# in Bus :");
		printf("%i", (int)i + 1);
		printf(" : ");
		DS18X20_show_id_uart( &gSensorIDs[i][0], OW_ROMCODE_SIZE );
		printf( NEWLINESTR );
	}
	
	
	for ( i = 0; i < nSensors; i++ ) {
		printf( "Sensor# " );
		printf("%i", (int)i+1 );
		printf( " is a " );
		if ( gSensorIDs[i][0] == DS18S20_FAMILY_CODE ) {
			printf( "DS18S20/DS1820" );
			} else if ( gSensorIDs[i][0] == DS1822_FAMILY_CODE ) {
			printf( "DS1822" );
		}
		else {
			printf( "DS18B20" );
		}
		printf( " which is " );
		if ( DS18X20_get_power_status( &gSensorIDs[i][0] ) == DS18X20_POWER_PARASITE ) {
			printf( "parasite" );
			} else {
			printf( "externally" );
		}
		printf( " powered" NEWLINESTR );
	}
	

	SensorID=nSensors;
	
	I2CMasterEnable();
	I2CMasterInit(10000);
	
	bmp085_Init(&bmp085_calib_data);
	

	printf( NEWLINESTR "BMP085-Calibration data:" NEWLINESTR );
	printf("AC1: %i", bmp085_calib_data.AC1);
	printf( NEWLINESTR "AC2: %i", bmp085_calib_data.AC2);
	printf( NEWLINESTR "AC3: %i", bmp085_calib_data.AC3);
	printf( NEWLINESTR "AC4: %i", bmp085_calib_data.AC4);
	printf( NEWLINESTR "AC5: %i", bmp085_calib_data.AC5);
	printf( NEWLINESTR "AC6: %i", bmp085_calib_data.AC6);
	printf( NEWLINESTR "B1: %i", bmp085_calib_data.B1);
	printf( NEWLINESTR "B2: %i", bmp085_calib_data.B2);
	printf( NEWLINESTR "MB: %i", bmp085_calib_data.MB);
	printf( NEWLINESTR "MC: %i", bmp085_calib_data.MC);
	printf( NEWLINESTR "MD: %i", bmp085_calib_data.MD);
	
	outtemp=bmp085_read_temp_raw();
	outpress=bmp085_read_pressure_raw(CTRL_REG_PR_STD);
	printf( NEWLINESTR "Temperatur-Rohdaten: %i", (int)outtemp);
	printf( NEWLINESTR "Druck-Rohdaten: %i", (int)outpress);
	bmp085_get_values(bmp085_calib_data, &outtemp, &outpress, CTRL_REG_PR_UHR);
	printf( NEWLINESTR "Temperatur (UHR): %i", (int)outtemp);
	printf( NEWLINESTR "Druck (UHR): %i", (int)outpress);
	bmp085_get_values(bmp085_calib_data, &outtemp, &outpress, CTRL_REG_PR_HR);
	printf( NEWLINESTR "Temperatur (HR): %i", (int)outtemp);
	printf( NEWLINESTR "Druck (HR): %i", (int)outpress);
	bmp085_get_values(bmp085_calib_data, &outtemp, &outpress, CTRL_REG_PR_STD);
	printf( NEWLINESTR "Temperatur (STD): %i", (int)outtemp);
	printf( NEWLINESTR "Druck (STD): %i", (int)outpress);
	bmp085_get_values(bmp085_calib_data, &outtemp, &outpress, CTRL_REG_PR_ULP);
	printf( NEWLINESTR "Temperatur (ULP): %i", (int)outtemp);
	printf( NEWLINESTR "Druck (ULP): %i", (int)outpress);
	
	// Port B initialization
	// Function: Bit7=In Bit6=In Bit5=In Bit4=In Bit3=In Bit2=Out Bit1=Out Bit0=Out
	DDRB=(0<<DDB7) | (0<<DDB6) | (0<<DDB5) | (0<<DDB4) | (0<<DDB3) | (1<<DDB2) | (1<<DDB1) | (1<<DDB0);
	// State: Bit7=T Bit6=T Bit5=T Bit4=T Bit3=T Bit2=0 Bit1=0 Bit0=0
	PORTB=(0<<PB7) | (0<<PB6) | (0<<PB5) | (1<<PB4) | (0<<PB3) | (0<<PB2) | (0<<PB1) | (1<<PB0);
	
	DDRG=(1<<DDG5);
	PORTG=(1<<PG5);

	
	//SPI_IO_Init();
	printf( NEWLINESTR "SPI-IO Init done" );
	WaitMs(50);
	HTTP_Init();
	printf( NEWLINESTR "HTTP-Init done" NEWLINESTR );


	
/*	
	sei();
*/	
	while(1)
	{   // main loop
		result0=ADCReadChannel(2);	//Buttons
		
		if (meascnt>=MEASUREMENT_CYCLE)
		{
			meascnt=0;
						if (SensorID<nSensors)
						{
							SensorID++;
						}
						else
						{
							SensorID=1;
						}
			lcd_gotoxy(0,0);
			switch(SensorID)
			{
				case 1:
				bmp085_get_values(bmp085_calib_data, &outtemp, &outpress, CTRL_REG_PR_UHR);
				printf( NEWLINESTR "Temperatur (UHR): %i", (int)outtemp);
				printf( NEWLINESTR "Druck (UHR): %i" NEWLINESTR, (int)outpress);
				lcd_puts("Wohnzimmer   ");
				printf("Wohnzimmer:");
				break;
				case 2:
				lcd_puts("Schlafzimmer ");
				printf("Schlafzimmer:");
				break;
				case 3:
				lcd_puts("Kinderzimmer");
				printf("Kinderzimmer:");
				break;
				case 10:
				lcd_puts("Kueche");
				printf("Kueche:");
				default:
				lcd_puts("Zimmer      ");
				printf("Zimmer:");
				break;
			}
			
			if ( DS18X20_start_meas( DS18X20_POWER_EXTERN, NULL )== DS18X20_OK)
			{
				_delay_ms( DS18B20_TCONV_12BIT );
				
				if ( DS18X20_read_decicelsius( &gSensorIDs[SensorID-1][0], &decicelsius ) == DS18X20_OK )
				{
					DS18X20_format_from_decicelsius( decicelsius, temperatures[SensorID-1], 10 );
					printf("%s" NEWLINESTR, temperatures[SensorID-1]);
					lcd_gotoxy(9,1);
					lcd_puts(temperatures[SensorID-1]);
					lcd_gotoxy(14,1);
					lcd_puts("C");
					if ( SensorID == 10)
					{
						USARTgotoxy(1, 12);
					}
				}
				else
				{
					printf("---");
				}
			}
		}	//meascnt
		
		
		//	if ( DS18X20_read_decicelsius( &gSensorIDs[i-1][0], &decicelsius)
		//	== DS18X20_OK )

		
		if (result0>=880) taste=none;
		else if (result0>=618) taste=sel;
		else if (result0>=411) taste=left;
		else if (result0>=230) taste=down;
		else if (result0>=70)  taste=up;
		else	taste=right;
				
/*		if (SensorID != SensorID_old)
		{
			meascnt=FORCE_MEASUREMENT;	//Sensorauswertung forcieren
			sprintf(buffer0, "%02i", SensorID);
			lcd_gotoxy(0, 1);
			lcd_puts(buffer0);
			lcd_gotoxy(0,0);
			SensorID_old=SensorID;
		}
*/

	}//while(1)

}//main
