/*
 * TPFilt.c
 *
 * Created: 20.12.2014 19:18:07
 *  Author: Michael
 */ 

#include "TPfilt.h"


uint16_t adc_filt(uint16_t newval)
{
	static uint8_t n = 0;
	static uint16_t avgsum = 0;

	if (n<AVG_FILTER)
	{
		n++;
		avgsum += newval;
		return avgsum/n;
	}
	else
	{
		avgsum -= avgsum/AVG_FILTER;
		avgsum += newval;
		return avgsum/AVG_FILTER;
	}
}


uint16_t tp_filter(uint16_t newval, uint8_t avg_filter, uint16_t* avgsum, uint8_t* n)
{
	if (n<avg_filter)
	{
		*n++;
		*avgsum += newval;
		return *avgsum/(*n);
	}
	else
	{
		*avgsum -= *avgsum/((uint16_t)avg_filter);
		*avgsum += newval;
		return *avgsum/(avg_filter);
	}
}