/***************************************************************************//**
Implementation file file for a simple wait routine (waits in ms).

@author LiTec/PAMG
@date 10.01.2010
@version 1.0

@param compiler switches: none
@param linker switches: none

@b History:
- 1.0 LiTec/PAMG 10.01.2010 initial version.
*******************************************************************************/
/** @addtogroup WAIT_api
@{*/
/** @file Wait.c Main source file for a simple wait routine. */
#include "Wait.h"

/***************************************************************************//**
Function for a simple wait based on the AVR-Lib (delay)
@note the time is dependent on the processor clock! -> define F_CPU=16000000UL
@param msec time to wait in ms
@retval - none
*******************************************************************************/
void WaitMs ( uint16_t msec ) {
#ifndef DEBUG_WITHOUT_WAIT
  uint16_t i; // counter
  for (i=0; i<msec; i++) {
  	_delay_ms ( 1 );
  }
#endif
}
/**@}*/
