/////////////////////////////////////////////////////////////////////////////////////////
//
// FAT
//
// --------------------------------------------------------------------------------------
//
// Filename:      fat.h
// Version:       1.0
// Date:          15/10/2011
// Author:        Joel Guittet - http://myfreescalewebpage.free.fr
//
/////////////////////////////////////////////////////////////////////////////////////////
//
// Revisions
//
// Version	| Author		| Description
// --------------------------------------------------------------------------------------
//			|				| 
//
/////////////////////////////////////////////////////////////////////////////////////////


#ifndef FAT_H_
#define FAT_H_


//---------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------

#include "sd.h"


//---------------------------------------------------------------------------------------
// FAT definitions
//---------------------------------------------------------------------------------------

#define SWAP16(int16)						(((int16 & 0x00FF) << 8) + ((int16 & 0xFF00) >> 8))
#define SWAP32(int32)						(((int32 & 0x000000FF) << 24) + ((int32 & 0x0000FF00) << 8) + ((int32 & 0x00FF0000) >> 8) + ((int32 & 0xFF000000) >> 24))

#define FILE_CLEAR          				(0x00)
#define FILE_ERASED         				(0xE5)

#define FILE_AT_READONLY         			(0x01)
#define FILE_AT_HIDDEN           			(0x02)
#define FILE_AT_SYSTEM           			(0x04)
#define FILE_AT_VOLUME           			(0x08)
#define FILE_AT_DIRECTORY        			(0x10)
#define FILE_AT_ARCHIVE          			(0x20)

/* Functions */
typedef enum 
{
    READ									= 0,
    CREATE									= 1,
    MODIFY									= 2,
    NEXT_ENTRY								= 3,
    WRITE_ENTRY								= 4
}
t_FileFunction;

/* Error Codes */
typedef enum 
{
    FILE_FOUND								= 0,
    FILE_NOT_FOUND							= 1,
    FILE_CREATE_OK							= 2,
    NO_FILE_ENTRY_AVAILABLE					= 3,
    NO_FAT_ENTRY_AVAIlABLE					= 4,
	ERROR_IDLE								= 5,
}
t_FileErrorCode;

/* File Handler Structures */
typedef struct
{
    uint16_t  FAT_Entry;
    uint16_t  SectorOffset;
    uint16_t  Dir_Entry;
    uint32_t  File_Size;
}
t_ReadFileHandler;

typedef struct
{
    uint8_t   FileName[8];
    uint8_t   Extension[3];
    uint16_t  Dir_Entry;
    uint32_t  File_Size;
    uint16_t  BaseFatEntry;
    uint16_t  CurrentFatEntry;
    uint16_t  SectorIndex;
    uint16_t  ClusterIndex;
}
t_WriteFileHandler;

/* Root Directory Structure */
typedef struct
{
    uint8_t   FileName[8];
    uint8_t   Extension[3];
    uint8_t   Attributes;
    uint8_t   Case;
    uint8_t   MiliSeconds;
    uint16_t  CreationTime;
    uint16_t  CreationDate;
    uint16_t  AccessDate;
    uint16_t  Reserved;
    uint16_t  ModificationTime;
    uint16_t  ModificationDate;
    uint16_t  ClusterNumber;
    uint32_t	SizeofFile;
}
t_RootEntries;

/* Partition Boot Sector Structure */
typedef struct
{
	/* Jump instruction */
    uint8_t   JMP_NOP[3];
    /* OEM Name in text */
    uint8_t   OEMName[8];
    /* BIOS Parameter Block */
    uint16_t  BytesPerSector;
    uint8_t   SectorsPerCluster;
    uint16_t  ReservedSectors;
    uint8_t   FatCopies;
    uint16_t  RootDirectoryEntries;
    uint16_t  SectorsLess32MB;
    uint8_t   MediaDescriptor;
    uint16_t  SectorsPerFat;
    uint16_t  SectorsPerTrack;
    uint16_t  NumberOfHeads;
    uint32_t  HiddenSectors;                     
    uint32_t  SectorsInPartition;
    /* Extended BIOS Parameter Block */
    uint16_t  LogicalNumberOfPartitions;
    uint8_t   ExtendedSignature;
    uint32_t  SerialNumber;
    uint8_t   VolumeNumber[11];
    uint8_t   FatName[8];
    /* Bootstrap code */
    uint8_t   ExcecutableCode[448];
    /* End of sector marker */
    uint8_t   ExcecutableMarker[2];
}
t_PartitionBootSector;


//---------------------------------------------------------------------------------------
// Prototypes
//---------------------------------------------------------------------------------------

void FAT_ReadBootSector(void);
uint8_t FAT_FileOpen(uint8_t * pu8FileName, uint8_t u8Function);
uint16_t FAT_FileRead(uint8_t * pu8UserBuffer);
void FAT_FileWrite(uint8_t * pu8DataPointer, uint32_t u32Size);
void FAT_FileClose(void);
uint32_t FAT_GetFileSize(void);
static void FAT_FileNameOrganizer(uint8_t * pu8FileName, uint8_t * pu8Destiny);
static uint16_t FAT_Entry(uint16_t u16FatEntry, uint16_t u16FatValue, uint8_t u8Function);
static uint16_t FAT_SearchAvailableFAT(uint16_t u16CurrentFAT);


#endif
