/////////////////////////////////////////////////////////////////////////////////////////
//
// Wiznet W5100 HTTP Server
//
// --------------------------------------------------------------------------------------
//
// Filename:      http.h
// Version:       1.0
// Date:          15/10/2011
// Author:        Joel Guittet - http://myfreescalewebpage.free.fr
//
/////////////////////////////////////////////////////////////////////////////////////////
//
// Revisions
//
// Version	| Author		| Description
// --------------------------------------------------------------------------------------
//			|				| 
//
/////////////////////////////////////////////////////////////////////////////////////////


#ifndef	HTTP_H_
#define	HTTP_H_


//---------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------

#include <string.h>
#include <stdio.h>
#include <avr/io.h>
#include <stdint.h>
#include "socket.h"
#include "dhcp.h"
#include "w5100.h"
#include "fat.h"
#include "sd.h"


//---------------------------------------------------------------------------------------
// Definitions
//---------------------------------------------------------------------------------------

#define HTTP_SOCKET							(0)						/* Socket used in W5100 device */
#define HTTP_PORT							(80)					/* HTTP Server Port, usually 80 */
#define HTTP_RX_BUFFER_SIZE					(128)					/* Size of the buffer for incoming messages */ 
#define HTTP_TX_BUFFER_SIZE					(SD_BLOCK_SIZE)			/* Size of the buffer for replying messages (imposed by SD Card library) */
#define HTTP_SOCK_ESTABLISHED_TIMEOUT		(10000)					/* Timeout used to disconnect the socket if nothing received from client */

#define NEWLINESTR "\r\n"


//---------------------------------------------------------------------------------------
// Prototypes
//---------------------------------------------------------------------------------------

void HTTP_Init(void);
void HTTP_Server(void);


#endif
