/////////////////////////////////////////////////////////////////////////////////////////
//
// Wiznet W5100 Sockets Interface
//
// --------------------------------------------------------------------------------------
//
// Filename:      socket.h
// Version:       1.0
// Date:          15/10/2011
// Author:        Joel Guittet - http://myfreescalewebpage.free.fr
//
/////////////////////////////////////////////////////////////////////////////////////////
//
// Revisions
//
// Version	| Author		| Description
// --------------------------------------------------------------------------------------
//			|				| 
//
/////////////////////////////////////////////////////////////////////////////////////////


#ifndef	SOCKET_H_
#define	SOCKET_H_


//---------------------------------------------------------------------------------------
// Includes
//---------------------------------------------------------------------------------------

#include <avr/io.h>
#include <stdint.h>
#include "w5100.h"


//---------------------------------------------------------------------------------------
// Prototypes
//---------------------------------------------------------------------------------------

uint8_t SOCKET_Open(uint8_t u8Socket, uint8_t u8Protocol, uint16_t u16Port, uint8_t u8Flag);
void SOCKET_Close(uint8_t u8Socket);
uint8_t SOCKET_Connect(uint8_t u8Socket, uint8_t * u8Address, uint16_t u16Port);
void SOCKET_Disconnect(uint8_t u8Socket);
uint8_t SOCKET_GetStatus(uint8_t u8Socket);
uint8_t SOCKET_Listen(uint8_t u8Socket);
int16_t SOCKET_Send(uint8_t u8Socket, uint8_t * u8Buffer, uint16_t u16Length);
int16_t SOCKET_Recv(uint8_t u8Socket, uint8_t * u8Buffer, uint16_t u16Length);
int16_t SOCKET_SendTo(uint8_t u8Socket, uint8_t * u8Buffer, uint16_t u16Length, uint8_t * u8Address, uint16_t u16Port);
int16_t SOCKET_RecvFrom(uint8_t u8Socket, uint8_t * u8Buffer, uint16_t u16Length, uint8_t * u8Address, uint16_t * u16Port);


#endif
